/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.debug;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class DroneDebugEntry {
    private final int progWidgetId;
    private final String message;
    private final BlockPos pos;
    private long receivedTime;

    public DroneDebugEntry(String message, int progWidgetId, BlockPos pos) {
        this.message = message;
        this.pos = pos != null ? pos : BlockPos.field_177992_a;
        this.progWidgetId = progWidgetId;
    }

    public DroneDebugEntry(PacketBuffer buf) {
        this.message = buf.func_218666_n();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.progWidgetId = buf.readInt();
        this.receivedTime = System.currentTimeMillis();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.message);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.progWidgetId);
    }

    public String getMessage() {
        return this.message;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getProgWidgetId() {
        return this.progWidgetId;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public boolean hasCoords() {
        return this.pos.func_177958_n() != 0 || this.pos.func_177956_o() != 0 || this.pos.func_177952_p() != 0;
    }
}

