/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneEmitting;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToClient;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ModuleRedstone
extends TubeModule
implements INetworkedModule {
    private EnumRedstoneDirection redstoneDirection = EnumRedstoneDirection.OUTPUT;
    private int inputLevel = -1;
    private int outputLevel;
    private int colorChannel;
    private Operation operation = Operation.PASSTHROUGH;
    private boolean inverted = false;
    private int otherColor = 0;
    private int constantVal = 0;
    private final byte[] prevLevels = new byte[16];
    public float extension = 1.0f;
    public float lastExtension;
    private boolean comparatorInput;

    public ModuleRedstone(ItemTubeModule itemTubeModule) {
        super(itemTubeModule);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void onNeighborBlockUpdate() {
        if (!this.comparatorInput) {
            this.updateInputLevel();
        }
    }

    @Override
    public void onNeighborTileUpdate() {
        if (this.comparatorInput) {
            this.updateInputLevel();
        }
    }

    @Override
    public double getWidth() {
        return 9.0;
    }

    @Override
    protected double getHeight() {
        return 5.0;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getTube().func_145831_w().field_72995_K) {
            byte[] levels = new byte[16];
            if (this.redstoneDirection == EnumRedstoneDirection.OUTPUT) {
                for (TubeModule module : ModuleNetworkManager.getInstance(this.getTube().func_145831_w()).getConnectedModules(this)) {
                    ModuleRedstone mr;
                    if (!(module instanceof ModuleRedstone) || (mr = (ModuleRedstone)module).getRedstoneDirection() != EnumRedstoneDirection.INPUT || mr.getInputLevel() <= levels[mr.getColorChannel()]) continue;
                    levels[mr.getColorChannel()] = (byte)mr.inputLevel;
                }
                int out = this.computeOutputSignal(this.outputLevel, levels);
                if (this.inverted) {
                    int n = out = out > 0 ? 0 : 15;
                }
                if (this.setOutputLevel(out)) {
                    NetworkHandler.sendToAllTracking((Object)new PacketSyncRedstoneModuleToClient(this), this.getTube());
                }
            } else if (this.inputLevel < 0) {
                this.updateInputLevel();
            }
            System.arraycopy(levels, 0, this.prevLevels, 0, 16);
        } else {
            this.lastExtension = this.extension;
            this.extension = this.redstoneDirection == EnumRedstoneDirection.OUTPUT ? Math.min(1.0f, this.extension + 0.125f) : Math.max(0.0f, this.extension - 0.125f);
        }
    }

    private int computeOutputSignal(int lastOutput, byte[] levels) {
        byte s1 = levels[this.getColorChannel()];
        byte s1prev = this.prevLevels[this.getColorChannel()];
        byte s2 = levels[this.otherColor];
        return this.operation.signalFunction.compute(lastOutput, s1, s2, this.getTube().func_145831_w().func_82737_E(), this.constantVal, s1 > s1prev);
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("input", this.redstoneDirection == EnumRedstoneDirection.INPUT);
        tag.func_74774_a("channel", (byte)this.colorChannel);
        tag.func_74774_a("outputLevel", (byte)this.outputLevel);
        tag.func_74778_a("op", this.operation.toString());
        tag.func_74774_a("color2", (byte)this.otherColor);
        tag.func_74768_a("const", (int)((byte)this.constantVal));
        tag.func_74757_a("invert", this.inverted);
        tag.func_74772_a("prevLevels", this.encodeLevels(this.prevLevels));
        tag.func_74757_a("comparatorInput", this.comparatorInput);
        return tag;
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.redstoneDirection = tag.func_74767_n("input") ? EnumRedstoneDirection.INPUT : EnumRedstoneDirection.OUTPUT;
        this.colorChannel = tag.func_74771_c("channel");
        this.outputLevel = tag.func_74771_c("outputLevel");
        try {
            this.operation = tag.func_74764_b("op") ? Operation.valueOf(tag.func_74779_i("op")) : Operation.PASSTHROUGH;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.operation = Operation.PASSTHROUGH;
        }
        this.otherColor = tag.func_74771_c("color2");
        this.constantVal = tag.func_150297_b("const", 1) ? (int)tag.func_74771_c("const") : tag.func_74762_e("const");
        this.inverted = tag.func_74767_n("invert");
        this.decodeLevels(tag.func_74763_f("prevLevels"), this.prevLevels);
        this.comparatorInput = tag.func_74767_n("comparatorInput");
    }

    private long encodeLevels(byte[] l) {
        return IntStream.range(0, l.length).mapToLong(i -> (long)l[i] << 4 * i).reduce(0L, (a, b) -> a | b);
    }

    private void decodeLevels(long l, byte[] res) {
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(l >> 4 * i | 0xFL);
        }
    }

    public EnumRedstoneDirection getRedstoneDirection() {
        return this.redstoneDirection;
    }

    public void setRedstoneDirection(EnumRedstoneDirection redstoneDirection) {
        this.redstoneDirection = redstoneDirection;
    }

    @Override
    public int getRedstoneLevel() {
        return this.redstoneDirection == EnumRedstoneDirection.OUTPUT ? this.outputLevel : 0;
    }

    public boolean setOutputLevel(int level) {
        if ((level = MathHelper.func_76125_a((int)level, (int)0, (int)15)) != this.outputLevel) {
            this.outputLevel = level;
            this.updateNeighbors();
            return true;
        }
        return false;
    }

    public int getInputLevel() {
        return this.inputLevel;
    }

    public void setInputLevel(int level) {
        this.inputLevel = level;
    }

    @Override
    public int getColorChannel() {
        return this.colorChannel;
    }

    @Override
    public void setColorChannel(int channel) {
        this.colorChannel = channel;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isComparatorInput() {
        return this.comparatorInput;
    }

    public void setComparatorInput(boolean comparatorInput) {
        this.comparatorInput = comparatorInput;
    }

    @Override
    public void addInfo(List<ITextComponent> curInfo) {
        super.addInfo(curInfo);
        if (this.getRedstoneDirection() == EnumRedstoneDirection.INPUT) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.waila.redstoneModule.receiving", this.inputLevel));
        } else {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.waila.redstoneModule.emitting", this.outputLevel));
            if (this.upgraded) {
                this.addAdvancedInfo(curInfo);
            }
        }
    }

    private void addAdvancedInfo(List<ITextComponent> curInfo) {
        TranslationTextComponent s = new TranslationTextComponent("pneumaticcraft.waila.redstoneModule.op", new Object[]{PneumaticCraftUtils.xlate(this.operation.getTranslationKey(), new Object[0])});
        if (this.operation.useOtherColor) {
            s = s.func_240702_b_(" (").func_230529_a_(PneumaticCraftUtils.dyeColorDesc(this.otherColor)).func_240702_b_(")");
        }
        if (this.operation.useConst) {
            s = s.func_240702_b_(" (" + this.constantVal + ")");
        }
        curInfo.add((ITextComponent)s);
        if (this.inverted) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.waila.redstoneModule.inverted", new Object[0]));
        }
    }

    @Override
    public boolean onActivated(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)heldStack);
        if (dyeColor != null) {
            int colorId = dyeColor.func_196059_a();
            this.setColorChannel(colorId);
            if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue() && !player.func_184812_l_()) {
                heldStack.func_190918_g(1);
            }
            return true;
        }
        if (ModdedWrenchUtils.getInstance().isWrench(heldStack)) {
            this.redstoneDirection = this.redstoneDirection == EnumRedstoneDirection.INPUT ? EnumRedstoneDirection.OUTPUT : EnumRedstoneDirection.INPUT;
            this.updateNeighbors();
            if (!this.updateInputLevel()) {
                NetworkHandler.sendToAllTracking((Object)new PacketSyncRedstoneModuleToClient(this), this.getTube());
            }
            return true;
        }
        return super.onActivated(player, hand);
    }

    private boolean updateInputLevel() {
        int newInputLevel = this.redstoneDirection == EnumRedstoneDirection.INPUT ? this.readInputLevel() : 0;
        if ((newInputLevel = Math.max(newInputLevel, this.pressureTube.tubeModules().filter(tm -> tm instanceof TubeModuleRedstoneEmitting).max(Comparator.comparingInt(TubeModule::getRedstoneLevel)).map(TubeModule::getRedstoneLevel).orElse(0))) != this.inputLevel) {
            this.inputLevel = newInputLevel;
            NetworkHandler.sendToAllTracking((Object)new PacketSyncRedstoneModuleToClient(this), this.getTube());
            return true;
        }
        return false;
    }

    private int readInputLevel() {
        World world = Objects.requireNonNull(this.pressureTube.func_145831_w());
        if (this.comparatorInput && this.upgraded) {
            BlockPos pos2 = this.pressureTube.func_174877_v().func_177972_a(this.getDirection());
            BlockState state = world.func_180495_p(pos2);
            return state.func_185912_n() ? state.func_185888_a(world, pos2) : 0;
        }
        return world.func_175651_c(this.pressureTube.func_174877_v().func_177972_a(this.getDirection()), this.getDirection());
    }

    public Operation getOperation() {
        return this.operation;
    }

    public int getOtherColor() {
        return this.otherColor;
    }

    public int getConstantVal() {
        return this.constantVal;
    }

    public void setOperation(Operation operation, int otherColor, int constantVal) {
        if (operation == Operation.CLOCK) {
            constantVal = Math.max(4, constantVal);
        }
        this.operation = operation;
        this.otherColor = otherColor;
        this.constantVal = constantVal;
    }

    @FunctionalInterface
    private static interface SignalFunction {
        public int compute(int var1, byte var2, byte var3, long var4, int var6, boolean var7);
    }

    public static enum Operation implements ITranslatableEnum
    {
        PASSTHROUGH(false, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1),
        AND(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 > 0 && s2 > 0 ? 15 : 0),
        OR(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 > 0 || s2 > 0 ? 15 : 0),
        XOR(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 == 0 && s2 == 0 || s1 > 0 && s2 > 0 ? 0 : 15),
        CLOCK(false, true, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 == 0 && timer % (long)constant < 2L ? 15 : 0, 4, Integer.MAX_VALUE),
        COMPARATOR(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 > s2 ? 15 : 0),
        SUBTRACT(true, false, (lastOutput, s1, s2, timer, constant, s1rising) -> MathHelper.func_76125_a((int)(s1 - s2), (int)0, (int)15)),
        COMPARE(false, true, (lastOutput, s1, s2, timer, constant, s1rising) -> s1 > constant ? 15 : 0, 0, 15),
        TOGGLE(false, false, (lastOutput, s1, s2, timer, constant, s1rising) -> s1rising ? (lastOutput > 0 ? 0 : 15) : lastOutput),
        CONSTANT(false, true, (lastOutput, s1, s2, timer, constant, s1rising) -> constant, 0, 15),
        COUNTER(false, true, (lastOutput, s1, s2, timer, constant, s1rising) -> s1rising ? (lastOutput + 1 > Math.min(15, constant) ? 0 : lastOutput + 1) : lastOutput, 0, 15);

        private final boolean useOtherColor;
        private final boolean useConst;
        private final int constMin;
        private final int constMax;
        private final SignalFunction signalFunction;

        private Operation(boolean useOtherColor, boolean useConst, SignalFunction signalFunction) {
            this(useOtherColor, useConst, signalFunction, 0, 0);
        }

        private Operation(boolean useOtherColor, boolean useConst, SignalFunction signalFunction, int constMin, int constMax) {
            this.useOtherColor = useOtherColor;
            this.useConst = useConst;
            this.signalFunction = signalFunction;
            this.constMin = constMin;
            this.constMax = constMax;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.redstoneModule.operation_" + this.toString().toLowerCase(Locale.ROOT);
        }

        public boolean useOtherColor() {
            return this.useOtherColor;
        }

        public boolean useConstant() {
            return this.useConst;
        }

        public int getConstMin() {
            return this.constMin;
        }

        public int getConstMax() {
            return this.constMax;
        }
    }

    public static enum EnumRedstoneDirection implements ITranslatableEnum
    {
        INPUT,
        OUTPUT;


        public EnumRedstoneDirection toggle() {
            return this == INPUT ? OUTPUT : INPUT;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.redstoneModule." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

