/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberValve;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockPressureChamberValve
extends BlockPneumaticCraft
implements IBlockPressureChamber {
    public static final BooleanProperty FORMED = BooleanProperty.func_177716_a((String)"formed");

    public BlockPressureChamberValve() {
        super(ModBlocks.defaultProps());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FORMED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityPressureChamberValve.class;
    }

    @Override
    public void func_180633_a(World par1World, BlockPos pos, BlockState state, LivingEntity par5EntityLiving, ItemStack iStack) {
        super.func_180633_a(par1World, pos, state, par5EntityLiving, iStack);
        if (!par1World.field_72995_K && TileEntityPressureChamberValve.checkIfProperlyFormed(par1World, pos)) {
            AdvancementTriggers.PRESSURE_CHAMBER.trigger((ServerPlayerEntity)par5EntityLiving);
        }
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FORMED});
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        if (player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            return PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityPressureChamberValve.class).map(te -> {
                if (te.multiBlockSize > 0) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)te, (BlockPos)pos);
                } else if (te.accessoryValves.size() > 0) {
                    for (TileEntityPressureChamberValve valve : te.accessoryValves) {
                        if (valve.multiBlockSize <= 0) continue;
                        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)valve, (BlockPos)valve.func_174877_v());
                        break;
                    }
                } else {
                    return ActionResultType.PASS;
                }
                return ActionResultType.SUCCESS;
            }).orElse(ActionResultType.SUCCESS);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.invalidateMultiBlock(world, pos);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private void invalidateMultiBlock(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityPressureChamberValve.class).ifPresent(teValve -> {
                if (teValve.multiBlockSize > 0) {
                    teValve.onMultiBlockBreak();
                } else if (teValve.accessoryValves.size() > 0) {
                    teValve.accessoryValves.stream().filter(valve -> valve.multiBlockSize > 0).findFirst().ifPresent(TileEntityPressureChamberValve::onMultiBlockBreak);
                }
            });
        }
    }
}

