/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import java.util.ArrayList;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.api.drone.AmadronRetrievalEvent;
import me.desht.pneumaticcraft.api.drone.DroneSuicideEvent;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.entity.living.EntityAmadrone;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.item.ItemAmadronTablet;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class EventHandlerAmadron {
    private static long reshuffleCounter = 0L;

    @SubscribeEvent
    public void onDroneSuicide(DroneSuicideEvent event) {
        if (event.drone instanceof EntityAmadrone) {
            EntityAmadrone drone = (EntityAmadrone)event.drone;
            AmadronRecipe offer = AmadronOfferManager.getInstance().getOffer(drone.getHandlingOffer());
            if (offer != null) {
                offer.getInput().accept(itemStack -> {
                    int i;
                    int requiredCount = offer.getInput().getAmount() * drone.getOfferTimes();
                    for (i = 0; i < drone.getInv().getSlots(); ++i) {
                        requiredCount -= drone.getInv().getStackInSlot(i).func_190916_E();
                    }
                    if (requiredCount <= 0) {
                        for (i = 0; i < drone.getInv().getSlots(); ++i) {
                            drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                    } else {
                        this.onAmadronFailure(drone, offer);
                    }
                }, fluidStack -> {
                    int requiredCount = offer.getInput().getAmount() * drone.getOfferTimes();
                    if (drone.getFluidTank().getFluidAmount() >= requiredCount) {
                        MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                    } else {
                        this.onAmadronFailure(drone, offer);
                    }
                });
            }
        }
    }

    private void onAmadronFailure(EntityAmadrone drone, AmadronRecipe offer) {
        if (offer instanceof AmadronPlayerOffer || offer.getMaxStock() >= 0) {
            offer.setStock(offer.getStock() + drone.getOfferTimes());
            if (offer instanceof AmadronPlayerOffer) {
                AmadronPlayerOffers.save();
            }
            NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(offer.func_199560_c(), offer.getStock()));
        }
    }

    @SubscribeEvent
    public void onAmadronSuccess(AmadronRetrievalEvent event) {
        EntityAmadrone drone = (EntityAmadrone)event.drone;
        AmadronRecipe offer = AmadronOfferManager.getInstance().getOffer(drone.getHandlingOffer());
        AmadronPlayerOffer playerOffer = this.getPlayerOffer(offer);
        if (playerOffer == null) {
            this.doDelivery(drone, offer);
        } else {
            if (drone.getAmadronAction() == EntityAmadrone.AmadronAction.TAKING_PAYMENT) {
                if (offer instanceof AmadronPlayerOffer) {
                    ((AmadronPlayerOffer)offer).addPayment(drone.getOfferTimes());
                }
                playerOffer.onTrade(drone.getOfferTimes(), drone.getBuyingPlayer());
                this.doDelivery(drone, offer);
            } else if (drone.getAmadronAction() == EntityAmadrone.AmadronAction.RESTOCKING) {
                playerOffer.setStock(playerOffer.getStock() + drone.getOfferTimes());
                NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(playerOffer.func_199560_c(), playerOffer.getStock()));
                playerOffer.notifyRestock();
            }
            AmadronPlayerOffers.save();
        }
    }

    private void doDelivery(EntityAmadrone drone, AmadronRecipe offer) {
        ItemStack usedTablet = drone.getUsedTablet();
        offer.getOutput().accept(itemStack -> {
            GlobalPos itemPos = ItemAmadronTablet.getItemProvidingLocation(usedTablet);
            if (itemPos != null) {
                ItemStack stack;
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int toDeliver = itemStack.func_190916_E() * drone.getOfferTimes(); toDeliver > 0; toDeliver -= stack.func_190916_E()) {
                    stack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)Math.min(toDeliver, itemStack.func_77976_d()));
                    stacks.add(stack);
                }
                DroneRegistry.getInstance().deliverItemsAmazonStyle(itemPos, stacks.toArray(new ItemStack[0]));
            }
        }, fluidStack -> {
            GlobalPos fluidPos = ItemAmadronTablet.getFluidProvidingLocation(usedTablet);
            if (fluidPos != null) {
                FluidStack offeringFluid = fluidStack.copy();
                offeringFluid.setAmount(offeringFluid.getAmount() * drone.getOfferTimes());
                DroneRegistry.getInstance().deliverFluidAmazonStyle(fluidPos, offeringFluid);
            }
        });
    }

    @SubscribeEvent
    public void amadronHousekeeping(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerWorld overWorld;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (reshuffleCounter++ >= (long)((Integer)ConfigHelper.common().amadron.reshuffleInterval.get()).intValue() && !this.anyPlayerUsingAmadron(server)) {
                AmadronOfferManager.getInstance().compileActiveOffersList();
                reshuffleCounter = 0L;
            }
            if (server.func_71259_af() % 600 == 0) {
                AmadronOfferManager.getInstance().tryRestockPlayerOffers();
            }
            if ((overWorld = server.func_71218_a(World.field_234918_g_)) != null) {
                AmadronOfferManager.getInstance().checkForFullRebuild((World)overWorld);
            }
        }
    }

    private boolean anyPlayerUsingAmadron(MinecraftServer server) {
        return server.func_184103_al().func_181057_v().stream().anyMatch(player -> player.field_71070_bA instanceof ContainerAmadron);
    }

    private AmadronPlayerOffer getPlayerOffer(AmadronRecipe offer) {
        AmadronRecipe o = AmadronOfferManager.getInstance().getOffer(AmadronPlayerOffer.getReversedId(offer.func_199560_c()));
        return o instanceof AmadronPlayerOffer ? (AmadronPlayerOffer)o : null;
    }
}

