/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DroneClaimManager {
    private static final Map<ResourceLocation, DroneClaimManager> claimManagers = new HashMap<ResourceLocation, DroneClaimManager>();
    private final Map<BlockPos, Integer> currentPositions = new HashMap<BlockPos, Integer>();
    private static final int TIMEOUT = 4;

    public static DroneClaimManager getInstance(World world) {
        return claimManagers.computeIfAbsent(world.func_234923_W_().func_240901_a_(), k -> new DroneClaimManager());
    }

    public void update() {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.currentPositions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            if (entry.getValue() < 4) {
                entry.setValue(entry.getValue() + 1);
                continue;
            }
            iterator.remove();
        }
    }

    boolean isClaimed(BlockPos pos) {
        return this.currentPositions.containsKey(pos);
    }

    void claim(BlockPos pos) {
        this.currentPositions.put(pos, 0);
    }
}

