/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneEntityBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAIEntityImport
extends DroneEntityBase<IEntityProvider, Entity> {
    public DroneAIEntityImport(IDroneBase drone, IEntityProvider progWidget) {
        super(drone, progWidget);
    }

    @Override
    protected boolean isEntityValid(Entity entity) {
        if (entity instanceof LivingEntity || entity instanceof AbstractMinecartEntity || entity instanceof BoatEntity) {
            return this.drone.getCarryingEntities().isEmpty();
        }
        if (((Boolean)ConfigHelper.common().general.dronesCanImportXPOrbs.get()).booleanValue() && entity instanceof ExperienceOrbEntity) {
            return this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> PneumaticCraftUtils.fillTankWithOrb(handler, (ExperienceOrbEntity)entity, IFluidHandler.FluidAction.SIMULATE)).orElse(false);
        }
        return false;
    }

    @Override
    protected boolean doAction() {
        if (((Boolean)ConfigHelper.common().general.dronesCanImportXPOrbs.get()).booleanValue() && this.targetedEntity instanceof ExperienceOrbEntity) {
            this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                ExperienceOrbEntity orb = (ExperienceOrbEntity)this.targetedEntity;
                ItemStack heldStack = this.drone.getInv().getStackInSlot(0);
                if (!heldStack.func_190926_b() && heldStack.func_77951_h() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)heldStack) > 0) {
                    int toRepair = Math.min((int)((float)orb.field_70530_e * heldStack.getXpRepairRatio()), heldStack.func_77952_i());
                    orb.field_70530_e -= toRepair / 2;
                    heldStack.func_196085_b(heldStack.func_77952_i() - toRepair);
                }
                if (orb.field_70530_e <= 0 || PneumaticCraftUtils.fillTankWithOrb(handler, orb, IFluidHandler.FluidAction.EXECUTE)) {
                    this.targetedEntity.func_70106_y();
                }
            });
        } else {
            this.drone.setCarryingEntity(this.targetedEntity);
        }
        return false;
    }
}

