/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.tileentity.AbstractTileModelRenderer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderElevatorBase
extends AbstractTileModelRenderer<TileEntityElevatorBase> {
    private static final float FACTOR = 0.5625f;
    private static final float[] SHADE = new float[]{1.0f, 0.85f, 0.7f, 0.55f};
    private final ModelRenderer pole1 = new ModelRenderer(64, 64, 28, 41);
    private final ModelRenderer pole2;
    private final ModelRenderer pole3;
    private final ModelRenderer pole4;
    private final ModelRenderer floor;

    public RenderElevatorBase(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.pole1.func_78793_a(17.0f, 9.0f, -1.0f);
        this.pole1.func_228303_a_(-19.5f, 0.0f, -1.5f, 5.0f, 14.0f, 5.0f, 0.0f, true);
        this.pole2 = new ModelRenderer(64, 64, 32, 19);
        this.pole2.func_78793_a(12.0f, 9.0f, -2.0f);
        this.pole2.func_228303_a_(-15.0f, 0.0f, -1.0f, 6.0f, 14.0f, 6.0f, 0.0f, true);
        this.pole3 = new ModelRenderer(64, 64, 0, 39);
        this.pole3.func_78793_a(5.0f, 9.0f, -12.0f);
        this.pole3.func_228303_a_(-8.5f, 0.0f, 8.5f, 7.0f, 14.0f, 7.0f, 0.0f, true);
        this.pole4 = new ModelRenderer(64, 64, 0, 17);
        this.pole4.func_78793_a(-4.0f, 9.0f, -4.0f);
        this.pole4.func_228303_a_(0.0f, 0.0f, 0.0f, 8.0f, 14.0f, 8.0f, 0.0f, true);
        this.floor = new ModelRenderer(64, 64, 0, 0);
        this.floor.func_78793_a(-8.0f, 8.0f, -8.0f);
        this.floor.func_228303_a_(0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f, 0.0f, false);
    }

    @Override
    public void renderModel(TileEntityElevatorBase te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.extension == 0.0) {
            return;
        }
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)Textures.MODEL_ELEVATOR));
        double extension = MathHelper.func_219803_d((double)partialTicks, (double)te.oldExtension, (double)te.extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole4, 0, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole3, 1, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole2, 2, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole1, 3, extension);
        this.floor.func_228308_a_(matrixStackIn, builder, te.lightAbove, combinedOverlayIn);
    }

    @Override
    protected void renderExtras(TileEntityElevatorBase te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.fakeFloorTextureUV != null && te.fakeFloorTextureUV.length == 4) {
            matrixStack.func_227860_a_();
            double extension = MathHelper.func_219803_d((double)partialTicks, (double)te.oldExtension, (double)te.extension);
            matrixStack.func_227861_a_(0.0, extension + (double)1.0005f, 0.0);
            IVertexBuilder builder = iRenderTypeBuffer.getBuffer(ModRenderTypes.getTextureRender(AtlasTexture.field_110575_b));
            float uMin = te.fakeFloorTextureUV[0];
            float vMin = te.fakeFloorTextureUV[1];
            float uMax = te.fakeFloorTextureUV[2];
            float vMax = te.fakeFloorTextureUV[3];
            Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
            builder.func_227888_a_(posMat, 0.0f, 0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMax).func_227886_a_(te.lightAbove).func_181675_d();
            builder.func_227888_a_(posMat, 1.0f, 0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMax).func_227886_a_(te.lightAbove).func_181675_d();
            builder.func_227888_a_(posMat, 1.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMin).func_227886_a_(te.lightAbove).func_181675_d();
            builder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMin).func_227886_a_(te.lightAbove).func_181675_d();
            matrixStack.func_227865_b_();
        }
    }

    private void renderPole(MatrixStack matrixStackIn, IVertexBuilder builder, int combinedLightIn, int combinedOverlayIn, ModelRenderer pole, int idx, double extension) {
        matrixStackIn.func_227861_a_(0.0, -extension / 4.0, 0.0);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.5625, 0.0);
        matrixStackIn.func_227862_a_(1.0f, (float)(extension * 16.0 / 14.0 / 4.0), 1.0f);
        matrixStackIn.func_227861_a_(0.0, -0.5625, 0.0);
        pole.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, SHADE[idx], SHADE[idx], SHADE[idx], 1.0f);
        matrixStackIn.func_227865_b_();
    }

    public boolean shouldRenderOffScreen(TileEntityElevatorBase te) {
        return true;
    }
}

