/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.EntityTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.EntityTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.SearchClientHandler;
import me.desht.pneumaticcraft.common.ai.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.EntityTrackerHandler;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityTrackerClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<EntityTrackerHandler> {
    private static final int ENTITY_TRACK_THRESHOLD = 7;
    private static final float ENTITY_TRACKING_RANGE = 16.0f;
    private final Map<Integer, RenderEntityTarget> targets = new HashMap<Integer, RenderEntityTarget>();
    private IGuiAnimatedStat entityTrackInfo;
    @Nonnull
    private EntityFilter entityFilter = new EntityFilter("");

    public EntityTrackerClientHandler() {
        super(ArmorUpgradeRegistry.getInstance().entityTrackerHandler);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        EntityFilter newFilter;
        ItemStack helmetStack;
        String filterStr;
        int rangeUpgrades = armorHandler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.RANGE);
        PlayerEntity player = armorHandler.getPlayer();
        if ((Minecraft.func_71410_x().field_71441_e.func_82737_E() & 0xFL) == 0L && WidgetKeybindCheckBox.isHandlerEnabled(ArmorUpgradeRegistry.getInstance().searchHandler)) {
            ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().searchHandler, SearchClientHandler.class).trackItemEntities(player, rangeUpgrades);
        }
        String string = filterStr = (helmetStack = player.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() ? "" : ItemPneumaticArmor.getEntityFilter(helmetStack);
        if (!this.entityFilter.toString().equals(filterStr) && (newFilter = EntityFilter.fromString(filterStr)) != null) {
            this.entityFilter = newFilter;
        }
        double entityTrackRange = 16.0f + (float)(rangeUpgrades * 5);
        AxisAlignedBB bbBox = EntityTrackerClientHandler.getAABBFromRange(player, rangeUpgrades);
        List entities = armorHandler.getPlayer().field_70170_p.func_175647_a(Entity.class, bbBox, (Predicate)((Object)new EntityTrackerSelector(player, this.entityFilter, entityTrackRange)));
        for (Entity entity : entities) {
            RenderEntityTarget target2 = this.targets.get(entity.func_145782_y());
            if (target2 != null) {
                target2.ticksExisted = Math.abs(target2.ticksExisted);
                continue;
            }
            this.targets.put(entity.func_145782_y(), new RenderEntityTarget(entity));
        }
        ArrayList toRemove = new ArrayList();
        this.targets.forEach((entityId, target) -> {
            if (!target.entity.func_70089_S() || (double)player.func_70032_d(target.entity) > entityTrackRange + 5.0 || !this.entityFilter.test(target.entity)) {
                if (target.ticksExisted > 0) {
                    target.ticksExisted = -60;
                } else if (target.ticksExisted == -1) {
                    toRemove.add(entityId);
                }
            }
        });
        toRemove.forEach(this.targets::remove);
        ArrayList<ITextComponent> text = new ArrayList<ITextComponent>();
        for (RenderEntityTarget target3 : this.targets.values()) {
            boolean wasNegative = target3.ticksExisted < 0;
            target3.ticksExisted += armorHandler.getSpeedFromUpgrades(EquipmentSlotType.HEAD);
            if (target3.ticksExisted >= 0 && wasNegative) {
                target3.ticksExisted = -1;
            }
            target3.update();
            if (!target3.isLookingAtTarget) continue;
            if (target3.isInitialized()) {
                text.add((ITextComponent)target3.entity.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.GRAY));
                text.addAll(target3.getEntityText());
                continue;
            }
            text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.acquiring", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        }
        if (text.isEmpty()) {
            String f = this.entityFilter.toString();
            text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.entityFilter", new Object[0]).func_240702_b_(": " + (f.isEmpty() ? "-" : f)));
        }
        this.entityTrackInfo.setText(text);
    }

    static AxisAlignedBB getAABBFromRange(PlayerEntity player, int rangeUpgrades) {
        double entityTrackRange = 16.0f + (float)(Math.min(10, rangeUpgrades) * 5);
        return new AxisAlignedBB(player.func_233580_cy_()).func_186662_g(entityTrackRange);
    }

    @Override
    public void render3D(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        this.targets.values().forEach(target -> target.render(matrixStack, buffer, partialTicks, this.targets.size() > 7));
    }

    @Override
    public void render2D(MatrixStack matrixStack, float partialTicks, boolean armorPieceHasPressure) {
    }

    @Override
    public void reset() {
        this.targets.clear();
        this.entityTrackInfo = null;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new EntityTrackOptions(screen, this);
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.entityTrackInfo == null) {
            WidgetAnimatedStat.StatIcon icon = WidgetAnimatedStat.StatIcon.of(EnumUpgrade.ENTITY_TRACKER.getItemStack());
            this.entityTrackInfo = new WidgetAnimatedStat(null, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.trackedEntities", new Object[0]), icon, HUDHandler.getInstance().getStatOverlayColor(), null, ArmorHUDLayout.INSTANCE.entityTrackerStat);
            this.entityTrackInfo.setMinimumContractedDimensions(0, 0);
            this.entityTrackInfo.setAutoLineWrap(false);
        }
        return this.entityTrackInfo;
    }

    public Stream<RenderEntityTarget> getTargetsStream() {
        return this.targets.values().stream();
    }

    public RenderEntityTarget getTargetForEntity(Entity entity) {
        return this.getTargetsStream().filter(target -> target.entity == entity).findFirst().orElse(null);
    }

    public void hack() {
        this.getTargetsStream().forEach(RenderEntityTarget::hack);
    }

    public void selectAsDebuggingTarget() {
        this.getTargetsStream().forEach(RenderEntityTarget::selectAsDebuggingTarget);
    }

    public boolean scroll(InputEvent.MouseScrollEvent event) {
        return this.getTargetsStream().anyMatch(target -> target.scroll(event));
    }

    @Override
    public void onResolutionChanged() {
        this.entityTrackInfo = null;
    }

    @Override
    public void setOverlayColor(int color) {
        super.setOverlayColor(color);
        this.targets.values().forEach(target -> target.updateColor(color));
    }

    private static class EntityTrackerSelector
    extends StringFilterEntitySelector {
        private final PlayerEntity player;
        private final double threshold;

        private EntityTrackerSelector(PlayerEntity player, EntityFilter filter, double threshold) {
            this.player = player;
            this.threshold = threshold;
            this.setFilter(Collections.singletonList(filter));
        }

        public boolean test(Entity entity) {
            return entity != this.player && (entity instanceof LivingEntity || entity instanceof HangingEntity || entity instanceof AbstractMinecartEntity) && entity.func_70089_S() && (double)this.player.func_70032_d(entity) < this.threshold && !MinecraftForge.EVENT_BUS.post((Event)new EntityTrackEvent(entity)) && super.test((Object)entity);
        }
    }
}

