/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.BlockTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.BlockTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.SearchClientHandler;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.BlockTrackerHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockTrackerClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<BlockTrackerHandler> {
    static final int BLOCK_TRACKING_RANGE = 30;
    private static final int HARD_MAX_BLOCKS_PER_TICK = 50000;
    private final Map<BlockPos, RenderBlockTarget> blockTargets = new Object2ObjectOpenHashMap();
    private IGuiAnimatedStat blockTrackInfo;
    private final Object2IntMap<ResourceLocation> blockTypeCount = new Object2IntOpenHashMap();
    private final Object2IntMap<ResourceLocation> blockTypeCountPartial = new Object2IntOpenHashMap();
    private int xOff = 0;
    private int yOff = 0;
    private int zOff = 0;
    private RenderBlockTarget focusedTarget = null;
    private Direction focusedFace = null;

    public BlockTrackerClientHandler() {
        super(ArmorUpgradeRegistry.getInstance().blockTrackerHandler);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        int blockTrackRange = 30 + Math.min(armorHandler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.RANGE), 5) * 5;
        int blockTrackRangeSq = blockTrackRange * blockTrackRange;
        long now = System.nanoTime();
        PlayerEntity player = armorHandler.getPlayer();
        World world = armorHandler.getPlayer().field_70170_p;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int i = 0; i < 50000 && ((i & 0xFF) != 0 || System.nanoTime() - now <= (long)((Integer)ConfigHelper.client().armor.blockTrackerMaxTimePerTick.get()).intValue() * 500000L); ++i) {
            List<IBlockTrackEntry> entries;
            TileEntity te;
            this.nextScanPos(pos, player, blockTrackRange);
            if (!world.isAreaLoaded((BlockPos)pos, 0)) break;
            if (world.func_175623_d((BlockPos)pos) || MinecraftForge.EVENT_BUS.post((Event)new BlockTrackEvent(world, (BlockPos)pos, te = world.func_175625_s((BlockPos)pos)))) continue;
            if (te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                SearchClientHandler searchHandler = ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().searchHandler, SearchClientHandler.class);
                searchHandler.checkInventoryForItems(te, null, WidgetKeybindCheckBox.isHandlerEnabled(ArmorUpgradeRegistry.getInstance().searchHandler));
            }
            if ((entries = BlockTrackEntryList.INSTANCE.getEntriesForCoordinate((IBlockReader)world, (BlockPos)pos, te)).isEmpty()) continue;
            entries.forEach(entry -> this.blockTypeCountPartial.mergeInt((Object)entry.getEntryID(), 1, Integer::sum));
            RenderBlockTarget blockTarget = this.blockTargets.get(pos);
            if (blockTarget != null) {
                blockTarget.ticksExisted = Math.abs(blockTarget.ticksExisted);
                blockTarget.setTileEntity(te);
                continue;
            }
            if (!(pos.func_177951_i((Vector3i)player.func_233580_cy_()) < (double)blockTrackRangeSq)) continue;
            this.addBlockTarget(new RenderBlockTarget(world, player, pos.func_185334_h(), te, this));
        }
        this.checkBlockFocus(player, blockTrackRange);
        this.processTrackerEntries(player, blockTrackRange);
        this.updateTrackerText();
    }

    private void checkBlockFocus(PlayerEntity player, int blockTrackRange) {
        Vector3d eyes;
        this.focusedTarget = null;
        this.focusedFace = null;
        Vector3d v = eyes = player.func_174824_e(1.0f);
        Vector3d lookVec = player.func_70040_Z().func_186678_a(0.25);
        BlockPos.Mutable checkPos = new BlockPos.Mutable();
        for (int i = 0; i < blockTrackRange * 4; ++i) {
            BlockState state;
            BlockRayTraceResult brtr;
            v = v.func_178787_e(lookVec);
            checkPos.func_189532_c(v.field_72450_a, v.field_72448_b, v.field_72449_c);
            if (!this.blockTargets.containsKey(checkPos) || (brtr = (state = player.field_70170_p.func_180495_p((BlockPos)checkPos)).func_196954_c((IBlockReader)player.field_70170_p, (BlockPos)checkPos).func_212433_a(eyes, v, (BlockPos)checkPos)) == null || brtr.func_216346_c() != RayTraceResult.Type.BLOCK) continue;
            this.focusedTarget = this.blockTargets.get(checkPos);
            this.focusedFace = brtr.func_216354_b();
            break;
        }
    }

    public BlockPos getFocusedPos() {
        return this.focusedTarget == null ? null : this.focusedTarget.getPos();
    }

    public Direction getFocusedFace() {
        return this.focusedFace;
    }

    private void nextScanPos(BlockPos.Mutable pos, PlayerEntity player, int range) {
        Direction dir = PneumaticCraftUtils.getDirectionFacing((LivingEntity)player, true);
        switch (dir) {
            case UP: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = 0;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case DOWN: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (--this.yOff >= -range) break;
                this.yOff = 0;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case EAST: {
                if (++this.xOff <= range) break;
                this.xOff = 0;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case WEST: {
                if (--this.xOff >= -range) break;
                this.xOff = 0;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case NORTH: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (--this.zOff >= -range) break;
                this.zOff = 0;
                this.updateBlockTypeCounts();
                break;
            }
            case SOUTH: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = 0;
                this.updateBlockTypeCounts();
            }
        }
        pos.func_189532_c(player.func_226277_ct_() + (double)this.xOff, MathHelper.func_151237_a((double)(player.func_226278_cu_() + (double)this.yOff), (double)0.0, (double)255.0), player.func_226281_cx_() + (double)this.zOff);
    }

    private void updateBlockTypeCounts() {
        this.blockTypeCount.clear();
        this.blockTypeCount.putAll(this.blockTypeCountPartial);
        this.blockTypeCountPartial.clear();
    }

    private void processTrackerEntries(PlayerEntity player, int blockTrackRange) {
        ArrayList<RenderBlockTarget> toRemove = new ArrayList<RenderBlockTarget>();
        int rangeSq = (blockTrackRange + 5) * (blockTrackRange + 5);
        int incr = CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EquipmentSlotType.HEAD);
        for (RenderBlockTarget blockTarget : this.blockTargets.values()) {
            boolean wasNegative = blockTarget.ticksExisted < 0;
            blockTarget.ticksExisted += incr;
            if (blockTarget.ticksExisted >= 0 && wasNegative) {
                blockTarget.ticksExisted = -1;
            }
            blockTarget.tick();
            BlockPos pos = blockTarget.getPos();
            if (!(player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) > (double)rangeSq) && blockTarget.isTargetStillValid()) continue;
            if (blockTarget.ticksExisted > 0) {
                blockTarget.ticksExisted = -100;
                continue;
            }
            if (blockTarget.ticksExisted != -1) continue;
            toRemove.add(blockTarget);
        }
        toRemove.forEach(this::removeBlockTarget);
    }

    private void updateTrackerText() {
        if (this.focusedTarget != null) {
            this.blockTrackInfo.setTitle((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.block_tracker", new Object[0]));
            this.blockTrackInfo.setText(this.focusedTarget.getTitle());
        } else {
            this.blockTrackInfo.setTitle((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.trackedBlocks", new Object[0]));
            ArrayList<ITextComponent> textList = new ArrayList<ITextComponent>();
            this.blockTypeCount.forEach((k, v) -> {
                if (v > 0 && WidgetKeybindCheckBox.get((ResourceLocation)k).checked) {
                    textList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.countedItem", v, PneumaticCraftUtils.xlate(ArmorUpgradeRegistry.getStringKey(k), new Object[0])));
                }
            });
            if (textList.isEmpty()) {
                textList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.noTrackedBlocks", new Object[0]));
            }
            this.blockTrackInfo.setText(textList);
        }
    }

    private void addBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.put(blockTarget.getPos(), blockTarget);
    }

    private void removeBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.remove(blockTarget.getPos());
    }

    public int countBlockTrackersOfType(IBlockTrackEntry type) {
        return this.blockTypeCount.getOrDefault((Object)type.getEntryID(), 0);
    }

    @Override
    public void render3D(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        this.blockTargets.values().forEach(t -> t.render(matrixStack, buffer, partialTicks));
    }

    @Override
    public void render2D(MatrixStack matrixStack, float partialTicks, boolean armorPieceHasPressure) {
    }

    @Override
    public void reset() {
        this.blockTypeCountPartial.clear();
        this.blockTypeCount.clear();
        this.blockTrackInfo = null;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new BlockTrackOptions(screen, this);
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.blockTrackInfo == null) {
            WidgetAnimatedStat.StatIcon icon = WidgetAnimatedStat.StatIcon.of(EnumUpgrade.BLOCK_TRACKER.getItemStack());
            this.blockTrackInfo = new WidgetAnimatedStat(null, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.trackedBlocks", new Object[0]), icon, HUDHandler.getInstance().getStatOverlayColor(), null, ArmorHUDLayout.INSTANCE.blockTrackerStat);
            this.blockTrackInfo.setMinimumContractedDimensions(0, 0);
            this.blockTrackInfo.setAutoLineWrap(false);
        }
        return this.blockTrackInfo;
    }

    public void hack() {
        this.blockTargets.values().forEach(RenderBlockTarget::hack);
    }

    public RenderBlockTarget getTargetForCoord(BlockPos pos) {
        return this.blockTargets.get(pos);
    }

    public boolean scroll(InputEvent.MouseScrollEvent event) {
        for (RenderBlockTarget target : this.blockTargets.values()) {
            if (!target.scroll(event)) continue;
            this.getAnimatedStat().func_231043_a_(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
            return true;
        }
        return false;
    }

    @Override
    public void onResolutionChanged() {
        this.blockTrackInfo = null;
    }

    @Override
    public Collection<ResourceLocation> getSubKeybinds() {
        ImmutableList.Builder builder = ImmutableList.builder();
        BlockTrackEntryList.INSTANCE.trackList.forEach(entry -> builder.add((Object)entry.getEntryID()));
        return builder.build();
    }

    @Override
    public String getSubKeybindCategory() {
        return "key.pneumaticcraft.category.block_tracker";
    }

    @Override
    public void setOverlayColor(int color) {
        super.setOverlayColor(color);
        this.blockTargets.values().forEach(target -> target.updateColor(color));
    }
}

