/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.projectile.EntityVortex;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderEntityVortex
extends EntityRenderer<EntityVortex> {
    private static final int CIRCLE_POINTS = 20;
    private static final float TEX_SCALE = 0.07f;
    private static final double RADIUS = 0.5;
    public static final IRenderFactory<EntityVortex> FACTORY = RenderEntityVortex::new;

    private RenderEntityVortex(EntityRendererManager manager) {
        super(manager);
    }

    public ResourceLocation getTextureLocation(EntityVortex entity) {
        return Textures.VORTEX_ENTITY;
    }

    public void render(EntityVortex entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!entity.hasRenderOffsetX()) {
            entity.setRenderOffsetX(this.calculateXoffset());
        }
        matrixStackIn.func_227860_a_();
        IVertexBuilder builder = bufferIn.getBuffer(ModRenderTypes.getTextureRenderColored(this.getTextureLocation(entity)));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70126_B, (float)entity.field_70177_z)));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70127_C, (float)entity.field_70125_A)));
        float incr = 0.31415927f;
        float angleRads = 0.0f;
        while ((double)angleRads < Math.PI * 2) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5 * (double)MathHelper.func_76126_a((float)angleRads), 0.5 * (double)MathHelper.func_76134_b((float)angleRads), 0.0);
            this.renderGust(matrixStackIn, builder, entity.getRenderOffsetX(), packedLightIn);
            matrixStackIn.func_227865_b_();
            angleRads += incr;
        }
        matrixStackIn.func_227865_b_();
    }

    private float calculateXoffset() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        HandSide hs = player.func_184591_cq();
        if (player.func_184614_ca().func_77973_b() != ModItems.VORTEX_CANNON.get()) {
            hs = hs.func_188468_a();
        }
        return hs == HandSide.RIGHT ? -4.0f : 16.0f;
    }

    private void renderGust(MatrixStack matrixStackIn, IVertexBuilder wr, float xOffset, int packedLightIn) {
        float u1 = 0.0f;
        float u2 = 1.0f;
        float v1 = 0.0f;
        float v2 = 1.0f;
        matrixStackIn.func_227862_a_(0.07f, 0.07f, 0.07f);
        matrixStackIn.func_227861_a_((double)xOffset, 0.0, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        Matrix4f posMat = matrixStackIn.func_227866_c_().func_227870_a_();
        wr.func_227888_a_(posMat, -7.0f, -2.0f, -2.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_225583_a_(u1, v1).func_227886_a_(packedLightIn).func_181675_d();
        wr.func_227888_a_(posMat, -7.0f, -2.0f, 2.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_225583_a_(u2, v1).func_227886_a_(packedLightIn).func_181675_d();
        wr.func_227888_a_(posMat, -7.0f, 2.0f, 2.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_225583_a_(u2, v2).func_227886_a_(packedLightIn).func_181675_d();
        wr.func_227888_a_(posMat, -7.0f, 2.0f, -2.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_225583_a_(u1, v2).func_227886_a_(packedLightIn).func_181675_d();
        wr.func_227888_a_(posMat, -7.0f, 2.0f, -2.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_225583_a_(u1, v1).func_227886_a_(packedLightIn).func_181675_d();
        wr.func_227888_a_(posMat, -7.0f, 2.0f, 2.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_225583_a_(u2, v1).func_227886_a_(packedLightIn).func_181675_d();
        wr.func_227888_a_(posMat, -7.0f, -2.0f, 2.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_225583_a_(u2, v2).func_227886_a_(packedLightIn).func_181675_d();
        wr.func_227888_a_(posMat, -7.0f, -2.0f, -2.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 0.5f).func_225583_a_(u1, v2).func_227886_a_(packedLightIn).func_181675_d();
    }
}

