/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.apache.commons.lang3.Validate;

public enum ArmorUpgradeClientRegistry {
    INSTANCE;

    private final List<List<IArmorUpgradeClientHandler<?>>> clientUpgradeHandlers = new ArrayList();
    private final Map<ResourceLocation, IArmorUpgradeClientHandler<?>> id2HandlerMap = new HashMap();
    private final Map<ResourceLocation, KeyBinding> id2KeyBindMap = new HashMap<ResourceLocation, KeyBinding>();
    private final Map<String, IArmorUpgradeClientHandler<?>> triggerKeyBindMap = new HashMap();

    public static ArmorUpgradeClientRegistry getInstance() {
        return INSTANCE;
    }

    public <T extends IArmorUpgradeHandler<?>> void registerHandler(T handler, IArmorUpgradeClientHandler<T> clientHandler) {
        this.id2HandlerMap.put(handler.getID(), clientHandler);
        clientHandler.getInitialKeyBinding().ifPresent(k -> this.registerKeyBinding(handler.getID(), (KeyBinding)k));
        clientHandler.getSubKeybinds().forEach(rl -> this.registerKeyBinding((ResourceLocation)rl, new KeyBinding(IArmorUpgradeHandler.getStringKey(rl), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, -1, clientHandler.getSubKeybindCategory())));
        clientHandler.getTriggerKeyBinding().ifPresent(k -> this.registerTriggerKeybinding((KeyBinding)k, clientHandler));
    }

    private void registerKeyBinding(ResourceLocation upgradeID, KeyBinding keyBinding) {
        this.id2KeyBindMap.put(upgradeID, keyBinding);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
    }

    private void registerTriggerKeybinding(KeyBinding keyBinding, IArmorUpgradeClientHandler<?> clientHandler) {
        this.triggerKeyBindMap.put(keyBinding.func_151464_g(), clientHandler);
    }

    public KeyBinding getKeybindingForUpgrade(ResourceLocation upgradeID) {
        return this.id2KeyBindMap.get(upgradeID);
    }

    public <C extends IArmorUpgradeClientHandler<U>, U extends IArmorUpgradeHandler<?>> C getClientHandler(U armorUpgradeHandler, Class<C> clientClass) {
        List<IArmorUpgradeClientHandler<?>> clientHandlers = this.getHandlersForSlot(armorUpgradeHandler.getEquipmentSlot());
        return (C)clientHandlers.get(armorUpgradeHandler.getIndex());
    }

    public IArmorUpgradeClientHandler<?> getClientHandler(ResourceLocation id) {
        return this.id2HandlerMap.get(id);
    }

    public Optional<IArmorUpgradeClientHandler<?>> getTriggeredHandler(KeyBinding keyBinding) {
        return Optional.ofNullable(this.triggerKeyBindMap.get(keyBinding.func_151464_g()));
    }

    public List<IArmorUpgradeClientHandler<?>> getHandlersForSlot(EquipmentSlotType slot) {
        if (this.clientUpgradeHandlers.isEmpty()) {
            this.initHandlerLists();
        }
        return this.clientUpgradeHandlers.get(slot.func_188454_b());
    }

    private void initHandlerLists() {
        if (!this.clientUpgradeHandlers.isEmpty()) {
            throw new IllegalStateException("handler lists already inited!?");
        }
        for (EquipmentSlotType ignored : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            this.clientUpgradeHandlers.add(new ArrayList());
        }
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (IArmorUpgradeHandler<?> handler : ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot)) {
                IArmorUpgradeClientHandler<?> clientHandler = this.id2HandlerMap.get(handler.getID());
                Validate.notNull(clientHandler, (String)("Null client-handler for upgrade handler '" + handler.getID() + "'! Did you forget to register it?"), (Object[])new Object[0]);
                this.clientUpgradeHandlers.get(slot.func_188454_b()).add(clientHandler);
            }
        }
        this.refreshConfig();
    }

    public void refreshConfig() {
        if (this.clientUpgradeHandlers.isEmpty()) {
            return;
        }
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (IArmorUpgradeClientHandler<?> renderHandler : this.getHandlersForSlot(slot)) {
                renderHandler.initConfig();
            }
        }
    }
}

