/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.tileentity.TileEntityDirectionBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;

public abstract class TileEntityPlatformBase
extends TileEntityDirectionBase {
    private ItemStack itemBaseFrame = ItemStack.field_190927_a;
    private ItemStack itemBaseCover = ItemStack.field_190927_a;
    private ItemStack itemRail = ItemStack.field_190927_a;
    private ItemStack itemLayerTexture = ItemStack.field_190927_a;
    private ItemStack itemRailFrame = ItemStack.field_190927_a;
    private ItemStack itemRailCover = ItemStack.field_190927_a;
    private SoundType soundBase = null;
    private SoundType soundRail = null;
    private final boolean[] isColorCached = new boolean[4];
    private final int[] materialColor = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};

    public TileEntityPlatformBase(TileEntityType<?> type) {
        super(type);
    }

    protected boolean isDirectionValid(Direction facing) {
        return facing != null && facing.func_176740_k() != Direction.Axis.Y;
    }

    protected void buildNBT(CompoundNBT nbtTag) {
        CompoundNBT stack;
        if (!this.itemBaseFrame.func_190926_b()) {
            stack = new CompoundNBT();
            this.itemBaseFrame.func_77955_b(stack);
            nbtTag.func_218657_a("frame_texture_item", (INBT)stack);
        }
        if (!this.itemBaseCover.func_190926_b()) {
            stack = new CompoundNBT();
            this.itemBaseCover.func_77955_b(stack);
            nbtTag.func_218657_a("cover_texture_item", (INBT)stack);
        }
        if (!this.itemRail.func_190926_b()) {
            stack = new CompoundNBT();
            this.itemRail.func_77955_b(stack);
            nbtTag.func_218657_a("rail_item", (INBT)stack);
        }
        if (!this.itemLayerTexture.func_190926_b()) {
            stack = new CompoundNBT();
            this.itemLayerTexture.func_77955_b(stack);
            nbtTag.func_218657_a("layer_texture_item", (INBT)stack);
        }
    }

    protected void processNBT(CompoundNBT nbtTag) {
        if (nbtTag.func_74764_b("frame_texture_item")) {
            this.itemBaseFrame = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("frame_texture_item"));
        }
        if (nbtTag.func_74764_b("cover_texture_item")) {
            this.itemBaseCover = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("cover_texture_item"));
        }
        if (nbtTag.func_74764_b("rail_item")) {
            this.setRailItem(ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("rail_item")));
        }
        if (nbtTag.func_74764_b("layer_texture_item")) {
            this.setLevelTexture(ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("layer_texture_item")));
        }
        this.requestModelDataUpdate();
    }

    public void setTextureInfo(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlockPlatform) {
            this.setFrameTextureBlock(ItemBlockPlatform.getFrameTextureStack(stack));
            this.setCoverTextureBlock(ItemBlockPlatform.getCoverTextureStack(stack));
        }
    }

    public void setFrameTextureBlock(ItemStack stack) {
        this.itemBaseFrame = stack;
    }

    public ItemStack getFrameTextureBlock() {
        return this.itemBaseFrame;
    }

    public void setCoverTextureBlock(ItemStack stack) {
        this.itemBaseCover = stack;
    }

    public ItemStack getCoverTextureBlock() {
        return this.itemBaseCover;
    }

    public ItemStack getRailFrameTextureBlock() {
        return this.itemRailFrame;
    }

    public ItemStack getRailCoverTextureBlock() {
        return this.itemRailCover;
    }

    public SoundType getSoundType() {
        if (this.soundBase == null) {
            this.soundBase = this.merge(this.getSoundType(this.itemBaseFrame), this.getSoundType(this.itemBaseCover));
        }
        return this.soundBase;
    }

    public SoundType getRailSound() {
        if (this.soundRail == null) {
            this.soundRail = this.merge(this.getSoundType(this.itemRailFrame), this.getSoundType(this.itemRailCover));
        }
        return this.soundRail;
    }

    private SoundType getSoundType(ItemStack stack) {
        SoundType soundType = null;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem) {
            BlockState state = UseContext.getBlockPlacementStateFor((ItemStack)stack, (World)this.field_145850_b);
            try {
                soundType = ((BlockItem)stack.func_77973_b()).func_179223_d().getSoundType(state, (IWorldReader)this.func_145831_w(), this.func_174877_v(), null);
            }
            catch (Exception ignored) {
                soundType = ((BlockItem)stack.func_77973_b()).func_179223_d().func_220072_p(state);
            }
        }
        return soundType;
    }

    private SoundType merge(SoundType frame, SoundType cover) {
        if (frame == cover) {
            return frame != null ? frame : SoundType.field_185848_a;
        }
        frame = frame != null ? frame : SoundType.field_185848_a;
        cover = cover != null ? cover : SoundType.field_185848_a;
        return new SoundType(1.0f, 1.0f, frame.func_185845_c(), cover.func_185844_d(), frame.func_185841_e(), frame.func_185846_f(), cover.func_185842_g());
    }

    public boolean hasRail() {
        return !this.itemRail.func_190926_b();
    }

    public void removeRail() {
        this.itemRail = ItemStack.field_190927_a;
        this.itemRailFrame = ItemStack.field_190927_a;
        this.itemRailCover = ItemStack.field_190927_a;
        this.isColorCached[2] = false;
        this.isColorCached[3] = false;
        this.materialColor[2] = 0xFFFFFF;
        this.materialColor[3] = 0xFFFFFF;
    }

    public boolean setRailItem(ItemStack stack) {
        ItemBlockPlatform platform;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)stack.func_77973_b()).getPlatformType().isAddon()) {
            this.itemRail = stack.func_77946_l().func_77979_a(1);
            this.itemRailFrame = ItemBlockPlatform.getFrameTextureStack(stack);
            this.itemRailCover = ItemBlockPlatform.getCoverTextureStack(stack);
            return true;
        }
        return false;
    }

    public ItemStack getRailItem() {
        return this.itemRail;
    }

    public EnumPlatformType getRailType() {
        if (this.hasRail()) {
            ItemBlockPlatform platform;
            if (!this.itemRail.func_190926_b() && this.itemRail.func_77973_b() instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)this.itemRail.func_77973_b()).getPlatformType().isAddon()) {
                return platform.getPlatformType();
            }
            this.removeRail();
        }
        return null;
    }

    public void resetLevelTexture() {
        this.itemLayerTexture = ItemStack.field_190927_a;
        this.requestModelDataUpdate();
    }

    public boolean setLevelTexture(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem && this.setLevelTexture(((BlockItem)stack.func_77973_b()).func_179223_d())) {
            this.requestModelDataUpdate();
            return true;
        }
        return false;
    }

    private boolean setLevelTexture(Block block) {
        if (block == Blocks.field_196604_cC || block instanceof SnowBlock || block instanceof FallingBlock && block.func_176223_P().func_185904_a() == Material.field_151595_p) {
            this.itemLayerTexture = new ItemStack((IItemProvider)block);
            return true;
        }
        return false;
    }

    public void playLevelTextureSound(PlayerEntity player, boolean place) {
        if (this.func_145831_w() != null && !this.itemLayerTexture.func_190926_b() && player != null) {
            if (this.itemLayerTexture.func_77973_b() instanceof BlockItem) {
                Block block = ((BlockItem)this.itemLayerTexture.func_77973_b()).func_179223_d();
                if (place) {
                    this.func_145831_w().func_184133_a(player, this.func_174877_v(), block.func_220072_p(block.func_176223_P()).func_185841_e(), SoundCategory.BLOCKS, 1.0f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                } else {
                    this.func_145831_w().func_184133_a(player, this.func_174877_v(), block.func_220072_p(block.func_176223_P()).func_185845_c(), SoundCategory.BLOCKS, 1.0f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
            } else {
                this.resetLevelTexture();
            }
        }
    }

    public Block getLayerTextureBlock() {
        if (!this.itemLayerTexture.func_190926_b() && this.itemLayerTexture.func_77973_b() instanceof BlockItem) {
            return ((BlockItem)this.itemLayerTexture.func_77973_b()).func_179223_d();
        }
        this.resetLevelTexture();
        return Blocks.field_150350_a;
    }

    public Block getBiomeLayerTexture(Biome biome) {
        return biome.func_201851_b() == Biome.RainType.SNOW || (double)biome.func_225486_c(this.func_174877_v()) < 0.2 ? Blocks.field_196604_cC : biome.func_242440_e().func_242502_e().func_204108_a().func_177230_c();
    }

    public void addExtraDrops(List<ItemStack> drops) {
        if (this.hasRail()) {
            drops.add(this.itemRail);
        }
    }

    public int getTint(int index) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (index >= 0 && index < 4 && !this.isColorCached[index]) {
                ItemStack material;
                ItemStack itemStack = index == 3 ? this.itemRailCover : (index == 2 ? this.itemRailFrame : (material = index == 1 ? this.itemBaseCover : this.itemBaseFrame));
                if (!material.func_190926_b()) {
                    this.materialColor[index] = Minecraft.func_71410_x().func_184125_al().func_228054_a_(UseContext.getBlockPlacementStateFor((ItemStack)material, (World)this.func_145831_w()), (IBlockDisplayReader)this.func_145831_w(), this.func_174877_v(), 0);
                    this.isColorCached[index] = true;
                }
            }
        });
        return index >= 0 && index < 4 ? this.materialColor[index] : 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a((double)0.55f, (double)0.55f, (double)0.55f);
    }

    public IModelData getModelData() {
        CompoundNBT nbtTag = new CompoundNBT();
        if (this.itemLayerTexture.func_190926_b() && this.func_145831_w() != null) {
            this.setLevelTexture(this.getBiomeLayerTexture(this.func_145831_w().func_226691_t_(this.func_174877_v())));
        }
        this.buildNBT(nbtTag);
        return new ModelDataMap.Builder().withInitial(ModelProperties.NBTProperty, (Object)nbtTag).build();
    }
}

