/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.common.Function;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.inventory.IOutputSlot;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.inventory.InventoryPlatFormer;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;

public class TileEntityPlatFormer
extends TileEntityBase
implements ISidedWrapper,
IOutputSlot,
ITickableTileEntity {
    public InventoryInternal inventory;
    private final ISidedWrapper.SidedWrapper sidedWrapper;
    public EnumPlatformType platformType = EnumPlatformType.FLAT;
    private final ItemStack[] deconstructCache = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
    private EntityGuiItem displayItem = null;
    private ItemStack outputItem = ItemStack.field_190927_a;

    public TileEntityPlatFormer() {
        super(Values.tilePlatFormer);
        this.inventory = new InventoryPlatFormer(this);
        InventoryPlatFormer inv = (InventoryPlatFormer)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(), inv.getWrapperDeconstruct(), inv.getWrapperOutput(), inv.getWrapperStorage()});
        this.sidedWrapper.setFaceIndex(Direction.DOWN, 2);
        this.sidedWrapper.setFaceIndex(Direction.UP, 3);
        this.sidedWrapper.setFaceIndex(Direction.NORTH, 0);
        this.sidedWrapper.setFaceIndex(Direction.SOUTH, 0);
        this.sidedWrapper.setFaceIndex(Direction.WEST, 0);
        this.sidedWrapper.setFaceIndex(Direction.EAST, 0);
    }

    protected void buildNBT(CompoundNBT nbtTag) {
        nbtTag.func_74778_a("platform_type", this.platformType.func_176610_l());
        this.inventory.writeToNBT(nbtTag, "items");
        this.sidedWrapper.writeToNBT(nbtTag);
    }

    protected void processNBT(CompoundNBT nbtTag) {
        this.platformType = EnumPlatformType.byName(nbtTag.func_74779_i("platform_type"));
        this.inventory.readFromNBT(nbtTag, nbtTag.func_74764_b("items") ? "items" : "inventory");
        this.sidedWrapper.readFromNBT(nbtTag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            InvWrapper handler = this.sidedWrapper.getWrapper(Direction.SOUTH, facing);
            return handler == null ? LazyOptional.empty() : LazyOptional.of(() -> TileEntityPlatFormer.lambda$getCapability$0((IItemHandler)handler)).cast();
        }
        return super.getCapability(capability, facing);
    }

    public ISidedWrapper.SidedWrapper getSidedWrapper() {
        return this.sidedWrapper;
    }

    public void func_73660_a() {
        ItemStack deconStack;
        if (this.outputItem.func_190926_b()) {
            this.updateOutput();
        }
        if (!(deconStack = this.inventory.func_70301_a(5)).func_190926_b()) {
            int needed = this.getCraftedAmount(deconStack);
            if (deconStack.func_190916_E() >= needed) {
                this.deconstruct(needed);
            }
        }
    }

    private void deconstruct(int needed) {
        ItemStack deconStack = this.inventory.func_70301_a(5);
        if (deconStack.func_190926_b()) {
            return;
        }
        if (!Function.areItemStacksEqual((ItemStack)this.deconstructCache[0], (ItemStack)deconStack)) {
            this.deconstructCache[0] = deconStack;
            this.deconstructCache[1] = ItemBlockPlatform.getFrameTextureStack(deconStack);
            this.deconstructCache[2] = ItemBlockPlatform.getCoverTextureStack(deconStack);
        }
        if (this.deconstructCache[1].func_190926_b() || this.deconstructCache[2].func_190926_b()) {
            return;
        }
        int[] slots = new int[]{-1, -1};
        HashMap<Byte, ItemStack> changes = new HashMap<Byte, ItemStack>();
        block0: for (int item = 0; item < 2; item = (int)((byte)(item + 1))) {
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (byte slot = 6; slot < 15; slot = (byte)((byte)(slot + 1))) {
                    ItemStack stack;
                    ItemStack itemStack = stack = changes.containsKey(slot) ? (ItemStack)changes.get(slot) : this.inventory.getContents()[slot];
                    if (!stack.func_190926_b()) {
                        if (stack.func_190916_E() >= stack.func_77976_d() || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)this.deconstructCache[1 + item])) continue;
                        slots[item] = slot;
                        stack = stack.func_77946_l();
                        stack.func_190917_f(1);
                        changes.put(slot, stack);
                        continue block0;
                    }
                    if (pass != 1) continue;
                    slots[item] = slot;
                    changes.put(slot, this.deconstructCache[1 + item].func_77946_l());
                    continue block0;
                }
            }
        }
        if (slots[0] > -1 && slots[1] > -1) {
            for (Map.Entry entry : changes.entrySet()) {
                this.inventory.getContents()[((Byte)entry.getKey()).byteValue()] = (ItemStack)entry.getValue();
            }
            if (deconStack.func_190916_E() - needed < 1) {
                deconStack = ItemStack.field_190927_a;
            } else {
                deconStack.func_190918_g(needed);
            }
            this.inventory.func_70299_a(5, deconStack);
            this.func_70296_d();
        }
    }

    public void addExtraDrops(List<ItemStack> drops) {
        for (int slotId = 4; slotId < this.inventory.getContents().length; ++slotId) {
            ItemStack stack = this.inventory.func_70301_a(slotId);
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
    }

    private int getCraftedAmount(ItemStack stack) {
        int multiplier = 0;
        if (this.isStorageBlock(ItemBlockPlatform.getFrameTextureStack(stack))) {
            ++multiplier;
        }
        if (this.isStorageBlock(ItemBlockPlatform.getCoverTextureStack(stack))) {
            ++multiplier;
        }
        multiplier = multiplier == 0 ? 1 : multiplier * (Integer)Configuration.CRAFTING.compressedMultiplier.get();
        return MathHelper.func_76125_a((int)(this.platformType.getCraftAmount() * multiplier), (int)1, (int)stack.func_77976_d());
    }

    private boolean isStorageBlock(ItemStack stack) {
        return !stack.func_190926_b() && Tags.Items.STORAGE_BLOCKS.func_230235_a_((Object)stack.func_77973_b());
    }

    public void updateOutput() {
        if (this.func_145831_w() == null) {
            return;
        }
        this.setGhostSlot(0, this.inventory.func_70301_a(0));
        this.setGhostSlot(1, this.inventory.func_70301_a(1));
        this.outputItem = ItemBlockPlatform.createStack(Values.blocksPlatform.get((Object)this.platformType), this.inventory.func_70301_a(1), this.inventory.func_70301_a(0));
        if (!this.outputItem.func_190926_b()) {
            this.outputItem.func_190920_e(this.getCraftedAmount(this.outputItem));
            ItemStack displayStack = this.outputItem.func_77946_l();
            displayStack.func_190920_e(1);
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                this.displayItem = new EntityGuiItem(this.func_145831_w(), 0.0, 0.0, 0.0, displayStack);
            });
            if (this.inventory.func_70301_a(0).func_190926_b() || this.inventory.func_70301_a(1).func_190926_b()) {
                this.inventory.func_70299_a(3, ItemStack.field_190927_a);
            } else {
                this.inventory.func_70299_a(3, this.outputItem.func_77946_l());
            }
        }
    }

    public EntityGuiItem getEntity() {
        if (this.displayItem == null) {
            this.updateOutput();
        }
        return this.displayItem;
    }

    public boolean canCraft() {
        ItemStack[] craftStacks = new ItemStack[]{this.inventory.func_70301_a(0), this.inventory.func_70301_a(1)};
        boolean[] hasItem = new boolean[]{false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            if (!hasItem[0] && Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[0])) {
                hasItem[0] = true;
                if (hasItem[1] || !Function.areItemStacksEqual((ItemStack)craftStacks[0], (ItemStack)craftStacks[1]) || stack.func_190916_E() <= 1) continue;
                hasItem[1] = true;
            }
            if (hasItem[1] || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[1])) continue;
            hasItem[1] = true;
        }
        return hasItem[0] && hasItem[1];
    }

    public void doCraft() {
        ItemStack[] craftStacks = new ItemStack[]{this.inventory.func_70301_a(0), this.inventory.func_70301_a(1)};
        boolean[] hasItem = new boolean[]{false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            for (int part = 0; part < 2; part = (int)((byte)(part + 1))) {
                if (hasItem[part] || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[part])) continue;
                hasItem[part] = true;
                if (stack.func_190916_E() == 1) {
                    this.inventory.func_70299_a(slot, ItemStack.field_190927_a);
                    continue;
                }
                stack.func_190918_g(1);
                this.inventory.func_70299_a(slot, stack);
            }
        }
    }

    public void setGhostSlot(int slotId, ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) {
            if (slotId >= 0 && slotId < 3) {
                this.inventory.func_70299_a(slotId, ItemStack.field_190927_a);
            }
            return;
        }
        boolean itemOK = false;
        if ((slotId == 0 || slotId == 1) && stack.func_77973_b() instanceof BlockItem) {
            BlockState state = UseContext.getBlockPlacementStateFor((ItemStack)stack, (World)this.func_145831_w());
            boolean bl = itemOK = !((BlockItem)stack.func_77973_b()).func_179223_d().hasTileEntity(state);
        }
        if (itemOK) {
            this.inventory.func_70299_a(slotId, stack.func_77946_l().func_77979_a(1));
        } else {
            this.inventory.func_70299_a(slotId, ItemStack.field_190927_a);
        }
    }

    public boolean canTakeFromOutputSlot(int slotId, PlayerEntity player) {
        return slotId != 3 || player.field_71075_bZ.field_75098_d || this.canCraft();
    }

    public ItemStack shrinkStackSize(int slotId, PlayerEntity player, int amount) {
        ItemStack stack;
        if (slotId == 3 && player.field_71075_bZ.field_75098_d && !(stack = this.inventory.func_70301_a(3)).func_190926_b()) {
            stack = stack.func_77946_l();
            stack.func_190920_e(64);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void onPickupFromOutputSlot(int slotId, PlayerEntity player, ItemStack stack) {
    }

    public ItemStack getOutputItem() {
        return this.outputItem != null ? this.outputItem.func_77946_l() : ItemStack.field_190927_a;
    }

    private static /* synthetic */ IItemHandler lambda$getCapability$0(IItemHandler handler) {
        return handler;
    }
}

