/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.client.Localization;
import shetiphian.core.common.IColored;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.render.RenderRegistry;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;

public class ItemBlockPlatform
extends BlockItem
implements IColored {
    private final EnumPlatformType platformType;

    public ItemBlockPlatform(EnumPlatformType platformType, Block block, Item.Properties properties) {
        super(block, properties);
        this.platformType = platformType;
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public EnumPlatformType getPlatformType() {
        return this.platformType;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            list.add((Object)ItemBlockPlatform.createStack(this.func_179223_d(), new ItemStack((IItemProvider)Blocks.field_196662_n), new ItemStack((IItemProvider)Blocks.field_196662_n)));
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        CompoundNBT texture;
        ItemStack textureStack;
        CompoundNBT tag = ItemBlockPlatform.getNBTTag(stack);
        if (!tag.func_74764_b(ItemBlockPlatform.getFrameTextureKey())) {
            textureStack = new ItemStack((IItemProvider)Blocks.field_196662_n);
            texture = new CompoundNBT();
            textureStack.func_77955_b(texture);
            tag.func_218657_a(ItemBlockPlatform.getFrameTextureKey(), (INBT)texture);
        }
        if (!tag.func_74764_b(ItemBlockPlatform.getCoverTextureKey())) {
            textureStack = new ItemStack((IItemProvider)Blocks.field_196662_n);
            texture = new CompoundNBT();
            textureStack.func_77955_b(texture);
            tag.func_218657_a(ItemBlockPlatform.getCoverTextureKey(), (INBT)texture);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        if (!stack.func_190926_b()) {
            if (advancedTooltips.func_194127_a() || Screen.func_231173_s_()) {
                CompoundNBT tag = ItemBlockPlatform.getNBTTag(stack);
                this.addTextureInfo(tooltip, tag, ItemBlockPlatform.getFrameTextureKey());
                this.addTextureInfo(tooltip, tag, ItemBlockPlatform.getCoverTextureKey());
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(Localization.get((String)"info.shetiphian.holdshift.txt")));
            }
        }
    }

    private void addTextureInfo(List<ITextComponent> tooltip, CompoundNBT tag, String key) {
        if (tag.func_74764_b(key)) {
            ItemStack tagStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(key));
            if (!tagStack.func_190926_b()) {
                tooltip.add((ITextComponent)new StringTextComponent(" * " + Localization.get((String)tagStack.func_77977_a())));
            } else {
                tagStack = new ItemStack((IItemProvider)Blocks.field_196662_n);
                tooltip.add((ITextComponent)new StringTextComponent(" * /!\\ " + Localization.get((String)"info.platforms.invalid_texture") + " /!\\"));
                tooltip.add((ITextComponent)new StringTextComponent(" ** " + Localization.get((String)tagStack.func_77977_a())));
                tooltip.add((ITextComponent)new StringTextComponent(" ** " + Localization.get((String)"info.platforms.default_texture") + Localization.get((String)tagStack.func_77977_a())));
            }
        } else {
            ItemStack tagStack = new ItemStack((IItemProvider)Blocks.field_196662_n);
            tooltip.add((ITextComponent)new StringTextComponent(" * /!\\ " + Localization.get((String)"info.platforms.no_texture") + " /!\\"));
            tooltip.add((ITextComponent)new StringTextComponent(" ** " + Localization.get((String)"info.platforms.default_texture") + Localization.get((String)tagStack.func_77977_a())));
        }
    }

    public static ItemStack createStack(EnumPlatformType platformType, ItemStack texFrame, ItemStack texCover) {
        return ItemBlockPlatform.createStack(Values.blocksPlatform.get((Object)platformType), texFrame, texCover);
    }

    public static ItemStack createStack(Block block, ItemStack texFrame, ItemStack texCover) {
        ItemStack stack;
        if (block != null && !(stack = new ItemStack((IItemProvider)block)).func_190926_b()) {
            CompoundNBT tag = ItemBlockPlatform.getNBTTag(stack);
            if (texFrame.func_190926_b()) {
                texFrame = new ItemStack((IItemProvider)Blocks.field_196662_n);
            }
            CompoundNBT texture = new CompoundNBT();
            texFrame.func_77955_b(texture);
            tag.func_218657_a(ItemBlockPlatform.getFrameTextureKey(), (INBT)texture);
            if (texCover.func_190926_b()) {
                texCover = new ItemStack((IItemProvider)Blocks.field_196662_n);
            }
            texture = new CompoundNBT();
            texCover.func_77955_b(texture);
            tag.func_218657_a(ItemBlockPlatform.getCoverTextureKey(), (INBT)texture);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getFrameTextureStack(ItemStack stack) {
        CompoundNBT tag;
        if (!stack.func_190926_b() && (tag = ItemBlockPlatform.getNBTTag(stack)).func_74764_b(ItemBlockPlatform.getFrameTextureKey())) {
            return ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(ItemBlockPlatform.getFrameTextureKey()));
        }
        return new ItemStack((IItemProvider)Blocks.field_196662_n);
    }

    public static ItemStack getCoverTextureStack(ItemStack stack) {
        CompoundNBT tag;
        if (!stack.func_190926_b() && (tag = ItemBlockPlatform.getNBTTag(stack)).func_74764_b(ItemBlockPlatform.getCoverTextureKey())) {
            return ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(ItemBlockPlatform.getCoverTextureKey()));
        }
        return new ItemStack((IItemProvider)Blocks.field_196662_n);
    }

    public static void setSubType(ItemStack stack, EnumSubType subtype) {
        if (!stack.func_190926_b()) {
            CompoundNBT tag = ItemBlockPlatform.getNBTTag(stack);
            tag.func_74778_a("subtype", subtype.func_176610_l());
        }
    }

    public static EnumSubType getSubType(ItemStack stack) {
        CompoundNBT tag;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlockPlatform && (tag = ItemBlockPlatform.getNBTTag(stack)).func_74764_b("subtype")) {
            return EnumSubType.byName(tag.func_74779_i("subtype"));
        }
        return EnumSubType.NONE;
    }

    public static String getFrameTextureKey() {
        return "frame_texture_item";
    }

    public static String getCoverTextureKey() {
        return "cover_texture_item";
    }

    public static CompoundNBT getNBTTag(ItemStack stack) {
        return stack.func_190925_c("BlockEntityTag");
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index >= 1 && index <= 4) {
            return Minecraft.func_71410_x().getItemColors().func_186728_a(index == 1 || index == 3 ? ItemBlockPlatform.getFrameTextureStack(data.stack) : ItemBlockPlatform.getCoverTextureStack(data.stack), 0);
        }
        return 0xFFFFFF;
    }
}

