/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import shetiphian.platforms.client.model.ModelData;
import shetiphian.platforms.common.misc.EnumTorchType;

public class Parts {
    static final List<ResourceLocation> TEXTURES = Parts.getTextures();
    static final List<ModelData> MODELS = Parts.getModels();

    static String getBrazierTexture() {
        return "platforms:block/brazier";
    }

    static String getBrazierFillTexture(EnumTorchType torch) {
        return "platforms:block/" + torch.toString();
    }

    static String getPlacementTexture() {
        return "platforms:block/placement";
    }

    private static List<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(new ResourceLocation(Parts.getBrazierTexture()));
        list.add(new ResourceLocation(Parts.getPlacementTexture()));
        for (EnumTorchType torch : EnumTorchType.values()) {
            if (torch == EnumTorchType.NONE) continue;
            list.add(new ResourceLocation(Parts.getBrazierFillTexture(torch)));
        }
        return list;
    }

    private static List<ModelData> getModels() {
        String[] handrails;
        String[] covers = new String[]{"lvl1", "lvl2", "lvl3"};
        ArrayList<ModelData> list = new ArrayList<ModelData>();
        String[] platforms = new String[]{"flat", "floor"};
        list.add(new ModelData("flat/base_corner", true));
        list.add(new ModelData("flat/base_normal", true));
        list.add(new ModelData("floor/base_corner_inside", true));
        list.add(new ModelData("floor/base_corner_middle", true));
        list.add(new ModelData("floor/base_corner_outside", true));
        list.add(new ModelData("floor/base_normal_edge", true));
        list.add(new ModelData("floor/base_normal_middle", true));
        for (String type : platforms) {
            list.add(new ModelData(type + "/edge_east", false));
            list.add(new ModelData(type + "/edge_north", false));
            list.add(new ModelData(type + "/edge_south", false));
            list.add(new ModelData(type + "/edge_west", false));
            list.add(new ModelData(type + "/middle_east", false));
            list.add(new ModelData(type + "/middle_north", false));
            list.add(new ModelData(type + "/middle_south", false));
            list.add(new ModelData(type + "/middle_west", false));
            list.add(new ModelData(type + "/middle_corner_sides", false));
            list.add(new ModelData(type + "/middle_corner_strip", false));
            list.add(new ModelData(type + "/middle_corner_bottom_east", false));
            list.add(new ModelData(type + "/middle_corner_bottom_north", false));
            list.add(new ModelData(type + "/middle_corner_bottom_south", false));
            list.add(new ModelData(type + "/middle_corner_bottom_west", false));
            list.add(new ModelData(type + "/middle_corner_top_east", false));
            list.add(new ModelData(type + "/middle_corner_top_north", false));
            list.add(new ModelData(type + "/middle_corner_top_south", false));
            list.add(new ModelData(type + "/middle_corner_top_west", false));
            list.add(new ModelData(type + "/inside_corner_sides", false));
            list.add(new ModelData(type + "/inside_corner_strip", false));
            list.add(new ModelData(type + "/inside_corner_east", false));
            list.add(new ModelData(type + "/inside_corner_north", false));
            list.add(new ModelData(type + "/inside_corner_south", false));
            list.add(new ModelData(type + "/inside_corner_west", false));
            list.add(new ModelData(type + "/inside_corner_bottom_east", false));
            list.add(new ModelData(type + "/inside_corner_bottom_north", false));
            list.add(new ModelData(type + "/inside_corner_bottom_south", false));
            list.add(new ModelData(type + "/inside_corner_bottom_west", false));
            list.add(new ModelData(type + "/inside_corner_top_east", false));
            list.add(new ModelData(type + "/inside_corner_top_north", false));
            list.add(new ModelData(type + "/inside_corner_top_south", false));
            list.add(new ModelData(type + "/inside_corner_top_west", false));
            list.add(new ModelData(type + "/outside_corner_sides", false));
            list.add(new ModelData(type + "/outside_corner_strip", false));
            list.add(new ModelData(type + "/outside_corner_east", false));
            list.add(new ModelData(type + "/outside_corner_north", false));
            list.add(new ModelData(type + "/outside_corner_south", false));
            list.add(new ModelData(type + "/outside_corner_west", false));
            list.add(new ModelData(type + "/outside_corner_bottom_east", false));
            list.add(new ModelData(type + "/outside_corner_bottom_north", false));
            list.add(new ModelData(type + "/outside_corner_bottom_south", false));
            list.add(new ModelData(type + "/outside_corner_bottom_west", false));
            list.add(new ModelData(type + "/outside_corner_top_east", false));
            list.add(new ModelData(type + "/outside_corner_top_north", false));
            list.add(new ModelData(type + "/outside_corner_top_south", false));
            list.add(new ModelData(type + "/outside_corner_top_west", false));
            for (String cover : covers) {
                list.add(new ModelData(type + "/cover_" + cover + "_edge", "minecraft:block/snow"));
                list.add(new ModelData(type + "/cover_" + cover + "_middle", "minecraft:block/snow"));
                list.add(new ModelData(type + "/cover_" + cover + "_inside_corner", "minecraft:block/snow"));
                list.add(new ModelData(type + "/cover_" + cover + "_outside_corner", "minecraft:block/snow"));
            }
        }
        list.add(new ModelData("floor/support_legs", true));
        list.add(new ModelData("floor/support_post_corner_inside", true));
        list.add(new ModelData("floor/support_post_corner_outside", true));
        list.add(new ModelData("floor/support_post_extension", true));
        list.add(new ModelData("floor/support_post_normal_edge", true));
        list.add(new ModelData("frame/bar", false));
        list.add(new ModelData("frame/support", true));
        list.add(new ModelData("frame/brazier_base", "platforms:block/brazier"));
        list.add(new ModelData("frame/brazier_fill", "platforms:block/light"));
        for (String cover : covers) {
            list.add(new ModelData("frame/cover_" + cover, "minecraft:block/snow"));
        }
        list.add(new ModelData("ramp/base_normal", true));
        list.add(new ModelData("ramp/base_normal_strut", true));
        list.add(new ModelData("ramp/base_corner_inside", true));
        list.add(new ModelData("ramp/base_corner_inside_strut", true));
        list.add(new ModelData("ramp/base_corner_inside_strut_ext_l", true));
        list.add(new ModelData("ramp/base_corner_inside_strut_ext_r", true));
        list.add(new ModelData("ramp/base_corner_outside", true));
        list.add(new ModelData("ramp/base_corner_outside_strut", true));
        list.add(new ModelData("ramp/base_corner_outside_strut_ext_l", true));
        list.add(new ModelData("ramp/base_corner_outside_strut_ext_r", true));
        list.add(new ModelData("ramp/right", false));
        list.add(new ModelData("ramp/left", false));
        list.add(new ModelData("ramp/middle", false));
        list.add(new ModelData("ramp/inside", false));
        list.add(new ModelData("ramp/outside", false));
        list.add(new ModelData("ramp/support_beam_right_lb", true));
        list.add(new ModelData("ramp/support_beam_right_sb", true));
        list.add(new ModelData("ramp/support_beam_left_lb", true));
        list.add(new ModelData("ramp/support_beam_left_sb", true));
        list.add(new ModelData("ramp/support_beam_middle", true));
        list.add(new ModelData("ramp/support_beam_inside", true));
        list.add(new ModelData("ramp/support_beam_outside", true));
        list.add(new ModelData("ramp/support_brace_right", true));
        list.add(new ModelData("ramp/support_brace_left", true));
        list.add(new ModelData("ramp/support_brace_middle", true));
        list.add(new ModelData("ramp/support_brace_inside", true));
        list.add(new ModelData("ramp/support_brace_outside", true));
        list.add(new ModelData("ramp/support_normal_legs", true));
        list.add(new ModelData("ramp/support_corner_inside_legs", true));
        list.add(new ModelData("ramp/support_corner_outside_legs", true));
        list.add(new ModelData("ramp/support_normal_post", true));
        list.add(new ModelData("ramp/support_corner_inside_post", true));
        list.add(new ModelData("ramp/support_corner_outside_post", true));
        list.add(new ModelData("ramp/rail_support_extension_left", true));
        list.add(new ModelData("ramp/rail_support_extension_right", true));
        for (String cover : covers) {
            list.add(new ModelData("ramp/cover_" + cover + "_right", "minecraft:block/snow"));
            list.add(new ModelData("ramp/cover_" + cover + "_left", "minecraft:block/snow"));
            list.add(new ModelData("ramp/cover_" + cover + "_middle", "minecraft:block/snow"));
            list.add(new ModelData("ramp/cover_" + cover + "_inside", "minecraft:block/snow"));
            list.add(new ModelData("ramp/cover_" + cover + "_outside", "minecraft:block/snow"));
        }
        for (String type : handrails = new String[]{"rise", "rail"}) {
            list.add(new ModelData(type + "/bar_inside_corner", false));
            list.add(new ModelData(type + "/bar_outside_corner", false));
            list.add(new ModelData(type + "/bar_edge", false));
            list.add(new ModelData(type + "/support_inside_corner", true));
            list.add(new ModelData(type + "/support_inside_corner_extended", true));
            list.add(new ModelData(type + "/support_outside_corner", true));
            list.add(new ModelData(type + "/support_outside_corner_extended", true));
            list.add(new ModelData(type + "/support_edge", true));
            list.add(new ModelData(type + "/support_edge_extended", true));
            list.add(new ModelData(type + "/bar_left_tall", false));
            list.add(new ModelData(type + "/bar_right_tall", false));
            list.add(new ModelData(type + "/support_left_tall", true));
            list.add(new ModelData(type + "/support_right_tall", true));
            for (String cover : covers) {
                list.add(new ModelData(type + "/cover_" + cover + "_edge", "minecraft:block/snow"));
                list.add(new ModelData(type + "/cover_" + cover + "_inside_corner", "minecraft:block/snow"));
                list.add(new ModelData(type + "/cover_" + cover + "_outside_corner", "minecraft:block/snow"));
                list.add(new ModelData(type + "/cover_" + cover + "_right_tall", "minecraft:block/snow"));
                list.add(new ModelData(type + "/cover_" + cover + "_left_tall", "minecraft:block/snow"));
            }
        }
        list.add(new ModelData("rise/brace_left_tall", false));
        list.add(new ModelData("rise/brace_right_tall", false));
        return list;
    }
}

