/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.gui.Textures;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.network.NetworkHandler;
import shetiphian.platforms.common.network.PacketPlatformSelect;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

@OnlyIn(value=Dist.CLIENT)
public class GuiPlatformSelect
extends Screen {
    private final PlayerEntity player;
    private final World world;
    private final BlockPos pos;
    private EntityGuiItem displayItem = null;
    private final List<ItemStack> types;
    private int start;
    private int index;
    private final int listSize;
    private final int xSize = 182;
    private final int ySize = 110;
    private int guiLeft;
    private int guiTop;
    private long debounce = System.currentTimeMillis();

    public GuiPlatformSelect(PlayerEntity player, World world, BlockPos pos, EnumPlatformType platformType, TileEntityPlatformBase tile) {
        super((ITextComponent)new StringTextComponent(""));
        this.player = player;
        this.world = world;
        this.pos = pos;
        Collection<EnumSubType> subTypes = null;
        Block block = tile.func_195044_w().func_177230_c();
        EnumSubType subType = null;
        if (block instanceof BlockPlatformBase) {
            subTypes = ((BlockPlatformBase)block).getAllowedValues();
            subType = ((BlockPlatformBase)block).getPlatformSubType(tile.func_195044_w());
        }
        if (subTypes == null) {
            throw new Error("Unexpected Platform");
        }
        this.start = 0;
        int index = 0;
        for (EnumSubType type : subTypes) {
            if (type == subType) {
                this.start = index;
                break;
            }
            ++index;
        }
        this.index = this.start;
        ItemStack basePlatform = ItemBlockPlatform.createStack(platformType, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        this.types = new ArrayList<ItemStack>();
        for (EnumSubType type : subTypes) {
            ItemStack stack = basePlatform.func_77946_l();
            ItemBlockPlatform.setSubType(stack, type);
            this.types.add(stack);
        }
        this.listSize = this.types.size();
        this.updateDisplayItem();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
    }

    private void updateDisplayItem() {
        this.displayItem = new EntityGuiItem(this.world, 0.0, 0.0, 0.0, this.types.get(this.index));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int count;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WRENCH.get());
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.func_238474_b_(matrixStack, this.guiLeft, this.guiTop, 0, 0, 182, 110);
        GuiFunctions.exitDrawTextureStateWithBlend();
        int centerX = this.guiLeft + this.xSize / 2;
        int centerY = this.guiTop + this.ySize / 2;
        GuiPlatformSelect.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(this.index + 1 + " / " + this.listSize), (int)centerX, (int)(centerY + 5), (int)-30720);
        GuiPlatformSelect.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)Localization.get((String)"gui.platform_select.back.txt"), (int)centerX, (int)(centerY + 14), (int)-7631989);
        GuiPlatformSelect.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)Localization.get((String)"gui.platform_select.next.txt"), (int)centerX, (int)(centerY + 22), (int)-7631989);
        GuiPlatformSelect.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)Localization.get((String)"gui.platform_select.first.txt"), (int)centerX, (int)(centerY + 30), (int)-7631989);
        GuiPlatformSelect.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)Localization.get((String)"gui.platform_select.save.txt"), (int)centerX, (int)(centerY + 38), (int)-7631989);
        if (this.displayItem != null) {
            this.displayItem.render(this.getMinecraft(), true, 130.0f, 0.0f, 0.0f, (float)(this.guiLeft + 91), (float)(this.guiTop + 52), 50.0f, -90.0f, 90.0f, 90.0f);
        }
        if ((count = this.types.size()) > 1) {
            this.field_230707_j_.func_180450_b(this.types.get(this.getOffsetIndex(-1)), this.guiLeft + 52, this.guiTop + 34);
            this.field_230707_j_.func_180450_b(this.types.get(this.getOffsetIndex(1)), this.guiLeft + 114, this.guiTop + 34);
        }
        if (count > 4) {
            this.field_230707_j_.func_180450_b(this.types.get(this.getOffsetIndex(-2)), this.guiLeft + 34, this.guiTop + 34);
            this.field_230707_j_.func_180450_b(this.types.get(this.getOffsetIndex(2)), this.guiLeft + 132, this.guiTop + 34);
        }
        if (count > 6) {
            this.field_230707_j_.func_180450_b(this.types.get(this.getOffsetIndex(-3)), this.guiLeft + 16, this.guiTop + 34);
            this.field_230707_j_.func_180450_b(this.types.get(this.getOffsetIndex(3)), this.guiLeft + 150, this.guiTop + 34);
        }
    }

    private int getOffsetIndex(int offset) {
        int value = this.index + offset;
        int max = this.listSize - 1;
        return value < 0 ? max : (value > max ? 0 : value);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.index = this.getOffsetIndex(1);
            this.updateDisplayItem();
        } else if (scroll > 0.0) {
            this.index = this.getOffsetIndex(-1);
            this.updateDisplayItem();
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1 && System.currentTimeMillis() > this.debounce + 25L) {
            this.setPlatform();
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 257: 
            case 335: {
                this.setPlatform();
                return true;
            }
            case 263: 
            case 264: {
                this.index = this.getOffsetIndex(-1);
                this.updateDisplayItem();
                return true;
            }
            case 262: 
            case 265: {
                this.index = this.getOffsetIndex(1);
                this.updateDisplayItem();
                return true;
            }
            case 32: {
                this.index = this.start;
                this.updateDisplayItem();
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private void setPlatform() {
        if (this.index != this.start) {
            NetworkHandler.sendToServer(new PacketPlatformSelect(ItemBlockPlatform.getSubType(this.types.get(this.index)).ordinal(), this.pos));
        }
        for (Hand hand : Hand.values()) {
            ItemStack stack = this.player.func_184586_b(hand);
            Set toolTypes = stack.func_77973_b().getToolTypes(stack);
            if (!toolTypes.contains(Values.WRENCH)) continue;
            this.player.func_184609_a(hand);
            break;
        }
        this.field_230706_i_.field_71439_g.func_71053_j();
    }

    public boolean func_231177_au__() {
        return false;
    }
}

