/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.CompositeBakedModel;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.client.model.CacheBuilder;
import shetiphian.platforms.client.model.Parts;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;

@OnlyIn(value=Dist.CLIENT)
public class ModelPlatform {
    private static String getTextureForRenderLayer(ItemStack stack, RenderType layer) {
        boolean doRender;
        if (layer == null || stack.func_190926_b()) {
            return Parts.getPlacementTexture();
        }
        BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)stack);
        boolean bl = doRender = layer == RenderType.func_228639_c_();
        doRender = RenderTypeLookup.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.func_228645_f_()) ? layer == RenderType.func_228645_f_() : (RenderTypeLookup.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.func_228643_e_()) || RenderTypeLookup.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.func_228641_d_()) ? layer == RenderType.func_228643_e_() : doRender);
        return doRender ? CacheBuilder.getTexture(stack) : null;
    }

    private static void addParts_Flat(List<IBakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, EnumPlatformType railType, Pair<String, String> levelData) {
        String base = subType.getBase();
        String style = subType.getStyle();
        String name = style + (base.equals("corner") ? "_corner" : "");
        ModelPlatform.add(list, "flat/base_" + base, textures[0], style.equals("inside") ? facing.func_176734_d() : facing, particle);
        for (String part : subType.getParts()) {
            ModelPlatform.add(list, "flat/" + name + "_" + part, textures[1], facing, particle);
        }
        if (railType != null && !subType.getStyle().equals("middle")) {
            ModelPlatform.addParts_Rise(list, subType, new String[]{textures[2], textures[3]}, particle, facing, railType == EnumPlatformType.RAIL, false, levelData);
        }
        if (levelData != null) {
            ModelPlatform.add(list, "flat/" + (String)levelData.getLeft() + "_" + name, (String)levelData.getRight(), facing, (String)levelData.getRight());
        }
    }

    private static void addParts_Ramp(List<IBakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, EnumPlatformType railType, int support, Pair<String, String> levelData, Pair<Boolean, Boolean> supportExtensions) {
        ModelPlatform.add(list, "ramp/" + subType.getStyle(), textures[1], facing, particle);
        String base = subType.getBase().equals("normal") ? "normal" : subType.getBase() + "_" + subType.getStyle();
        ModelPlatform.add(list, "ramp/base_" + base, textures[0], facing, particle);
        ModelPlatform.add(list, "ramp/base_" + base + "_strut", textures[0], facing, particle);
        if (((Boolean)supportExtensions.getLeft()).booleanValue()) {
            ModelPlatform.add(list, "ramp/base_" + base + "_strut_ext_l", textures[0], facing, particle);
        }
        if (((Boolean)supportExtensions.getRight()).booleanValue()) {
            ModelPlatform.add(list, "ramp/base_" + base + "_strut_ext_r", textures[0], facing, particle);
        }
        if (support % 3 < 2) {
            ModelPlatform.add(list, "ramp/support_" + base + (support % 3 == 1 ? "_post" : "_legs"), textures[0], facing, particle);
        }
        if (support > 2) {
            String extra = subType.getStyle().equals("right") || subType.getStyle().equals("left") ? (support % 3 != 1 ? "_sb" : "_lb") : "";
            ModelPlatform.add(list, "ramp/support_beam_" + subType.getStyle() + extra, textures[0], facing, particle);
            ModelPlatform.add(list, "ramp/support_brace_" + subType.getStyle(), textures[0], facing, particle);
        }
        if (railType == EnumPlatformType.RAIL && subType.supportsRail(EnumPlatformType.RAMP)) {
            ModelPlatform.add(list, "ramp/rail_support_extension_" + subType.getStyle(), textures[2], facing, particle);
        }
        if (levelData != null) {
            ModelPlatform.add(list, "ramp/" + (String)levelData.getLeft() + "_" + subType.getStyle(), (String)levelData.getRight(), facing, (String)levelData.getRight());
        }
    }

    private static void addParts_Floor(List<IBakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, int support, Pair<String, String> levelData) {
        String base = subType.getBase();
        String style = subType.getStyle();
        String leg_base = base + "_" + style;
        String name = style + (base.equals("corner") ? "_corner" : "");
        ModelPlatform.add(list, "floor/base_" + leg_base, textures[0], style.equals("inside") ? facing.func_176734_d() : facing, particle);
        for (String part : subType.getParts()) {
            ModelPlatform.add(list, "floor/" + name + "_" + part, textures[1], facing, particle);
        }
        if (support == 0) {
            ModelPlatform.add(list, "floor/support_legs", textures[0], facing, particle);
        } else if (support == 1) {
            if (!style.equals("middle")) {
                ModelPlatform.add(list, "floor/support_post_" + leg_base, textures[0], style.equals("inside") ? facing.func_176734_d() : facing, particle);
            } else {
                ModelPlatform.add(list, "floor/support_post_extension", textures[0], facing, particle);
            }
        }
        if (levelData != null) {
            ModelPlatform.add(list, "floor/" + (String)levelData.getLeft() + "_" + name, (String)levelData.getRight(), facing, (String)levelData.getRight());
        }
    }

    private static void addParts_Rise(List<IBakedModel> list, EnumSubType type, String[] textures, String particle, Direction facing, boolean isRail, boolean isLinkedToFloor, Pair<String, String> levelData) {
        if (!type.getStyle().equals("middle")) {
            String variant = isRail ? "rail" : "rise";
            String name = type.getStyle() + (type.getBase().equals("corner") ? "_corner" : "");
            if (name.equals("left") || name.equals("right")) {
                name = name + "_tall";
            }
            ModelPlatform.add(list, variant + "/bar_" + name, textures[1], facing, particle);
            ModelPlatform.add(list, variant + "/support_" + name + (isLinkedToFloor ? "_extended" : ""), textures[0], facing, particle);
            if (variant.equals("rise")) {
                ModelPlatform.add(list, variant + "/brace_" + name, textures[1], facing, particle);
            }
            if (levelData != null) {
                ModelPlatform.add(list, variant + "/" + (String)levelData.getLeft() + "_" + name, (String)levelData.getRight(), facing, (String)levelData.getRight());
            }
        }
    }

    private static void add(List<IBakedModel> list, String part, String key, Direction facing, String particle) {
        IBakedModel model;
        if (!Strings.isNullOrEmpty((String)key) && (model = CacheBuilder.get(part, key, facing, particle)) != null) {
            list.add(model);
        }
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static Map<EnumPlatformType, ItemCameraTransforms> transforms = new HashMap<EnumPlatformType, ItemCameraTransforms>();

        private ItemHandler() {
        }

        IBakedModel getModel(ItemStack stack, IBakedModel original) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlockPlatform) {
                EnumPlatformType platformType = ((ItemBlockPlatform)stack.func_77973_b()).getPlatformType();
                if (!transforms.containsKey((Object)platformType)) {
                    transforms.put(platformType, this.buildTransforms(platformType));
                }
                String key1 = CacheBuilder.getTexture(ItemBlockPlatform.getFrameTextureStack(stack));
                String key2 = CacheBuilder.getTexture(ItemBlockPlatform.getCoverTextureStack(stack));
                EnumSubType subType = ItemBlockPlatform.getSubType(stack);
                ArrayList list = new ArrayList();
                switch (platformType) {
                    case FLAT: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "flat/edge_north", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "flat/base_normal", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Flat(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, null, (Pair<String, String>)null);
                        break;
                    }
                    case FLOOR: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "floor/edge_north", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "floor/base_normal_edge", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Floor(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, 0, (Pair<String, String>)null);
                        break;
                    }
                    case FRAME: {
                        ModelPlatform.add(list, "frame/bar", key2, Direction.NORTH, key2);
                        ModelPlatform.add(list, "frame/support", key1, Direction.NORTH, key2);
                        break;
                    }
                    case RAMP: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "ramp/left", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "ramp/base_normal", key1, Direction.NORTH, key2);
                            ModelPlatform.add(list, "ramp/base_normal_strut", key1, Direction.NORTH, key2);
                            ModelPlatform.add(list, "ramp/support_normal_post", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Ramp(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, null, 1, (Pair<String, String>)null, (Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)false));
                        break;
                    }
                    case RISE: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "rise/bar_edge", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "rise/support_edge", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Rise(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, false, false, (Pair<String, String>)null);
                        break;
                    }
                    case RAIL: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "rail/bar_edge", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "rail/support_edge", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Rise(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, true, false, (Pair<String, String>)null);
                    }
                }
                return new AssembledBakedModel(list, new ItemCameraTransforms[]{transforms.get((Object)platformType)});
            }
            return original;
        }

        private ItemCameraTransforms buildTransforms(EnumPlatformType platformType) {
            switch (platformType) {
                case FLAT: {
                    return this.getFlatTransforms();
                }
                case FLOOR: {
                    return this.getFloorTransforms();
                }
                case FRAME: {
                    return this.getFrameTransforms();
                }
                case RAMP: {
                    return this.getRampTransforms();
                }
                case RISE: {
                    return this.getRiseTransforms();
                }
                case RAIL: {
                    return this.getRailTransforms();
                }
            }
            return ItemCameraTransforms.field_178357_a;
        }

        private ItemCameraTransforms getFlatTransforms() {
            ItemTransformVec3f thirdperson_left = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f thirdperson_right = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f firstperson_left = this.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f firstperson_right = this.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
            ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransformVec3f fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemCameraTransforms getRampTransforms() {
            ItemTransformVec3f thirdperson_left = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f thirdperson_right = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f firstperson_left = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f firstperson_right = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
            ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransformVec3f fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemCameraTransforms getFloorTransforms() {
            ItemTransformVec3f thirdperson_left = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f thirdperson_right = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f firstperson_left = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f firstperson_right = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
            ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransformVec3f fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemCameraTransforms getFrameTransforms() {
            ItemTransformVec3f thirdperson_left = this.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f thirdperson_right = this.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f firstperson_left = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f firstperson_right = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
            ItemTransformVec3f gui = this.create(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransformVec3f fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemCameraTransforms getRiseTransforms() {
            ItemTransformVec3f thirdperson_left = this.create(75.0f, 45.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f thirdperson_right = this.create(75.0f, 225.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f firstperson_left = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f firstperson_right = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
            ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.75f, -0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransformVec3f fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, -2.75f, 0.5f, 0.5f, 0.5f);
            return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemCameraTransforms getRailTransforms() {
            ItemTransformVec3f thirdperson_left = this.create(75.0f, 45.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f thirdperson_right = this.create(75.0f, 225.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransformVec3f firstperson_left = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f firstperson_right = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
            ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.75f, -0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransformVec3f fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, -2.75f, 0.5f, 0.5f, 0.5f);
            return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemTransformVec3f create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.func_195898_a(0.0625f);
            translation.func_195901_a(-5.0f, 5.0f);
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.func_195901_a(-4.0f, 4.0f);
            return new ItemTransformVec3f(rotation, translation, scale);
        }
    }

    private static class BlockHandler {
        static BlockHandler INSTANCE = new BlockHandler();

        private BlockHandler() {
        }

        List<IBakedModel> getList(BlockState state, IModelData data, RenderType layer) {
            ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
            if (state.func_177230_c() instanceof BlockPlatformBase) {
                CompoundNBT nbtTag;
                EnumPlatformType platformType = ((BlockPlatformBase)state.func_177230_c()).getPlatformType();
                Direction facing = (Direction)state.func_177229_b((Property)BlockPlatformBase.FACING);
                int level = (Integer)state.func_177229_b((Property)BlockPlatformBase.LEVEL);
                EnumSubType subType = ((BlockPlatformBase)state.func_177230_c()).getPlatformSubType(state);
                ItemStack itemBaseFrame = ItemStack.field_190927_a;
                ItemStack itemBaseCover = ItemStack.field_190927_a;
                EnumPlatformType railType = null;
                ItemStack itemRailFrame = ItemStack.field_190927_a;
                ItemStack itemRailCover = ItemStack.field_190927_a;
                EnumTorchType torch = EnumTorchType.NONE;
                byte support = 0;
                boolean linkedToFloor = false;
                Pair levelData = null;
                Pair supportExtensions = Pair.of((Object)false, (Object)false);
                if (data.hasProperty(ModelProperties.NBTProperty) && (nbtTag = (CompoundNBT)data.getData(ModelProperties.NBTProperty)) != null) {
                    ItemBlockPlatform platform;
                    ItemStack itemRail;
                    if (nbtTag.func_74764_b("frame_texture_item")) {
                        itemBaseFrame = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("frame_texture_item"));
                    }
                    if (nbtTag.func_74764_b("cover_texture_item")) {
                        itemBaseCover = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("cover_texture_item"));
                    }
                    if (nbtTag.func_74764_b("rail_item") && !(itemRail = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("rail_item"))).func_190926_b() && itemRail.func_77973_b() instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)itemRail.func_77973_b()).getPlatformType().isAddon()) {
                        railType = platform.getPlatformType();
                        itemRailFrame = ItemBlockPlatform.getFrameTextureStack(itemRail);
                        itemRailCover = ItemBlockPlatform.getCoverTextureStack(itemRail);
                    }
                    if (nbtTag.func_74764_b("torch")) {
                        torch = EnumTorchType.byIndex(nbtTag.func_74771_c("torch"));
                    }
                    if (nbtTag.func_74764_b("support")) {
                        support = nbtTag.func_74771_c("support");
                    }
                    if (nbtTag.func_74764_b("linkedToFloor")) {
                        linkedToFloor = nbtTag.func_74767_n("linkedToFloor");
                    }
                    if (level > 0 && nbtTag.func_74764_b("layer_texture_item")) {
                        String texture = ModelPlatform.getTextureForRenderLayer(ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("layer_texture_item")), layer);
                        String variant = "cover_lvl" + level;
                        levelData = Pair.of((Object)variant, (Object)texture);
                    }
                    if (nbtTag.func_74764_b("support_ext_left") && nbtTag.func_74764_b("support_ext_right")) {
                        supportExtensions = Pair.of((Object)nbtTag.func_74767_n("support_ext_left"), (Object)nbtTag.func_74767_n("support_ext_right"));
                    }
                }
                String particle = CacheBuilder.getTexture(itemBaseCover);
                String[] textures = new String[4];
                textures[0] = ModelPlatform.getTextureForRenderLayer(itemBaseFrame, layer);
                textures[1] = ModelPlatform.getTextureForRenderLayer(itemBaseCover, layer);
                if (railType != null) {
                    textures[2] = ModelPlatform.getTextureForRenderLayer(itemRailFrame, layer);
                    textures[3] = ModelPlatform.getTextureForRenderLayer(itemRailCover, layer);
                }
                switch (platformType) {
                    case FLAT: {
                        ModelPlatform.addParts_Flat(list, subType, textures, particle, facing, railType, (Pair<String, String>)levelData);
                        break;
                    }
                    case FLOOR: {
                        ModelPlatform.addParts_Floor(list, subType, textures, particle, facing, support, (Pair<String, String>)levelData);
                        break;
                    }
                    case FRAME: {
                        ModelPlatform.add(list, "frame/bar", textures[1], facing, particle);
                        ModelPlatform.add(list, "frame/support", textures[0], facing, particle);
                        if (torch != null && torch != EnumTorchType.NONE && layer == RenderType.func_228639_c_()) {
                            ModelPlatform.add(list, "frame/brazier_base", Parts.getBrazierTexture(), facing, particle);
                            ModelPlatform.add(list, "frame/brazier_fill", Parts.getBrazierFillTexture(torch), facing, particle);
                        }
                        if (levelData == null) break;
                        ModelPlatform.add(list, "frame/" + (String)levelData.getLeft(), (String)levelData.getRight(), facing, (String)levelData.getRight());
                        break;
                    }
                    case RAMP: {
                        ModelPlatform.addParts_Ramp(list, subType, textures, particle, facing, railType, support, (Pair<String, String>)levelData, (Pair<Boolean, Boolean>)supportExtensions);
                        break;
                    }
                    case RISE: {
                        ModelPlatform.addParts_Rise(list, subType, textures, particle, facing, false, linkedToFloor, (Pair<String, String>)levelData);
                        break;
                    }
                    case RAIL: {
                        ModelPlatform.addParts_Rise(list, subType, textures, particle, facing, true, linkedToFloor, (Pair<String, String>)levelData);
                    }
                }
            }
            return list;
        }
    }

    public static class Baked
    extends CompositeBakedModel {
        public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
            CompoundNBT nbtTag;
            ItemStack materialItem = ItemStack.field_190927_a;
            if (data.hasProperty(ModelProperties.NBTProperty) && (nbtTag = (CompoundNBT)data.getData(ModelProperties.NBTProperty)) != null && nbtTag.func_74764_b("cover_texture_item")) {
                materialItem = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("cover_texture_item"));
            }
            if (materialItem.func_190926_b()) {
                materialItem = new ItemStack((IItemProvider)Blocks.field_150359_w);
            }
            return CacheBuilder.getTextureSprite(materialItem);
        }

        protected List<IBakedModel> handleBlockState(BlockState state, Direction side, Random rand, IModelData data) {
            return BlockHandler.INSTANCE.getList(state, data, MinecraftForgeClient.getRenderLayer());
        }

        protected IBakedModel handleItemState(IBakedModel model, ItemStack stack, World world, LivingEntity entity) {
            return ItemHandler.INSTANCE.getModel(stack, model);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
            ArrayList<RenderMaterial> list = new ArrayList<RenderMaterial>();
            for (ResourceLocation location : Parts.TEXTURES) {
                list.add(new RenderMaterial(AtlasTexture.field_110575_b, location));
            }
            return ImmutableList.copyOf(list);
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            CacheBuilder.setup(bakery, spriteGetter);
            return new Baked();
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public void func_195410_a(IResourceManager resourceManager) {
            CacheBuilder.rebuildCache();
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new Geometry();
        }
    }
}

