/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFlat;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRamp;

@OnlyIn(value=Dist.CLIENT)
public class PlacementOverlay {
    private static final BlockModelRenderer RENDERER = new BlockModelRenderer(Minecraft.func_71410_x().func_184125_al());
    private final Random random = new Random();
    private static IModelData DEFAULT;
    private static IModelData ON_RAMP;
    private static IModelData ON_FLOOR;

    @SubscribeEvent
    public void drawBlockHighlightEvent(DrawHighlightEvent.HighlightBlock event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b()) {
            return;
        }
        if (this.isHoldingWrench((PlayerEntity)player) && event.getTarget() != null) {
            World world = player.func_130014_f_();
            Function.BlockInfo info = new Function.BlockInfo(world, event.getTarget());
            if (!info.state.isAir((IBlockReader)world, info.pos) && world.func_175723_af().func_177746_a(info.pos)) {
                this.renderOverlay((PlayerEntity)player, world, info, event.getPartialTicks(), event.getMatrix(), event.getBuffers(), event.getInfo().func_216785_c());
            }
        }
    }

    private boolean isHoldingWrench(PlayerEntity player) {
        for (Hand hand : Hand.values()) {
            Set toolTypes;
            ItemStack held = player.func_184586_b(hand);
            Set set = toolTypes = !held.func_190926_b() ? held.func_77973_b().getToolTypes(held) : null;
            if (toolTypes == null || !toolTypes.contains(Values.WRENCH)) continue;
            return true;
        }
        return false;
    }

    private static Vector3d getRenderVector(BlockPos pos, Vector3d projectedView) {
        return new Vector3d((double)pos.func_177958_n() - projectedView.field_72450_a, (double)pos.func_177956_o() - projectedView.field_72448_b, (double)pos.func_177952_p() - projectedView.field_72449_c);
    }

    private void renderOverlay(PlayerEntity player, World world, Function.BlockInfo info, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffers, Vector3d projectedView) {
        boolean isGlowstone;
        ItemStack mainHand = player.func_184614_ca();
        EnumPlatformType hoveredPlatformType = null;
        if (info.block instanceof BlockPlatformBase) {
            hoveredPlatformType = ((BlockPlatformBase)info.block).getPlatformType();
        }
        if (!mainHand.func_190926_b() && hoveredPlatformType == EnumPlatformType.FRAME && ((isGlowstone = TagHelper.isItemInTag((ItemStack)mainHand, (String)"forge:dusts/glowstone")) || EnumTorchType.isTorchItem(mainHand.func_77973_b()))) {
            boolean doDraw;
            EnumTorchType torch = TileHelper.getTorch(TileHelper.getPlatformTile((IBlockReader)world, info.pos));
            boolean bl = torch != null && (torch == EnumTorchType.NONE ? !isGlowstone : !torch.isUpgrade() && isGlowstone) ? true : (doDraw = false);
            if (doDraw) {
                double height = info.face.func_176743_c() == Direction.AxisDirection.NEGATIVE ? -0.01 : 16.01;
                this.renderBrazier(matrixStack, buffers.getBuffer((RenderType)RenderType.field_228614_Q_), PlacementOverlay.getRenderVector(info.pos, projectedView), info.face, height, isGlowstone);
                if (isGlowstone) {
                    return;
                }
            }
        }
        if (!mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ItemBlockPlatform) {
            TileEntityPlatformBase tile;
            ItemBlockPlatform itemBlockPlatform = (ItemBlockPlatform)mainHand.func_77973_b();
            EnumPlatformType platformType = itemBlockPlatform.getPlatformType();
            BlockPos placePos = world.func_180495_p(info.pos).func_185904_a().func_76222_j() ? info.pos : info.pos.func_177972_a(info.face);
            BlockState renderState = null;
            IModelData modelData = null;
            if (platformType.isAddon() && hoveredPlatformType != null && !hoveredPlatformType.isAddon() && (tile = TileHelper.getPlatformTile((IBlockReader)world, info.pos)) != null && BlockPlatformBase.canPlaceRailOn(tile.func_195044_w(), (IWorldReader)world, info.pos, tile) && tile.getRailType() == null && (tile instanceof TileEntityPlatformFlat || player.field_70170_p.func_180495_p(placePos.func_177984_a()).func_185904_a().func_76222_j())) {
                placePos = tile instanceof TileEntityPlatformFlat ? info.pos : info.pos.func_177984_a();
                BlockPlatformBase addon = (BlockPlatformBase)Values.blocksPlatform.get((Object)platformType);
                renderState = addon.func_176223_P();
                renderState = (BlockState)renderState.func_206870_a((Property)BlockPlatformBase.FACING, tile.func_195044_w().func_177229_b((Property)BlockPlatformBase.FACING));
                renderState = BlockPlatformBase.getStateWithPlatformSubType(renderState, EnumSubType.byName(((BlockPlatformBase)info.block).getPlatformSubType(info.state).getStyle()));
                modelData = this.getModelData(tile instanceof TileEntityPlatformRamp, tile instanceof TileEntityPlatformFloor);
            }
            if (renderState == null && world.func_180495_p(placePos).func_185904_a().func_76222_j()) {
                renderState = itemBlockPlatform.func_179223_d().func_196258_a((BlockItemUseContext)new UseContext(player, mainHand, Function.rayTrace((Entity)player, (double)(player.field_71075_bZ.field_75098_d ? 5.0 : 4.0), (float)partialTicks)));
                modelData = this.getModelData(false, false);
            }
            if (renderState != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
                BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
                Vector3d renderPos = PlacementOverlay.getRenderVector(placePos, projectedView);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(renderPos.field_72450_a, renderPos.field_72448_b, renderPos.field_72449_c);
                RENDERER.renderModel((IBlockDisplayReader)player.field_70170_p, dispatcher.func_184389_a(renderState), renderState, placePos, matrixStack, buffers.getBuffer(Atlases.func_228785_j_()), false, this.random, MathHelper.func_180186_a((Vector3i)placePos), 0, modelData);
                matrixStack.func_227865_b_();
                return;
            }
        }
        if (hoveredPlatformType != null) {
            Direction side;
            boolean rotate = hoveredPlatformType == EnumPlatformType.FRAME || !player.func_213453_ef();
            Direction direction = side = !hoveredPlatformType.isAddon() || info.face == Direction.DOWN ? info.face : Direction.UP;
            double height = side.func_176743_c() == Direction.AxisDirection.NEGATIVE ? -0.01 : (side == Direction.UP && hoveredPlatformType == EnumPlatformType.FLAT ? 2.01 : 16.01);
            this.renderWrenchAction(matrixStack, buffers.getBuffer((RenderType)RenderType.field_228614_Q_), PlacementOverlay.getRenderVector(info.pos, projectedView), side, height, rotate);
        }
    }

    private IModelData getModelData(boolean onRamp, boolean onFloor) {
        IModelData modelData;
        IModelData iModelData = onFloor ? ON_FLOOR : (modelData = onRamp ? ON_RAMP : DEFAULT);
        if (modelData == null) {
            CompoundNBT nbtTag = new CompoundNBT();
            nbtTag.func_74757_a("linkedToRamp", onRamp);
            nbtTag.func_74757_a("linkedToFloor", onFloor);
            modelData = new ModelDataMap.Builder().withInitial(ModelProperties.NBTProperty, (Object)nbtTag).build();
            if (onFloor) {
                ON_FLOOR = modelData;
            } else if (onRamp) {
                ON_RAMP = modelData;
            } else {
                DEFAULT = modelData;
            }
        }
        return modelData;
    }

    private void renderBrazier(MatrixStack matrixStack, IVertexBuilder renderer, Vector3d pos, Direction side, double height, boolean isUpgrade) {
        if (isUpgrade) {
            double offset = side.func_176740_k() == Direction.Axis.Y ? 1.5 : 0.0;
            this.addSidedLine(matrixStack, renderer, pos, 7.0, height, offset + 6.0, 8.0, height, offset + 5.0, side);
            this.addSidedLine(matrixStack, renderer, pos, 9.0, height, offset + 6.0, 8.0, height, offset + 5.0, side);
            this.addSidedLine(matrixStack, renderer, pos, 7.0, height, offset + 6.5, 8.0, height, offset + 5.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 9.0, height, offset + 6.5, 8.0, height, offset + 5.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 7.5, height, offset + 6.5, 8.5, height, offset + 6.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 7.5, height, offset + 7.0, 8.5, height, offset + 7.0, side);
            this.addSidedLine(matrixStack, renderer, pos, 7.5, height, offset + 7.5, 8.5, height, offset + 7.5, side);
        } else {
            this.addBox(matrixStack, renderer, pos, 5.0, 9.0, 5.0, 11.0, 9.5, 11.0, false);
            this.addBox(matrixStack, renderer, pos, 7.5, 7.0, 5.0, 8.5, 9.0, 6.0, false);
            this.addBox(matrixStack, renderer, pos, 7.5, 7.0, 10.0, 8.5, 9.0, 11.0, false);
            this.addBox(matrixStack, renderer, pos, 5.0, 7.0, 7.5, 6.0, 9.0, 8.5, false);
            this.addBox(matrixStack, renderer, pos, 10.0, 7.0, 7.5, 11.0, 9.0, 8.5, false);
            this.addBox(matrixStack, renderer, pos, 5.0, 9.8, 4.4, 5.0, 10.3, 4.6, 5.0, 8.9, 7.8, 5.0, 8.5, 7.7, 11.0, 9.8, 4.4, 11.0, 10.3, 4.6, 11.0, 8.9, 7.8, 11.0, 8.5, 7.7, false);
            this.addBox(matrixStack, renderer, pos, 5.0, 9.8, 4.4, 5.0, 10.3, 4.6, 5.0, 8.9, 7.8, 5.0, 8.5, 7.7, 11.0, 9.8, 4.4, 11.0, 10.3, 4.6, 11.0, 8.9, 7.8, 11.0, 8.5, 7.7, true);
            this.addBox(matrixStack, renderer, pos, 5.0, 9.8, 11.6, 5.0, 10.3, 11.4, 5.0, 8.9, 8.2, 5.0, 8.5, 8.3, 11.0, 9.8, 11.6, 11.0, 10.3, 11.4, 11.0, 8.9, 8.2, 11.0, 8.5, 8.3, false);
            this.addBox(matrixStack, renderer, pos, 5.0, 9.8, 11.6, 5.0, 10.3, 11.4, 5.0, 8.9, 8.2, 5.0, 8.5, 8.3, 11.0, 9.8, 11.6, 11.0, 10.3, 11.4, 11.0, 8.9, 8.2, 11.0, 8.5, 8.3, true);
        }
    }

    private void renderWrenchAction(MatrixStack matrixStack, IVertexBuilder renderer, Vector3d pos, Direction side, double height, boolean rotate) {
        if (!rotate || side.func_176740_k() == Direction.Axis.Y) {
            this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 6.5, 3.5, height, 4.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 4.5, 4.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 4.5, height, 3.5, 6.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 5.5, height, 2.5, 6.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 6.5, height, 3.5, 5.5, height, 4.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 9.5, 12.5, height, 11.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 11.5, 11.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 11.5, height, 12.5, 9.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 10.5, height, 11.5, 9.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 9.5, height, 12.5, 10.5, height, 13.5, side);
        }
        if (rotate) {
            if (side.func_176740_k() != Direction.Axis.Y) {
                this.addSidedLine(matrixStack, renderer, pos, 4.0, height, 8.0, 4.0, height, 7.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 5.0, height, 7.0, 4.0, height, 7.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 4.0, height, 7.0, 5.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 5.0, height, 8.0, 7.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 9.7, height, 7.3, 9.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 9.7, height, 8.7, 9.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 9.0, height, 8.0, 11.0, height, 8.0, side);
                this.addSidedLine(matrixStack, renderer, pos, 11.0, height, 8.0, 12.0, height, 7.0, side);
            } else {
                this.addSidedLine(matrixStack, renderer, pos, 9.5, height, 3.5, 11.5, height, 3.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 11.5, height, 3.5, 12.5, height, 4.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 4.5, 12.5, height, 6.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 11.5, height, 5.5, 12.5, height, 6.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 6.5, 13.5, height, 5.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 6.5, height, 12.5, 4.5, height, 12.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 4.5, height, 12.5, 3.5, height, 11.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 11.5, 3.5, height, 9.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 2.5, height, 10.5, 3.5, height, 9.5, side);
                this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 9.5, 4.5, height, 10.5, side);
            }
        } else {
            this.addSidedLine(matrixStack, renderer, pos, 9.5, height, 3.5, 12.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 3.5, 12.5, height, 6.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 12.5, height, 6.5, 9.5, height, 6.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 9.5, height, 6.5, 9.5, height, 3.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 9.5, 6.5, height, 9.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 6.5, height, 9.5, 6.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 6.5, height, 12.5, 3.5, height, 12.5, side);
            this.addSidedLine(matrixStack, renderer, pos, 3.5, height, 12.5, 3.5, height, 9.5, side);
        }
    }

    private void addBox(MatrixStack matrixStack, IVertexBuilder renderer, Vector3d pos, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, double x5, double y5, double z5, double x6, double y6, double z6, double x7, double y7, double z7, double x8, double y8, double z8, boolean rotate) {
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x2, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y2, z2, x3, y3, z3, rotate);
        this.addLine(matrixStack, renderer, pos, x3, y3, z3, x4, y4, z4, rotate);
        this.addLine(matrixStack, renderer, pos, x4, y4, z4, x1, y1, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x5, y5, z5, x6, y6, z6, rotate);
        this.addLine(matrixStack, renderer, pos, x6, y6, z6, x7, y7, z7, rotate);
        this.addLine(matrixStack, renderer, pos, x7, y7, z7, x8, y8, z8, rotate);
        this.addLine(matrixStack, renderer, pos, x8, y8, z8, x5, y5, z5, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x5, y5, z5, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y2, z2, x6, y6, z6, rotate);
        this.addLine(matrixStack, renderer, pos, x3, y3, z3, x7, y7, z7, rotate);
        this.addLine(matrixStack, renderer, pos, x4, y4, z4, x8, y8, z8, rotate);
    }

    private void addBox(MatrixStack matrixStack, IVertexBuilder renderer, Vector3d pos, double x1, double y1, double z1, double x2, double y2, double z2, boolean rotate) {
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x2, y1, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z2, x2, y1, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x1, y1, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y1, z1, x2, y1, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y2, z1, x2, y2, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y2, z2, x2, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y2, z1, x1, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y2, z1, x2, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z1, x1, y2, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x1, y1, z2, x1, y2, z2, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y1, z1, x2, y2, z1, rotate);
        this.addLine(matrixStack, renderer, pos, x2, y1, z2, x2, y2, z2, rotate);
    }

    private void addPlane(MatrixStack matrixStack, IVertexBuilder renderer, Vector3d pos, double pt1, double pt2, double pt3, double pt4, Direction.Axis axis, double com, boolean rotate) {
        switch (axis) {
            case X: {
                this.addLine(matrixStack, renderer, pos, com, pt1, pt2, com, pt3, pt2, rotate);
                this.addLine(matrixStack, renderer, pos, com, pt1, pt4, com, pt3, pt4, rotate);
                this.addLine(matrixStack, renderer, pos, com, pt1, pt2, com, pt1, pt4, rotate);
                this.addLine(matrixStack, renderer, pos, com, pt3, pt2, com, pt3, pt4, rotate);
                break;
            }
            case Y: {
                this.addLine(matrixStack, renderer, pos, pt1, com, pt2, pt3, com, pt2, rotate);
                this.addLine(matrixStack, renderer, pos, pt1, com, pt4, pt3, com, pt4, rotate);
                this.addLine(matrixStack, renderer, pos, pt1, com, pt2, pt1, com, pt4, rotate);
                this.addLine(matrixStack, renderer, pos, pt3, com, pt2, pt3, com, pt4, rotate);
                break;
            }
            case Z: {
                this.addLine(matrixStack, renderer, pos, pt1, pt2, com, pt3, pt2, com, rotate);
                this.addLine(matrixStack, renderer, pos, pt1, pt4, com, pt3, pt4, com, rotate);
                this.addLine(matrixStack, renderer, pos, pt1, pt2, com, pt1, pt4, com, rotate);
                this.addLine(matrixStack, renderer, pos, pt3, pt2, com, pt3, pt4, com, rotate);
            }
        }
    }

    private void addSidedLine(MatrixStack matrixStack, IVertexBuilder renderer, Vector3d pos, double x1, double y1, double z1, double x2, double y2, double z2, Direction facing) {
        switch (facing) {
            case DOWN: {
                this.addLine(matrixStack, renderer, pos, x1, y1, z1, x2, y2, z2, false);
                break;
            }
            case UP: {
                this.addLine(matrixStack, renderer, pos, x1, y1, z1, x2, y2, z2, false);
                break;
            }
            case NORTH: {
                this.addLine(matrixStack, renderer, pos, 16.0 - x1, 16.0 - z1, y1, 16.0 - x2, 16.0 - z2, y2, false);
                break;
            }
            case SOUTH: {
                this.addLine(matrixStack, renderer, pos, x1, 16.0 - z1, y1, x2, 16.0 - z2, y2, false);
                break;
            }
            case WEST: {
                this.addLine(matrixStack, renderer, pos, y1, 16.0 - z1, x1, y2, 16.0 - z2, x2, false);
                break;
            }
            case EAST: {
                this.addLine(matrixStack, renderer, pos, y1, 16.0 - z1, 16.0 - x1, y2, 16.0 - z2, 16.0 - x2, false);
            }
        }
    }

    private void addLine(MatrixStack matrixStack, IVertexBuilder renderer, Vector3d pos, double x1, double y1, double z1, double x2, double y2, double z2, boolean rotate) {
        this.add(matrixStack, renderer, pos, x1, y1, z1, rotate);
        this.add(matrixStack, renderer, pos, x2, y2, z2, rotate);
    }

    private void add(MatrixStack matrixStack, IVertexBuilder renderer, Vector3d pos, double x, double y, double z, boolean rotate) {
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        double d = y == 0.0 ? 0.01 : (y = y == 16.0 ? 15.99 : y);
        if (rotate) {
            renderer.func_227888_a_(matrix4f, (float)(pos.func_82615_a() + z * 0.0625), (float)(pos.func_82617_b() + y * 0.0625), (float)(pos.func_82616_c() + x * 0.0625)).func_227885_a_(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        } else {
            renderer.func_227888_a_(matrix4f, (float)(pos.func_82615_a() + x * 0.0625), (float)(pos.func_82617_b() + y * 0.0625), (float)(pos.func_82616_c() + z * 0.0625)).func_227885_a_(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        }
    }
}

