/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class MetallurgicInfuserCachedRecipe
extends CachedRecipe<MetallurgicInfuserRecipe> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull InfusionStack> infusionInputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;

    public MetallurgicInfuserCachedRecipe(MetallurgicInfuserRecipe recipe, IInputHandler<@NonNull InfusionStack> infusionInputHandler, IInputHandler<@NonNull ItemStack> itemInputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.infusionInputHandler = infusionInputHandler;
        this.itemInputHandler = itemInputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((MetallurgicInfuserRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        InfusionStack recipeInfuseObject = this.infusionInputHandler.getRecipeInput(((MetallurgicInfuserRecipe)this.recipe).getInfusionInput());
        if (recipeInfuseObject.isEmpty()) {
            return -1;
        }
        currentMax = this.itemInputHandler.operationsCanSupport(((MetallurgicInfuserRecipe)this.recipe).getItemInput(), currentMax);
        currentMax = this.infusionInputHandler.operationsCanSupport(((MetallurgicInfuserRecipe)this.recipe).getInfusionInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((MetallurgicInfuserRecipe)this.recipe).getOutput(recipeInfuseObject, recipeItem), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((MetallurgicInfuserRecipe)this.recipe).test(this.infusionInputHandler.getInput(), this.itemInputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((MetallurgicInfuserRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        InfusionStack recipeInfuseObject = this.infusionInputHandler.getRecipeInput(((MetallurgicInfuserRecipe)this.recipe).getInfusionInput());
        if (recipeInfuseObject.isEmpty()) {
            return;
        }
        this.infusionInputHandler.use(recipeInfuseObject, operations);
        this.itemInputHandler.use(recipeItem, operations);
        this.outputHandler.handleOutput(((MetallurgicInfuserRecipe)this.recipe).getOutput(recipeInfuseObject, recipeItem), operations);
    }
}

