/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import org.apache.commons.lang3.tuple.Pair;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalInfuserCachedRecipe
extends CachedRecipe<ChemicalInfuserRecipe> {
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull GasStack> leftInputHandler;
    private final IInputHandler<@NonNull GasStack> rightInputHandler;

    public ChemicalInfuserCachedRecipe(ChemicalInfuserRecipe recipe, IInputHandler<@NonNull GasStack> leftInputHandler, IInputHandler<@NonNull GasStack> rightInputHandler, IOutputHandler<@NonNull GasStack> outputHandler) {
        super(recipe);
        this.leftInputHandler = leftInputHandler;
        this.rightInputHandler = rightInputHandler;
        this.outputHandler = outputHandler;
    }

    @Nullable
    private Pair<GasStackIngredient, GasStackIngredient> getIngredients() {
        GasStack leftInputGas = this.leftInputHandler.getInput();
        if (leftInputGas.isEmpty()) {
            return null;
        }
        GasStack rightInputGas = this.rightInputHandler.getInput();
        if (rightInputGas.isEmpty()) {
            return null;
        }
        GasStackIngredient leftInput = ((ChemicalInfuserRecipe)this.recipe).getLeftInput();
        GasStackIngredient rightInput = ((ChemicalInfuserRecipe)this.recipe).getRightInput();
        if (!leftInput.test(leftInputGas) || !rightInput.test(rightInputGas)) {
            return Pair.of((Object)rightInput, (Object)leftInput);
        }
        return Pair.of((Object)leftInput, (Object)rightInput);
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        Pair<GasStackIngredient, GasStackIngredient> ingredients = this.getIngredients();
        if (ingredients == null) {
            return -1;
        }
        GasStack leftRecipeInput = this.leftInputHandler.getRecipeInput((InputIngredient)ingredients.getLeft());
        if (leftRecipeInput.isEmpty()) {
            return -1;
        }
        GasStack rightRecipeInput = this.rightInputHandler.getRecipeInput((InputIngredient)ingredients.getRight());
        if (rightRecipeInput.isEmpty()) {
            return -1;
        }
        currentMax = this.leftInputHandler.operationsCanSupport((InputIngredient)ingredients.getLeft(), currentMax);
        currentMax = this.rightInputHandler.operationsCanSupport((InputIngredient)ingredients.getRight(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ChemicalInfuserRecipe)this.recipe).getOutput(leftRecipeInput, rightRecipeInput), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ChemicalInfuserRecipe)this.recipe).test(this.leftInputHandler.getInput(), this.rightInputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        Pair<GasStackIngredient, GasStackIngredient> ingredients = this.getIngredients();
        if (ingredients == null) {
            return;
        }
        GasStack leftRecipeInput = this.leftInputHandler.getRecipeInput((InputIngredient)ingredients.getLeft());
        if (leftRecipeInput.isEmpty()) {
            return;
        }
        GasStack rightRecipeInput = this.rightInputHandler.getRecipeInput((InputIngredient)ingredients.getRight());
        if (rightRecipeInput.isEmpty()) {
            return;
        }
        this.leftInputHandler.use(leftRecipeInput, operations);
        this.rightInputHandler.use(rightRecipeInput, operations);
        this.outputHandler.handleOutput(((ChemicalInfuserRecipe)this.recipe).getOutput(leftRecipeInput, rightRecipeInput), operations);
    }
}

