/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.pipez.recipes.ModRecipes;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ClearNbtRecipe
extends SpecialRecipe {
    private Ingredient ingredient;

    public ClearNbtRecipe(ResourceLocation recipeID, Ingredient ingredient) {
        super(recipeID);
        this.ingredient = ingredient;
    }

    @Nullable
    public ItemStack getIngredient(CraftingInventory inv) {
        ItemStack found = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (this.ingredient.test(stackInSlot)) {
                if (found != null) {
                    return null;
                }
                found = stackInSlot;
                continue;
            }
            if (stackInSlot.func_190926_b()) continue;
            return null;
        }
        return found;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.getIngredient(inv) != null;
    }

    public ItemStack assemble(CraftingInventory inv) {
        ItemStack ingredient = this.getIngredient(inv);
        if (ingredient == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ingredient.func_77946_l();
        stack.func_77982_d(null);
        stack.func_190920_e(1);
        return stack;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.CLEAR_NBT;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ClearNbtRecipe> {
        public static final ResourceLocation NAME = new ResourceLocation("pipez", "clear_nbt");

        public ClearNbtRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new ClearNbtRecipe(recipeId, Ingredient.func_199802_a((JsonElement)json.get("item")));
        }

        public ClearNbtRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            return new ClearNbtRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer));
        }

        public void toNetwork(PacketBuffer buffer, ClearNbtRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
        }
    }
}

