/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.integration.waila;

import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HUDHandlerPipes
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    static final HUDHandlerPipes INSTANCE = new HUDHandlerPipes();

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        CompoundNBT compound = accessor.getServerData();
        if (compound.func_150297_b("Upgrade", 8)) {
            tooltip.add((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("Upgrade")));
        }
        tooltip.addAll(this.getTooltips(compound));
    }

    public void appendServerData(CompoundNBT compound, ServerPlayerEntity player, World world, TileEntity te) {
        if (te.func_195044_w().func_177230_c() instanceof PipeBlock) {
            PipeBlock pipe = (PipeBlock)te.func_195044_w().func_177230_c();
            Direction selectedSide = pipe.getSelection(te.func_195044_w(), (IBlockReader)world, te.func_174877_v(), (PlayerEntity)player).getKey();
            if (selectedSide == null) {
                return;
            }
            if (!(te instanceof UpgradeTileEntity)) {
                return;
            }
            PipeLogicTileEntity pipeTile = (PipeLogicTileEntity)te;
            if (!pipeTile.isExtracting(selectedSide)) {
                return;
            }
            ItemStack upgrade = pipeTile.getUpgradeItem(selectedSide);
            if (upgrade.func_190926_b()) {
                compound.func_74778_a("Upgrade", ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent("tooltip.pipez.no_upgrade")));
            } else {
                compound.func_74778_a("Upgrade", ITextComponent.Serializer.func_150696_a((ITextComponent)upgrade.func_200301_q()));
            }
            ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
            for (PipeType<?> pipeType : pipeTile.getPipeTypes()) {
                if (!pipeTile.isEnabled(selectedSide, pipeType)) continue;
                tooltips.add(pipeType.getTransferText(pipeTile.getUpgrade(selectedSide)));
            }
            this.putTooltips(compound, tooltips);
        }
    }

    public void putTooltips(CompoundNBT compound, List<ITextComponent> tooltips) {
        ListNBT list = new ListNBT();
        for (ITextComponent tooltip : tooltips) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)tooltip)));
        }
        compound.func_218657_a("Tooltips", (INBT)list);
    }

    public List<ITextComponent> getTooltips(CompoundNBT compound) {
        ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
        if (!compound.func_150297_b("Tooltips", 9)) {
            return tooltips;
        }
        ListNBT list = compound.func_150295_c("Tooltips", 8);
        for (int i = 0; i < list.size(); ++i) {
            tooltips.add((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)list.func_150307_f(i)));
        }
        return tooltips;
    }
}

