/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.configuration;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.configuration.CachedPipeConfiguration;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class FilterCache
extends CachedPipeConfiguration<List<Filter<?>>> {
    protected Function<PipeType<?>, Filter<?>> filterCreator;

    public FilterCache(Supplier<NonNullList<ItemStack>> upgradeInventory, Function<PipeType<?>, Filter<?>> filterCreator, Runnable onDirty) {
        super(upgradeInventory, "Filters", pipeType -> new ArrayList(), onDirty);
        this.filterCreator = filterCreator;
    }

    @Override
    public INBT serialize(List<Filter<?>> filters) {
        ListNBT list = new ListNBT();
        for (Filter<?> filter : filters) {
            list.add((Object)filter.serializeNBT());
        }
        return list;
    }

    @Override
    @Nullable
    public List<Filter<?>> deserialize(PipeType<?> pipeType, INBT inbt) {
        if (inbt instanceof ListNBT) {
            ListNBT list = (ListNBT)inbt;
            ArrayList filters = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                Filter<?> filter = this.filterCreator.apply(pipeType);
                filter.deserializeNBT(list.func_150305_b(i));
                filters.add(filter);
            }
            return filters;
        }
        return null;
    }
}

