/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.configuration;

import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;

public abstract class CachedPipeConfiguration<T> {
    private Map<PipeType<?>, T>[] cachedValues;
    protected Supplier<NonNullList<ItemStack>> upgradeInventory;
    protected String key;
    protected Function<PipeType<?>, T> defaultValue;
    protected Runnable onDirty;

    public CachedPipeConfiguration(Supplier<NonNullList<ItemStack>> upgradeInventory, String key, Function<PipeType<?>, T> defaultValue, Runnable onDirty) {
        this.upgradeInventory = upgradeInventory;
        this.key = key;
        this.defaultValue = defaultValue;
        this.onDirty = onDirty;
        this.cachedValues = new HashMap[Direction.values().length];
    }

    public T getValue(Direction side, PipeType<?> pipeType) {
        Map<PipeType<?>, T> map = this.cachedValues[side.ordinal()];
        if (map == null) {
            map = new HashMap();
            this.cachedValues[side.ordinal()] = map;
        }
        if (map.containsKey(pipeType)) {
            return map.get(pipeType);
        }
        ItemStack stack = (ItemStack)this.upgradeInventory.get().get(side.ordinal());
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return this.putDefault(pipeType, map);
        }
        CompoundNBT tag = stack.func_77978_p();
        if (!tag.func_150297_b(pipeType.getKey(), 10)) {
            return this.putDefault(pipeType, map);
        }
        CompoundNBT compound = tag.func_74775_l(pipeType.getKey());
        if (!compound.func_74764_b(this.key)) {
            return this.putDefault(pipeType, map);
        }
        T value = this.deserialize(pipeType, compound.func_74781_a(this.key));
        if (value == null) {
            return this.putDefault(pipeType, map);
        }
        map.put(pipeType, value);
        return value;
    }

    public T putDefault(PipeType<?> pipeType, Map<PipeType<?>, T> map) {
        T def = this.defaultValue.apply(pipeType);
        map.put(pipeType, def);
        return def;
    }

    public void setValue(Direction side, PipeType<?> pipeType, T value) {
        CompoundNBT compound;
        ItemStack stack;
        Map<PipeType<?>, T> map = this.cachedValues[side.ordinal()];
        if (map == null) {
            map = new HashMap();
            this.cachedValues[side.ordinal()] = map;
        }
        if ((stack = (ItemStack)this.upgradeInventory.get().get(side.ordinal())).func_190926_b()) {
            return;
        }
        map.put(pipeType, value);
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_150297_b(pipeType.getKey(), 10)) {
            compound = tag.func_74775_l(pipeType.getKey());
        } else {
            compound = new CompoundNBT();
            tag.func_218657_a(pipeType.getKey(), (INBT)compound);
        }
        compound.func_218657_a(this.key, this.serialize(value));
        this.onDirty.run();
    }

    public void invalidate() {
        for (Map<PipeType<?>, T> map : this.cachedValues) {
            if (map == null) continue;
            map.clear();
        }
    }

    public abstract INBT serialize(T var1);

    @Nullable
    public abstract T deserialize(PipeType<?> var1, INBT var2);
}

