/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.tile;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.tileentity.TileEntity;
import net.roguelogix.phosphophyllite.tile.ITileModule;

public class ModuleRegistry {
    private static final LinkedHashMap<Class<?>, Function<TileEntity, ITileModule>> moduleRegistry = new LinkedHashMap();
    private static final ArrayList<BiConsumer<Class<?>, Function<TileEntity, ITileModule>>> externalRegistrars = new ArrayList();

    public static synchronized void registerModule(Class<?> moduleInterface, Function<TileEntity, ITileModule> constructor) {
        moduleRegistry.put(moduleInterface, constructor);
        externalRegistrars.forEach((Consumer<BiConsumer<Class<?>, Function<TileEntity, ITileModule>>>)((Consumer<BiConsumer>)c -> c.accept(moduleInterface, constructor)));
    }

    public static synchronized void registerExternalRegistrar(BiConsumer<Class<?>, Function<TileEntity, ITileModule>> registrar) {
        externalRegistrars.add(registrar);
        moduleRegistry.forEach(registrar);
    }

    public static void forEach(BiConsumer<Class<?>, Function<TileEntity, ITileModule>> callback) {
        moduleRegistry.forEach(callback);
    }
}

