/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.robn;

import com.mojang.datafixers.util.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.roguelogix.phosphophyllite.robn.ROBNObject;

public class ROBN {
    public static <T> ArrayList<Byte> toROBN(T t) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        ROBN.toROBN(t, arrayList);
        return arrayList;
    }

    public static Object fromROBN(ArrayList<Byte> buf) {
        return ROBN.fromROBN(buf.iterator());
    }

    private static void requestBytes(ArrayList<Byte> buf, int requiredBytes) {
        buf.ensureCapacity(buf.size() + requiredBytes);
    }

    private static <T> void toROBN(T t, ArrayList<Byte> buf) {
        if (t instanceof Boolean) {
            buf.add(Type.Bool.val);
            buf.add((byte)((Boolean)t != false ? 1 : 0));
            return;
        }
        if (t instanceof String) {
            ROBN.stringToROBN((String)t, buf);
            return;
        }
        if (t instanceof Number) {
            ROBN.numberToROBN((Number)t, buf);
            return;
        }
        if (t instanceof Collection) {
            ROBN.vectorToROBN((Collection)t, buf);
            return;
        }
        if (t instanceof Map) {
            ROBN.mapToROBN((Map)t, buf);
            return;
        }
        if (t instanceof Pair) {
            ROBN.pairToROBN((Pair)t, buf);
            return;
        }
        if (t instanceof ROBNObject) {
            ROBN.mapToROBN(((ROBNObject)t).toROBNMap(), buf);
            return;
        }
        throw new IllegalArgumentException("Unknown object type");
    }

    private static Object fromROBN(Iterator<Byte> iterator) {
        if (iterator.hasNext()) {
            return ROBN.fromROBN(iterator, Type.fromID(iterator.next()));
        }
        throw new IllegalArgumentException("Malformed Binary");
    }

    private static Object fromROBN(Iterator<Byte> iterator, Type type) {
        switch (type) {
            case String: {
                return ROBN.stringFromROBN(iterator);
            }
            case Bool: 
            case Int8: 
            case uInt8: 
            case Int16: 
            case uInt16: 
            case Int32: 
            case uInt32: 
            case Float: 
            case Int64: 
            case uInt64: 
            case Double: 
            case Int128: 
            case uInt128: 
            case BigInt: 
            case LongDouble: 
            case BigFloat: {
                return ROBN.primitiveFromROBN(iterator, type);
            }
            case Vector: {
                return ROBN.vectorFromROBN(iterator);
            }
            case Map: {
                return ROBN.mapFromROBN(iterator);
            }
            case Pair: {
                return ROBN.pairFromROBN(iterator);
            }
            case Undefined: {
                throw new IllegalArgumentException("Malformed Binary");
            }
        }
        throw new IllegalArgumentException("Incompatible Binary");
    }

    private static void numberToROBN(Number number, ArrayList<Byte> buf) {
        if (number instanceof Byte) {
            buf.add(Type.Int8.val);
            buf.add(number.byteValue());
            return;
        }
        if (number instanceof Short) {
            short val = number.shortValue();
            buf.add((byte)(Type.Int16.val | Endianness.NATIVE.val));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 1 : 0) & 0xFF));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 0 : 1) & 0xFF));
            return;
        }
        if (number instanceof Integer) {
            int val = number.intValue();
            buf.add((byte)(Type.Int32.val | Endianness.NATIVE.val));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 3 : 0) & 0xFF));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 2 : 1) & 0xFF));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 1 : 2) & 0xFF));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 0 : 3) & 0xFF));
            return;
        }
        if (number instanceof Long) {
            long val = number.longValue();
            buf.add((byte)(Type.Int64.val | Endianness.NATIVE.val));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 7 : 0) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 6 : 1) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 5 : 2) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 4 : 3) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 3 : 4) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 2 : 5) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 1 : 6) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 0 : 7) & 0xFFL));
            return;
        }
        if (number instanceof Float) {
            int val = Float.floatToIntBits(number.floatValue());
            buf.add((byte)(Type.Float.val | Endianness.NATIVE.val));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 3 : 0) & 0xFF));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 2 : 1) & 0xFF));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 1 : 2) & 0xFF));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 0 : 3) & 0xFF));
            return;
        }
        if (number instanceof Double) {
            long val = Double.doubleToLongBits(number.doubleValue());
            buf.add((byte)(Type.Double.val | Endianness.NATIVE.val));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 7 : 0) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 6 : 1) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 5 : 2) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 4 : 3) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 3 : 4) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 2 : 5) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 1 : 6) & 0xFFL));
            buf.add((byte)(val >> 8 * (Endianness.NATIVE.val == Endianness.BIG.val ? 0 : 7) & 0xFFL));
            return;
        }
        if (number instanceof BigDecimal || number instanceof BigInteger) {
            // empty if block
        }
        throw new IllegalArgumentException("Unsupported number type");
    }

    private static Object primitiveFromROBN(Iterator<Byte> iterator, Type type) {
        switch (type) {
            case Bool: {
                if (!iterator.hasNext()) break;
                return iterator.next() != 0;
            }
            case Int8: {
                if (!iterator.hasNext()) break;
                return iterator.next();
            }
            case Int16: {
                short val = 0;
                for (int i = 0; i < 2 && iterator.hasNext(); ++i) {
                    val = (short)(val | ((short)iterator.next().byteValue() & 0xFF) << 8 * i);
                }
                if (Endianness.NATIVE.val == Endianness.BIG.val) {
                    val = Short.reverseBytes(val);
                }
                return val;
            }
            case Int32: {
                int val = 0;
                for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
                    val |= (iterator.next() & 0xFF) << 8 * i;
                }
                if (Endianness.NATIVE.val == Endianness.BIG.val) {
                    val = Integer.reverseBytes(val);
                }
                return val;
            }
            case Int64: {
                long val = 0L;
                for (int i = 0; i < 8 && iterator.hasNext(); ++i) {
                    val |= ((long)iterator.next().byteValue() & 0xFFL) << 8 * i;
                }
                if (Endianness.NATIVE.val == Endianness.BIG.val) {
                    val = Long.reverseBytes(val);
                }
                return val;
            }
            case uInt8: {
                return (Byte)ROBN.primitiveFromROBN(iterator, Type.Int8) & 0x7F;
            }
            case uInt16: {
                return (Short)ROBN.primitiveFromROBN(iterator, Type.Int16) & Short.MAX_VALUE;
            }
            case uInt32: {
                return (Integer)ROBN.primitiveFromROBN(iterator, Type.Int32) & Integer.MAX_VALUE;
            }
            case uInt64: {
                return (Long)ROBN.primitiveFromROBN(iterator, Type.Int64) & Long.MAX_VALUE;
            }
            case Int128: 
            case uInt128: {
                throw new IllegalArgumentException("Incompatible Binary");
            }
            case Float: {
                return Float.valueOf(Float.intBitsToFloat((Integer)ROBN.primitiveFromROBN(iterator, Type.Int32)));
            }
            case Double: {
                return Double.longBitsToDouble((Long)ROBN.primitiveFromROBN(iterator, Type.Int64));
            }
        }
        throw new IllegalArgumentException("Malformed Binary");
    }

    private static void vectorToROBN(Collection<?> collection, ArrayList<Byte> buf) {
        ROBN.requestBytes(buf, 11);
        int elementCount = collection.size();
        buf.add(Type.Vector.val);
        ROBN.toROBN(elementCount, buf);
        Type elementType = Type.Undefined;
        Iterator<?> iterator = collection.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            elementType = Type.typeID(o.getClass());
        }
        buf.add((byte)(elementType.val | Endianness.NATIVE.val));
        if (Type.primitiveTypeSize(elementType) != 0) {
            ROBN.requestBytes(buf, Type.primitiveTypeSize(elementType) * elementCount);
        }
        ArrayList<Byte> tmpBuffer = new ArrayList<Byte>();
        for (Object o : collection) {
            tmpBuffer.clear();
            ROBN.toROBN(o, tmpBuffer);
            ROBN.requestBytes(buf, tmpBuffer.size() - 1);
            for (int i = 1; i < tmpBuffer.size(); ++i) {
                buf.add(tmpBuffer.get(i));
            }
        }
    }

    private static Object vectorFromROBN(Iterator<Byte> iterator) {
        Object vectorLengthObj = ROBN.fromROBN(iterator);
        if (!(vectorLengthObj instanceof Number)) {
            throw new IllegalArgumentException("Malformed Binary");
        }
        long vectorLength = ((Number)vectorLengthObj).longValue();
        if (vectorLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Incompatible Binary");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.ensureCapacity((int)vectorLength);
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Malformed Binary");
        }
        Type elementType = Type.fromID(iterator.next());
        for (long i = 0L; i < vectorLength; ++i) {
            arrayList.add(ROBN.fromROBN(iterator, elementType));
        }
        return arrayList;
    }

    private static void mapToROBN(Map<?, ?> map, ArrayList<Byte> buf) {
        buf.add(Type.Map.val);
        ROBN.toROBN(map.size(), buf);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            buf.add(Type.Pair.val);
            buf.addAll(ROBN.toROBN(entry.getKey()));
            buf.addAll(ROBN.toROBN(entry.getValue()));
        }
    }

    private static Object mapFromROBN(Iterator<Byte> iterator) {
        Object mapLengthOBJ = ROBN.fromROBN(iterator);
        if (!(mapLengthOBJ instanceof Number)) {
            throw new IllegalArgumentException("Malformed Binary");
        }
        long mapLength = ((Number)mapLengthOBJ).longValue();
        if (mapLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Incompatible Binary");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int i = 0;
        while ((long)i < mapLength) {
            if (!iterator.hasNext() || iterator.next() != Type.Pair.val) {
                throw new IllegalArgumentException("Malformed Binary");
            }
            Object key = ROBN.fromROBN(iterator);
            Object value = ROBN.fromROBN(iterator);
            map.put(key, value);
            ++i;
        }
        return map;
    }

    private static void pairToROBN(Pair<?, ?> pair, ArrayList<Byte> buf) {
        buf.add(Type.Pair.val);
        buf.addAll(ROBN.toROBN(pair.getFirst()));
        buf.addAll(ROBN.toROBN(pair.getSecond()));
    }

    private static Object pairFromROBN(Iterator<Byte> iterator) {
        Object first = ROBN.fromROBN(iterator);
        Object second = ROBN.fromROBN(iterator);
        return new Pair(first, second);
    }

    private static void stringToROBN(String str, ArrayList<Byte> buf) {
        buf.ensureCapacity(buf.size() + str.length() + 2);
        buf.add(Type.String.val);
        for (int i = 0; i < str.length(); ++i) {
            buf.add((byte)str.charAt(i));
        }
        buf.add((byte)0);
    }

    private static Object stringFromROBN(Iterator<Byte> iterator) {
        StringBuilder builder = new StringBuilder();
        while (true) {
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("Malformed Binary");
            }
            byte next = iterator.next();
            if (next == 0) break;
            builder.append((char)next);
        }
        return builder.toString();
    }

    public static enum Endianness {
        LITTLE(0),
        BIG(128),
        NATIVE(ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? Endianness.BIG.val : Endianness.LITTLE.val);

        public final byte val;

        private Endianness(int i) {
            this.val = (byte)i;
        }

        public static Endianness fromByte(byte b) {
            if ((b & 0x80) != 0) {
                return BIG;
            }
            return LITTLE;
        }
    }

    public static enum Type {
        Undefined(0),
        String(1),
        Bool(2),
        Int8(4),
        Int16(5),
        Int32(6),
        Int64(7),
        Int128(18),
        BigInt(21),
        uInt8(8),
        uInt16(9),
        uInt32(10),
        uInt64(11),
        uInt128(19),
        Float(12),
        Double(13),
        LongDouble(20),
        BigFloat(22),
        Vector(15),
        Pair(16),
        Map(17);

        public final byte val;
        private static final HashMap<Byte, Type> idLookup;

        private Type(int i) {
            this.val = (byte)i;
        }

        public static <T> Type typeID(Class<T> tClass) {
            if (tClass == String.class) {
                return String;
            }
            if (tClass == Boolean.TYPE || tClass == Boolean.class) {
                return Bool;
            }
            if (tClass == Byte.TYPE || tClass == Byte.class) {
                return Int8;
            }
            if (tClass == Short.TYPE || tClass == Short.class) {
                return Int16;
            }
            if (tClass == Integer.TYPE || tClass == Integer.class) {
                return Int32;
            }
            if (tClass == Long.TYPE || tClass == Long.class) {
                return Int64;
            }
            if (tClass == BigDecimal.class) {
                return BigFloat;
            }
            if (tClass == BigInteger.class) {
                return BigInt;
            }
            if (tClass == java.lang.Float.TYPE || tClass == Float.class) {
                return Float;
            }
            if (tClass == java.lang.Double.TYPE || tClass == Double.class) {
                return Double;
            }
            if (Collection.class.isAssignableFrom(tClass)) {
                return Vector;
            }
            if (Map.class.isAssignableFrom(tClass) || ROBNObject.class.isAssignableFrom(tClass)) {
                return Map;
            }
            return Undefined;
        }

        static int primitiveTypeSize(Type type) {
            switch (type) {
                default: {
                    return 0;
                }
                case Bool: 
                case Int8: 
                case uInt8: {
                    return 1;
                }
                case Int16: 
                case uInt16: {
                    return 2;
                }
                case Int32: 
                case uInt32: 
                case Float: {
                    return 4;
                }
                case Int64: 
                case uInt64: 
                case Double: {
                    return 8;
                }
                case Int128: 
                case uInt128: 
            }
            return 16;
        }

        public static Type fromID(byte id) {
            id = (byte)(id & 0x7F);
            return idLookup.get(id);
        }

        static {
            idLookup = new HashMap();
            idLookup.put(Type.Undefined.val, Undefined);
            idLookup.put(Type.String.val, String);
            idLookup.put(Type.Bool.val, Bool);
            idLookup.put(Type.Int8.val, Int8);
            idLookup.put(Type.Int16.val, Int16);
            idLookup.put(Type.Int32.val, Int32);
            idLookup.put(Type.Int64.val, Int64);
            idLookup.put(Type.Int128.val, Int128);
            idLookup.put(Type.BigInt.val, BigInt);
            idLookup.put(Type.uInt8.val, uInt8);
            idLookup.put(Type.uInt16.val, uInt16);
            idLookup.put(Type.uInt32.val, uInt32);
            idLookup.put(Type.uInt64.val, uInt64);
            idLookup.put(Type.uInt128.val, uInt128);
            idLookup.put(Type.Float.val, Float);
            idLookup.put(Type.Double.val, Double);
            idLookup.put(Type.LongDouble.val, LongDouble);
            idLookup.put(Type.BigFloat.val, BigFloat);
            idLookup.put(Type.Vector.val, Vector);
            idLookup.put(Type.Pair.val, Pair);
            idLookup.put(Type.Map.val, Map);
        }
    }
}

