/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.generic;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.multiblock.generic.IAssemblyAttemptedTile;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.ITickableMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.generic.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.generic.Validator;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.AStarList;
import net.roguelogix.phosphophyllite.util.TileMap;
import net.roguelogix.phosphophyllite.util.Util;

public class MultiblockController<ControllerType extends MultiblockController<ControllerType, TileType, BlockType>, TileType extends MultiblockTile<ControllerType, TileType, BlockType>, BlockType extends MultiblockBlock<ControllerType, TileType, BlockType>> {
    protected final World world;
    private boolean hasSaveDelegate = false;
    protected final TileMap<TileType> blocks = new TileMap();
    protected final Set<ITickableMultiblockTile> toTick = new LinkedHashSet<ITickableMultiblockTile>();
    protected final Set<IAssemblyAttemptedTile> assemblyAttemptedTiles = new LinkedHashSet<IAssemblyAttemptedTile>();
    protected final Set<IOnAssemblyTile> onAssemblyTiles = new LinkedHashSet<IOnAssemblyTile>();
    protected final Set<IOnDisassemblyTile> onDisassemblyTiles = new LinkedHashSet<IOnDisassemblyTile>();
    private boolean checkForDetachments = false;
    private boolean updateExtremes = true;
    private long updateAssemblyAtTick = Long.MAX_VALUE;
    protected final Set<ControllerType> controllersToMerge = new LinkedHashSet<ControllerType>();
    protected final List<BlockPos> removedBlocks = new LinkedList<BlockPos>();
    private final Vector3i minCoord = new Vector3i();
    private final Vector3i maxCoord = new Vector3i();
    private final Vector3i minExtremeBlocks = new Vector3i();
    private final Vector3i maxExtremeBlocks = new Vector3i();
    protected AssemblyState state = AssemblyState.DISASSEMBLED;
    private boolean shouldUpdateNBT = false;
    private CompoundNBT cachedNBT = null;
    protected final Validator<MultiblockTile<?, ?, ?>> tileTypeValidator;
    protected final Validator<MultiblockBlock<?, ?, ?>> blockTypeValidator;
    private Validator<ControllerType> assemblyValidator = c -> true;
    protected ValidationError lastValidationError = null;
    long lastTick = -1L;

    public MultiblockController(@Nonnull World world, @Nonnull Validator<MultiblockTile<?, ?, ?>> tileTypeValidator, @Nonnull Validator<MultiblockBlock<?, ?, ?>> blockTypeValidator) {
        this.tileTypeValidator = tileTypeValidator;
        this.blockTypeValidator = blockTypeValidator;
        this.world = world;
        Phosphophyllite.addController(this);
    }

    ControllerType self() {
        return (ControllerType)this;
    }

    public World getWorld() {
        return this.world;
    }

    public Vector3ic minCoord() {
        return this.minCoord;
    }

    public Vector3ic maxCoord() {
        return this.maxCoord;
    }

    @Nullable
    public TileType getTile(Vector3i position) {
        return (TileType)((Object)((MultiblockTile)((Object)this.blocks.getTile(position))));
    }

    @Nullable
    public TileType getTile(BlockPos position) {
        return (TileType)((Object)((MultiblockTile)((Object)this.blocks.getTile(position))));
    }

    public boolean containsTile(TileType tile) {
        return this.blocks.containsTile(tile);
    }

    private void updateMinMaxCoordinates() {
        if (this.blocks.isEmpty() || !this.updateExtremes) {
            return;
        }
        this.updateExtremes = false;
        this.minCoord.set(Integer.MAX_VALUE);
        this.maxCoord.set(Integer.MIN_VALUE);
        this.blocks.forEachPos(pos -> {
            if (pos.func_177958_n() < this.minCoord.x) {
                this.minCoord.x = pos.func_177958_n();
                this.minExtremeBlocks.x = 1;
            } else if (pos.func_177958_n() == this.minCoord.x) {
                ++this.minExtremeBlocks.x;
            }
            if (pos.func_177956_o() < this.minCoord.y) {
                this.minCoord.y = pos.func_177956_o();
                this.minExtremeBlocks.y = 1;
            } else if (pos.func_177956_o() == this.minCoord.y) {
                ++this.minExtremeBlocks.y;
            }
            if (pos.func_177952_p() < this.minCoord.z) {
                this.minCoord.z = pos.func_177952_p();
                this.minExtremeBlocks.z = 1;
            } else if (pos.func_177952_p() == this.minCoord.z) {
                ++this.minExtremeBlocks.z;
            }
            if (pos.func_177958_n() > this.maxCoord.x) {
                this.maxCoord.x = pos.func_177958_n();
                this.maxExtremeBlocks.x = 1;
            } else if (pos.func_177958_n() == this.maxCoord.x) {
                ++this.maxExtremeBlocks.x;
            }
            if (pos.func_177956_o() > this.maxCoord.y) {
                this.maxCoord.y = pos.func_177956_o();
                this.maxExtremeBlocks.y = 1;
            } else if (pos.func_177956_o() == this.maxCoord.y) {
                ++this.maxExtremeBlocks.y;
            }
            if (pos.func_177952_p() > this.maxCoord.z) {
                this.maxCoord.z = pos.func_177952_p();
                this.maxExtremeBlocks.z = 1;
            } else if (pos.func_177952_p() == this.maxCoord.z) {
                ++this.maxExtremeBlocks.z;
            }
        });
    }

    final void attemptAttach(@Nonnull MultiblockTile<?, ?, ?> toAttachGeneric) {
        MultiblockTile<?, ?, ?> toAttach;
        if (!this.tileTypeValidator.validate(toAttachGeneric)) {
            return;
        }
        try {
            toAttach = toAttachGeneric;
        }
        catch (ClassCastException ignored) {
            Phosphophyllite.LOGGER.error("Tile type validator implemented wrong! Cleared tile that couldn't be cast. " + ((Object)toAttachGeneric).getClass().toGenericString());
            return;
        }
        if (toAttach.controller != null && toAttach.controller != this) {
            if (((MultiblockController)toAttach.controller).blocks.size() > this.blocks.size()) {
                ((MultiblockController)toAttach.controller).controllersToMerge.add(this.self());
            } else {
                this.controllersToMerge.add(toAttach.controller);
            }
            return;
        }
        if (toAttach.controller == this) {
            return;
        }
        this.blocks.addTile(toAttach);
        BlockPos toAttachPos = toAttach.func_174877_v();
        if (toAttachPos.func_177958_n() < this.minCoord.x) {
            this.minCoord.x = toAttachPos.func_177958_n();
            this.minExtremeBlocks.x = 1;
        } else if (toAttachPos.func_177958_n() == this.minCoord.x) {
            ++this.minExtremeBlocks.x;
        }
        if (toAttachPos.func_177956_o() < this.minCoord.y) {
            this.minCoord.y = toAttachPos.func_177956_o();
            this.minExtremeBlocks.y = 1;
        } else if (toAttachPos.func_177956_o() == this.minCoord.y) {
            ++this.minExtremeBlocks.y;
        }
        if (toAttachPos.func_177952_p() < this.minCoord.z) {
            this.minCoord.z = toAttachPos.func_177952_p();
            this.minExtremeBlocks.z = 1;
        } else if (toAttachPos.func_177952_p() == this.minCoord.z) {
            ++this.minExtremeBlocks.z;
        }
        if (toAttachPos.func_177958_n() > this.maxCoord.x) {
            this.maxCoord.x = toAttachPos.func_177958_n();
            this.maxExtremeBlocks.x = 1;
        } else if (toAttachPos.func_177958_n() == this.maxCoord.x) {
            ++this.maxExtremeBlocks.x;
        }
        if (toAttachPos.func_177956_o() > this.maxCoord.y) {
            this.maxCoord.y = toAttachPos.func_177956_o();
            this.maxExtremeBlocks.y = 1;
        } else if (toAttachPos.func_177956_o() == this.maxCoord.y) {
            ++this.maxExtremeBlocks.y;
        }
        if (toAttachPos.func_177952_p() > this.maxCoord.z) {
            this.maxCoord.z = toAttachPos.func_177952_p();
            this.maxExtremeBlocks.z = 1;
        } else if (toAttachPos.func_177952_p() == this.maxCoord.z) {
            ++this.maxExtremeBlocks.z;
        }
        if (toAttach instanceof ITickableMultiblockTile) {
            this.toTick.add((ITickableMultiblockTile)((Object)toAttach));
        }
        if (toAttach instanceof IAssemblyAttemptedTile) {
            this.assemblyAttemptedTiles.add((IAssemblyAttemptedTile)((Object)toAttach));
        }
        if (toAttach instanceof IOnAssemblyTile) {
            this.onAssemblyTiles.add((IOnAssemblyTile)((Object)toAttach));
        }
        if (toAttach instanceof IOnDisassemblyTile) {
            this.onDisassemblyTiles.add((IOnDisassemblyTile)((Object)toAttach));
        }
        if (toAttach.isSaveDelegate) {
            if (this.hasSaveDelegate) {
                toAttach.isSaveDelegate = false;
            } else {
                this.hasSaveDelegate = true;
            }
        }
        toAttach.controller = this.self();
        if (toAttach.preExistingBlock) {
            if (toAttach.controllerData != null) {
                this.onBlockWithNBTAttached(toAttach.controllerData);
                toAttach.controllerData = null;
            }
            this.onPartAttached((TileType)((Object)toAttach));
        } else {
            this.onPartPlaced((TileType)((Object)toAttach));
        }
        this.updateAssemblyAtTick = Phosphophyllite.tickNumber() + 1L;
    }

    final void detach(@Nonnull TileType toDetach) {
        this.detach(toDetach, false);
    }

    final void detach(@Nonnull TileType toDetach, boolean onChunkUnload) {
        this.detach(toDetach, onChunkUnload, true);
    }

    final void detach(@Nonnull TileType toDetach, boolean onChunkUnload, boolean checkForDetachments) {
        BlockPos toDetachPos;
        this.blocks.removeTile(toDetach);
        if (toDetach instanceof ITickableMultiblockTile) {
            this.toTick.remove(toDetach);
        }
        if (toDetach instanceof IAssemblyAttemptedTile) {
            this.assemblyAttemptedTiles.remove(toDetach);
        }
        if (toDetach instanceof IOnAssemblyTile) {
            this.onAssemblyTiles.remove(toDetach);
        }
        if (toDetach instanceof IOnDisassemblyTile) {
            this.onDisassemblyTiles.remove(toDetach);
        }
        if (onChunkUnload) {
            this.onPartDetached(toDetach);
            this.state = AssemblyState.PAUSED;
        } else {
            this.onPartBroken(toDetach);
            ((MultiblockTile)((Object)toDetach)).attemptAttach();
        }
        if (((MultiblockTile)((Object)toDetach)).isSaveDelegate) {
            this.hasSaveDelegate = false;
        }
        if (this.blocks.isEmpty()) {
            Phosphophyllite.removeController(this);
        }
        boolean bl = this.checkForDetachments = this.checkForDetachments || checkForDetachments;
        if (checkForDetachments) {
            this.removedBlocks.add(toDetach.func_174877_v());
        }
        if ((toDetachPos = toDetach.func_174877_v()).func_177958_n() == this.minCoord.x) {
            --this.minExtremeBlocks.x;
            if (this.minExtremeBlocks.x == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.func_177956_o() == this.minCoord.y) {
            --this.minExtremeBlocks.y;
            if (this.minExtremeBlocks.y == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.func_177952_p() == this.minCoord.z) {
            --this.minExtremeBlocks.z;
            if (this.minExtremeBlocks.z == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.func_177958_n() == this.maxCoord.x) {
            --this.maxExtremeBlocks.x;
            if (this.maxExtremeBlocks.x == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.func_177956_o() == this.maxCoord.y) {
            --this.maxExtremeBlocks.y;
            if (this.maxExtremeBlocks.y == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.func_177952_p() == this.maxCoord.z) {
            --this.maxExtremeBlocks.z;
            if (this.maxExtremeBlocks.z == 0) {
                this.updateExtremes = true;
            }
        }
        this.updateAssemblyAtTick = Phosphophyllite.tickNumber() + 1L;
    }

    public final void update() {
        if (this.lastTick >= Phosphophyllite.tickNumber()) {
            return;
        }
        this.lastTick = Phosphophyllite.tickNumber();
        if (this.blocks.isEmpty()) {
            Phosphophyllite.removeController(this);
            this.checkForDetachments = false;
        }
        if (this.checkForDetachments) {
            BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
            AStarList aStarList = new AStarList();
            for (BlockPos removedBlock : this.removedBlocks) {
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                for (int i = 0; i < n; ++i) {
                    Direction value = directionArray[i];
                    mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)removedBlock);
                    mutableBlockPos.func_189536_c(value);
                    MultiblockTile tile2 = (MultiblockTile)((Object)this.blocks.getTile((BlockPos)mutableBlockPos));
                    if (tile2 == null || tile2.controller != this) continue;
                    aStarList.addTarget(tile2.func_174877_v());
                }
            }
            this.removedBlocks.clear();
            while (!aStarList.done()) {
                BlockPos node = aStarList.nextNode();
                for (Direction value : Direction.values()) {
                    mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)node);
                    mutableBlockPos.func_189536_c(value);
                    MultiblockTile tile3 = (MultiblockTile)((Object)this.blocks.getTile((BlockPos)mutableBlockPos));
                    if (tile3 == null || tile3.controller != this || tile3.lastSavedTick == this.lastTick) continue;
                    tile3.lastSavedTick = this.lastTick;
                    aStarList.addNode(tile3.func_174877_v());
                }
            }
            if (!aStarList.foundAll()) {
                LinkedHashSet toOrphan = new LinkedHashSet();
                this.blocks.forEachTile(tile -> {
                    if (tile.lastSavedTick != this.lastTick) {
                        toOrphan.add(tile);
                    }
                });
                if (!toOrphan.isEmpty()) {
                    for (MultiblockTile tile4 : toOrphan) {
                        this.detach(tile4, this.state == AssemblyState.PAUSED, false);
                    }
                    this.updateAssemblyAtTick = Long.MIN_VALUE;
                }
            }
            this.checkForDetachments = false;
        }
        if (!this.controllersToMerge.isEmpty()) {
            HashSet<ControllerType> newToMerge = new HashSet<ControllerType>();
            for (MultiblockController otherController : this.controllersToMerge) {
                Phosphophyllite.removeController(otherController);
                otherController.controllersToMerge.remove(this.self());
                newToMerge.addAll(otherController.controllersToMerge);
                otherController.controllersToMerge.clear();
                this.onMerge(otherController);
                otherController.blocks.forEachTile(tile -> {
                    tile.controller = null;
                    tile.preExistingBlock = false;
                    this.attemptAttach((MultiblockTile<?, ?, ?>)((Object)tile));
                });
            }
            this.updateExtremes = true;
            this.updateAssemblyAtTick = Long.MIN_VALUE;
            this.controllersToMerge.clear();
            this.controllersToMerge.addAll(newToMerge);
        }
        if (this.updateAssemblyAtTick < this.lastTick) {
            this.updateMinMaxCoordinates();
            this.updateAssemblyState();
            this.updateAssemblyAtTick = Long.MAX_VALUE;
        }
        if (this.state == AssemblyState.ASSEMBLED) {
            this.tick();
            this.toTick.forEach(ITickableMultiblockTile::tick);
        } else if (this.state == AssemblyState.DISASSEMBLED) {
            this.disassembledTick();
        }
    }

    public void suicide() {
        TileMap<TileType> blocks = new TileMap<TileType>();
        blocks.addAll(this.blocks);
        blocks.forEachTile(MultiblockTile::onChunkUnloaded);
        Phosphophyllite.removeController(this);
    }

    private void updateAssemblyState() {
        AssemblyState oldState = this.state;
        boolean validated = false;
        this.lastValidationError = null;
        try {
            validated = this.assemblyValidator.validate(this.self());
        }
        catch (ValidationError e) {
            this.lastValidationError = e;
        }
        if (validated) {
            this.state = AssemblyState.ASSEMBLED;
            if (this.cachedNBT != null) {
                this.read(this.cachedNBT.func_74775_l("userdata"));
                this.shouldUpdateNBT = true;
            }
            if (oldState == AssemblyState.PAUSED) {
                this.onUnpaused();
            } else {
                this.onAssembled();
            }
            this.assembledBlockStates();
            this.onAssemblyTiles.forEach(IOnAssemblyTile::onAssembly);
            if (!this.hasSaveDelegate) {
                MultiblockTile tile = (MultiblockTile)((Object)this.blocks.getOne());
                assert (tile != null);
                tile.isSaveDelegate = true;
                this.hasSaveDelegate = true;
            }
        } else if (oldState == AssemblyState.ASSEMBLED) {
            this.state = AssemblyState.DISASSEMBLED;
            this.onDisassembled();
            this.disassembledBlockStates();
            this.updateCachedNBT();
            this.onDisassemblyTiles.forEach(IOnDisassemblyTile::onDisassembly);
        }
        for (IAssemblyAttemptedTile assemblyAttemptedTile : this.assemblyAttemptedTiles) {
            assemblyAttemptedTile.onAssemblyAttempted();
        }
    }

    private void onBlockWithNBTAttached(CompoundNBT nbt) {
        if (this.cachedNBT == null) {
            this.readNBT(nbt);
        }
    }

    private void assembledBlockStates() {
        LinkedHashMap<BlockPos, BlockState> newStates = new LinkedHashMap<BlockPos, BlockState>();
        this.blocks.forEach((pos, tile) -> {
            BlockState state = tile.assembledBlockState();
            if (state != tile.func_195044_w()) {
                newStates.put((BlockPos)pos, state);
                tile.func_145836_u();
            }
        });
        Util.setBlockStates(newStates, this.world);
    }

    private void disassembledBlockStates() {
        LinkedHashMap<BlockPos, BlockState> newStates = new LinkedHashMap<BlockPos, BlockState>();
        this.blocks.forEach((pos, tile) -> {
            BlockState state = tile.disassembledBlockState();
            if (state != tile.func_195044_w()) {
                newStates.put(tile.func_174877_v(), state);
                tile.func_145836_u();
            }
        });
        Util.setBlockStates(newStates, this.world);
    }

    final void readNBT(CompoundNBT nbt) {
        if (!nbt.isEmpty()) {
            this.cachedNBT = nbt.func_74737_b();
            CompoundNBT multiblockData = this.cachedNBT.func_74775_l("multiblockData");
            if (multiblockData.func_74764_b("assemblyState")) {
                AssemblyState nbtState = AssemblyState.valueOf(multiblockData.func_74779_i("assemblyState"));
                if (this.state == AssemblyState.DISASSEMBLED && (nbtState == AssemblyState.PAUSED || nbtState == AssemblyState.ASSEMBLED)) {
                    this.state = AssemblyState.PAUSED;
                }
            }
        }
    }

    @Nonnull
    final CompoundNBT getNBT() {
        if (this.shouldUpdateNBT) {
            this.shouldUpdateNBT = false;
            this.updateCachedNBT();
        }
        return this.cachedNBT == null ? new CompoundNBT() : this.cachedNBT;
    }

    private void updateCachedNBT() {
        this.cachedNBT = new CompoundNBT();
        this.cachedNBT.func_218657_a("userdata", (INBT)this.write());
        CompoundNBT multiblockData = new CompoundNBT();
        this.cachedNBT.func_218657_a("multiblockData", (INBT)multiblockData);
        multiblockData.func_74768_a("controller", this.hashCode());
        multiblockData.func_74778_a("assemblyState", this.state.toString());
    }

    protected final void markDirty() {
        this.shouldUpdateNBT = true;
        Util.markRangeDirty(this.world, new Vector2i(this.minCoord.x, this.minCoord.z), new Vector2i(this.maxCoord.x, this.maxCoord.z));
    }

    @Nonnull
    public AssemblyState assemblyState() {
        return this.state;
    }

    @Nonnull
    public String getDebugInfo() {
        return "BlockCount: " + this.blocks.size() + "\nMin " + this.minCoord.toString() + "\nMax " + this.maxCoord.toString() + "\nController: " + this + "\nLast Error: " + (this.lastValidationError == null ? "N/A" : this.lastValidationError.getTextComponent().getString()) + "\nAssemblyState: " + (Object)((Object)this.state) + "\n";
    }

    protected void setAssemblyValidator(@Nullable Validator<ControllerType> validator) {
        if (validator != null) {
            this.assemblyValidator = validator;
        }
    }

    public void tick() {
    }

    public void disassembledTick() {
    }

    protected void onPartAttached(@Nonnull TileType toAttach) {
    }

    protected void onPartDetached(@Nonnull TileType toDetach) {
    }

    protected void onPartPlaced(@Nonnull TileType placed) {
    }

    protected void onPartBroken(@Nonnull TileType broken) {
    }

    protected void onMerge(@Nonnull ControllerType otherController) {
    }

    protected void onAssembled() {
    }

    protected void onDisassembled() {
    }

    protected void onUnpaused() {
    }

    protected void read(@Nonnull CompoundNBT compound) {
    }

    @Nonnull
    protected CompoundNBT write() {
        return new CompoundNBT();
    }

    public static enum AssemblyState {
        ASSEMBLED,
        DISASSEMBLED,
        PAUSED;

    }
}

