/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.util.compat.jei.color_pallet;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mowmaster.pedestals.crafting.CalculateColor;
import com.mowmaster.pedestals.item.ItemColorPallet;
import com.mowmaster.pedestals.item.ItemLinkingTool;
import com.mowmaster.pedestals.recipes.ColoredPedestalRecipe;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ColorPalletRecipeCategory
implements IRecipeCategory<ColoredPedestalRecipe> {
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon;
    public static final ResourceLocation PALLET_TEXTURE = new ResourceLocation("pedestals:textures/gui/jei/coloredpallet.png");
    public static final ResourceLocation UID = new ResourceLocation("pedestals", "coloredpallets");

    public ColorPalletRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ItemLinkingTool.DEFAULT.getItem()));
        this.background = guiHelper.createDrawable(PALLET_TEXTURE, 0, 0, 119, 78);
        this.localizedName = I18n.func_135052_a((String)"pedestals.recipe_category_coloredpallets", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("pedestals", "coloredpallets");
    }

    public Class<? extends ColoredPedestalRecipe> getRecipeClass() {
        return ColoredPedestalRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ColoredPedestalRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.getIngredient()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ColoredPedestalRecipe recipe, IIngredients ingredients) {
        ItemStack gDye;
        ItemStack rDye;
        int r = (CalculateColor.getRGBColorFromInt(recipe.getColor())[0] + 1) / 64;
        int g = (CalculateColor.getRGBColorFromInt(recipe.getColor())[1] + 1) / 64;
        int b = (CalculateColor.getRGBColorFromInt(recipe.getColor())[2] + 1) / 64;
        ItemStack itemStack = r > 0 ? (r == 4 ? new ItemStack((IItemProvider)Items.field_222078_li, r - 1) : new ItemStack((IItemProvider)Items.field_222078_li, r)) : (rDye = ItemStack.field_190927_a);
        ItemStack itemStack2 = g > 0 ? (g == 4 ? new ItemStack((IItemProvider)Items.field_222079_lj, g - 1) : new ItemStack((IItemProvider)Items.field_222079_lj, g)) : (gDye = ItemStack.field_190927_a);
        ItemStack bDye = b > 0 ? (b == 4 ? new ItemStack((IItemProvider)Items.field_222083_lx, b - 1) : new ItemStack((IItemProvider)Items.field_222083_lx, b)) : ItemStack.field_190927_a;
        recipeLayout.getItemStacks().init(0, true, 9, 9);
        if (rDye.func_190916_E() > 0) {
            recipeLayout.getItemStacks().set(0, rDye);
        }
        recipeLayout.getItemStacks().init(1, true, 9, 30);
        if (gDye.func_190916_E() > 0) {
            recipeLayout.getItemStacks().set(1, gDye);
        }
        recipeLayout.getItemStacks().init(2, true, 9, 51);
        if (bDye.func_190916_E() > 0) {
            recipeLayout.getItemStacks().set(2, bDye);
        }
        recipeLayout.getItemStacks().init(3, true, 46, 30);
        ItemStack palletDefault = new ItemStack((IItemProvider)ItemColorPallet.COLORPALLET_DEFAULT);
        recipeLayout.getItemStacks().set(3, palletDefault);
        recipeLayout.getItemStacks().init(4, true, 92, 30);
        int color = recipe.getColor();
        ItemStack pallet = new ItemStack((IItemProvider)ItemColorPallet.COLORPALLET);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("color", color);
        pallet.func_77982_d(nbt);
        recipeLayout.getItemStacks().set(4, pallet);
    }

    public void draw(ColoredPedestalRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.icon.draw(matrixStack, 69, 8);
    }
}

