/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseMachine;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.recipes.SmeltingRecipeAdvanced;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeFurnace
extends ItemUpgradeBaseMachine {
    public static final Item SMELTER = (Item)new ItemUpgradeFurnace(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/smelter"));

    public ItemUpgradeFurnace(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Nullable
    protected SmeltingRecipeAdvanced getRecipeAdvanced(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return world == null ? null : (SmeltingRecipeAdvanced)world.func_199532_z().func_215371_a(SmeltingRecipeAdvanced.recipeType, (IInventory)inv, world).orElse(null);
    }

    protected Collection<ItemStack> getProcessResultsAdvanced(SmeltingRecipeAdvanced recipe) {
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.getResult());
    }

    protected float getProcessResultsXPAdvanced() {
        return 1.0f;
    }

    @Nullable
    protected AbstractCookingRecipe getRecipe(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        if (world == null) {
            return null;
        }
        RecipeManager recipeManager = world.func_199532_z();
        Optional optional = recipeManager.func_215371_a(IRecipeType.field_222151_c, (IInventory)inv, world);
        if (optional.isPresent()) {
            return (AbstractCookingRecipe)optional.get();
        }
        Optional optional2 = recipeManager.func_215371_a(IRecipeType.field_222152_d, (IInventory)inv, world);
        if (optional2.isPresent()) {
            return (AbstractCookingRecipe)optional2.get();
        }
        Optional optional1 = recipeManager.func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, world);
        return optional1.orElse(null);
    }

    protected Collection<ItemStack> getProcessResults(AbstractCookingRecipe recipe, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.func_77572_b((IInventory)inv));
    }

    protected float getProcessResultsXP(AbstractCookingRecipe recipe) {
        return recipe == null ? 0.0f : recipe.func_222138_b();
    }

    protected void spawnXP(World world, BlockPos posOfPedestal, int xp) {
        if (xp >= 1) {
            ExperienceOrbEntity expEntity = new ExperienceOrbEntity(world, (double)this.getPosOfBlockBelow(world, posOfPedestal, -1).func_177958_n() + 0.5, (double)this.getPosOfBlockBelow(world, posOfPedestal, -1).func_177956_o(), (double)this.getPosOfBlockBelow(world, posOfPedestal, -1).func_177952_p() + 0.5, xp);
            expEntity.func_213293_j(0.0, 0.0, 0.0);
            world.func_217376_c((Entity)expEntity);
        }
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            int speed = this.getSmeltingSpeed(coinInPedestal);
            if (world.func_82737_E() % (long)speed == 0L) {
                LazyOptional<IItemHandler> cap;
                int getMaxFuelValue = this.getFuelBuffer(coinInPedestal);
                if (!this.hasMaxFuelSet(coinInPedestal) || this.readMaxFuelFromNBT(coinInPedestal) != getMaxFuelValue) {
                    this.setMaxFuel(coinInPedestal, getMaxFuelValue);
                }
                BlockPos pedestalPos = pedestal.func_174877_v();
                BlockPos posInventory = this.getPosOfBlockBelow(world, pedestalPos, 1);
                boolean isAdvanced = this.hasAdvancedInventoryTargeting(coinInPedestal);
                LazyOptional<IItemHandler> lazyOptional = cap = isAdvanced ? ItemUpgradeFurnace.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, pedestalPos), true) : ItemUpgradeFurnace.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, pedestalPos), true);
                if (this.isInventoryEmpty(cap) || !cap.isPresent()) {
                    return;
                }
                if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                    this.upgradeAction(pedestal, world, pedestalPos, coinInPedestal, cap);
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, BlockPos posOfPedestal, ItemStack coinInPedestal, LazyOptional<IItemHandler> cap) {
        int i;
        boolean isAdvanced = this.hasAdvancedInventoryTargeting(coinInPedestal);
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        int itemsPerSmelt = this.getItemTransferRate(coinInPedestal);
        IItemHandler handler = (IItemHandler)cap.orElse(null);
        TileEntity invToPullFrom = world.func_175625_s(posInventory);
        if (!(isAdvanced && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
            ItemStack itemFromInv = ItemStack.field_190927_a;
        } else if (handler != null && (i = this.getNextSlotWithItemsCapFiltered(pedestal, cap, this.getStackInPedestal(world, posOfPedestal))) >= 0) {
            ItemStack resultSmeltedAdvanced;
            int maxInSlot = handler.getSlotLimit(i);
            ItemStack itemFromInv = handler.getStackInSlot(i);
            float xp = isAdvanced && this.getProcessResultsAdvanced(this.getRecipeAdvanced(world, itemFromInv)).size() > 0 ? this.getProcessResultsXPAdvanced() : this.getProcessResultsXP(this.getRecipe(world, itemFromInv));
            Collection<ItemStack> jsonResults = this.getProcessResults(this.getRecipe(world, itemFromInv), itemFromInv);
            Collection<ItemStack> jsonResultsAdvanced = this.getProcessResultsAdvanced(this.getRecipeAdvanced(world, itemFromInv));
            ItemStack resultSmelted = jsonResults.iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResults.iterator().next();
            ItemStack itemStack = resultSmeltedAdvanced = jsonResultsAdvanced.iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResultsAdvanced.iterator().next();
            if (isAdvanced && !resultSmeltedAdvanced.equals(ItemStack.field_190927_a)) {
                resultSmelted = resultSmeltedAdvanced;
            }
            ItemStack itemFromPedestal = this.getStackInPedestal(world, posOfPedestal);
            if (!resultSmelted.equals(ItemStack.field_190927_a)) {
                if (handler.getStackInSlot(i) != null && !handler.getStackInSlot(i).func_190926_b() && handler.getStackInSlot(i).func_77973_b() != Items.field_190931_a) {
                    int itemInputsPerSmelt;
                    int itemsOutputWhenStackSmelted;
                    int roomLeftInPedestal = 64 - itemFromPedestal.func_190916_E();
                    if (itemFromPedestal.func_190926_b() || itemFromPedestal.equals(ItemStack.field_190927_a)) {
                        roomLeftInPedestal = 64;
                    }
                    if (roomLeftInPedestal < (itemsOutputWhenStackSmelted = (itemInputsPerSmelt = itemsPerSmelt) * resultSmelted.func_190916_E())) {
                        itemInputsPerSmelt = Math.floorDiv(roomLeftInPedestal, resultSmelted.func_190916_E());
                    }
                    if (itemFromInv.func_190916_E() < itemInputsPerSmelt) {
                        itemInputsPerSmelt = itemFromInv.func_190916_E();
                    }
                    itemsOutputWhenStackSmelted = itemInputsPerSmelt * resultSmelted.func_190916_E();
                    ItemStack copyIncoming = resultSmelted.func_77946_l();
                    copyIncoming.func_190920_e(itemsOutputWhenStackSmelted);
                    int fuelToConsume = 200 * itemInputsPerSmelt;
                    TileEntity pedestalInv = world.func_175625_s(posOfPedestal);
                    if (pedestalInv instanceof PedestalTileEntity) {
                        PedestalTileEntity ped = (PedestalTileEntity)pedestalInv;
                        if (this.removeFuel(ped, fuelToConsume, true)) {
                            if (!handler.extractItem(i, itemInputsPerSmelt, true).func_190926_b()) {
                                handler.extractItem(i, itemInputsPerSmelt, false);
                                this.removeFuel(ped, fuelToConsume, false);
                                this.spawnXP(world, posOfPedestal, (int)(xp * (float)itemInputsPerSmelt));
                                if (!ped.hasMuffler()) {
                                    world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                }
                                ped.addItemOverride(copyIncoming);
                            }
                        } else {
                            int fuelLeft = this.getFuelStored(coinInPedestal);
                            if (fuelLeft > 0 && (itemInputsPerSmelt = Math.floorDiv(fuelLeft, 200)) >= 1) {
                                fuelToConsume = 200 * itemInputsPerSmelt;
                                itemsOutputWhenStackSmelted = itemInputsPerSmelt * resultSmelted.func_190916_E();
                                copyIncoming.func_190920_e(itemsOutputWhenStackSmelted);
                                if (!handler.extractItem(i, itemInputsPerSmelt, true).func_190926_b()) {
                                    handler.extractItem(i, itemInputsPerSmelt, false);
                                    this.removeFuel(ped, fuelToConsume, false);
                                    this.spawnXP(world, posOfPedestal, (int)(xp * (float)itemInputsPerSmelt));
                                    if (!ped.hasMuffler()) {
                                        world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                    }
                                    ped.addItemOverride(copyIncoming);
                                }
                            }
                        }
                    }
                }
            } else {
                PedestalTileEntity ped;
                TileEntity pedestalInv = world.func_175625_s(posOfPedestal);
                if (pedestalInv instanceof PedestalTileEntity && (ped = (PedestalTileEntity)pedestalInv).getItemInPedestal().equals(ItemStack.field_190927_a)) {
                    ItemStack copyItemFromInv = itemFromInv.func_77946_l();
                    if (!handler.extractItem(i, itemFromInv.func_190916_E(), true).func_190926_b()) {
                        handler.extractItem(i, itemFromInv.func_190916_E(), false);
                        ped.addItemOverride(copyItemFromInv);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)SMELTER);
    }
}

