/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeFilteredImport
extends ItemUpgradeBase {
    public static final Item FIMPORT = (Item)new ItemUpgradeFilteredImport(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fimport"));

    public ItemUpgradeFilteredImport(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(world, pedestalPos, itemInPedestal, coinInPedestal);
            }
        }
    }

    public void upgradeAction(World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        BlockPos senderBelowInvPos = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        int transferRate = this.getItemTransferRate(coinInPedestal);
        ItemStack senderBelowInvStack = ItemStack.field_190927_a;
        TileEntity senderBelowInv = world.func_175625_s(senderBelowInvPos);
        if (senderBelowInv instanceof PedestalTileEntity) {
            senderBelowInvStack = ItemStack.field_190927_a;
        } else {
            IItemHandler senderBelowInvHandler;
            LazyOptional<IItemHandler> senderBelowInvCap = ItemUpgradeFilteredImport.findItemHandlerAtPos(world, senderBelowInvPos, this.getPedestalFacing(world, posOfPedestal), true);
            if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
                senderBelowInvCap = ItemUpgradeFilteredImport.findItemHandlerAtPosAdvanced(world, senderBelowInvPos, this.getPedestalFacing(world, posOfPedestal), true);
            }
            if (!this.isInventoryEmpty(senderBelowInvCap) && senderBelowInvCap.isPresent() && (senderBelowInvHandler = (IItemHandler)senderBelowInvCap.orElse(null)) != null) {
                ItemStack toImport = ItemStack.field_190927_a;
                TileEntity senderPedestalCheck = world.func_175625_s(posOfPedestal);
                if (senderPedestalCheck instanceof PedestalTileEntity) {
                    int i;
                    PedestalTileEntity senderPedestal = (PedestalTileEntity)senderPedestalCheck;
                    List<BlockPos> getRecievers = senderPedestal.getLocationList();
                    if (getRecievers.size() > 0) {
                        AtomicInteger slot = new AtomicInteger(0);
                        while (slot.get() < getRecievers.size()) {
                            BlockPos receiverConnection = getRecievers.get(slot.get());
                            TileEntity pedestalRec = world.func_175625_s(receiverConnection);
                            if (pedestalRec instanceof PedestalTileEntity) {
                                PedestalTileEntity receiverPedestal = (PedestalTileEntity)pedestalRec;
                                if (receiverPedestal.hasFilter(senderPedestal)) {
                                    Item coinInPed = receiverPedestal.getCoinOnPedestal().func_77973_b();
                                    int range = senderBelowInvHandler.getSlots();
                                    ItemStack itemInInv = ItemStack.field_190927_a;
                                    itemInInv = IntStream.range(0, range).mapToObj(arg_0 -> ((IItemHandler)senderBelowInvHandler).getStackInSlot(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> this.canAcceptItem(world, receiverConnection, (ItemStack)itemStack)).filter(itemStack -> this.canAcceptCount(world, receiverConnection, ((PedestalTileEntity)world.func_175625_s(receiverConnection)).getItemInPedestal(), (ItemStack)itemStack) > 0).findFirst().orElse(ItemStack.field_190927_a);
                                    if (!itemInInv.func_190926_b()) {
                                        toImport = itemInInv.func_77946_l();
                                        break;
                                    }
                                } else {
                                    int range = senderBelowInvHandler.getSlots();
                                    ItemStack itemInInv = ItemStack.field_190927_a;
                                    itemInInv = IntStream.range(0, range).mapToObj(arg_0 -> ((IItemHandler)senderBelowInvHandler).getStackInSlot(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> senderPedestal.canSendToPedestal(receiverConnection, (ItemStack)itemStack)).findFirst().orElse(ItemStack.field_190927_a);
                                    if (!itemInInv.func_190926_b()) {
                                        toImport = itemInInv.func_77946_l();
                                        break;
                                    }
                                }
                            }
                            slot.set(slot.get() + 1);
                        }
                    }
                    if ((senderPedestal.getItemInPedestal().func_190926_b() || this.doItemsMatch(senderPedestal.getItemInPedestal(), toImport)) && (i = this.getSlotWithMatchingStackExactFiltered(senderPedestal, senderBelowInvCap, toImport)) >= 0) {
                        int maxStackSizeAllowedInPedestal = 0;
                        int roomLeftInPedestal = 0;
                        senderBelowInvStack = senderBelowInvHandler.getStackInSlot(i);
                        ItemStack itemFromPedestal = this.getStackInPedestal(world, posOfPedestal);
                        if (senderBelowInvStack != null && !senderBelowInvStack.func_190926_b() && senderBelowInvStack.func_77973_b() != Items.field_190931_a) {
                            maxStackSizeAllowedInPedestal = itemFromPedestal.func_190926_b() || itemFromPedestal.equals(ItemStack.field_190927_a) ? 64 : itemFromPedestal.func_77976_d();
                            roomLeftInPedestal = maxStackSizeAllowedInPedestal - itemFromPedestal.func_190916_E();
                            int itemCountInInv = senderBelowInvStack.func_190916_E();
                            int allowedTransferRate = transferRate;
                            if (roomLeftInPedestal < transferRate) {
                                allowedTransferRate = roomLeftInPedestal;
                            }
                            if (itemCountInInv < allowedTransferRate) {
                                allowedTransferRate = itemCountInInv;
                            }
                            if (senderBelowInvHandler.extractItem(i, allowedTransferRate, true).func_190916_E() > 0) {
                                ItemStack copyIncoming = senderBelowInvStack.func_77946_l();
                                copyIncoming.func_190920_e(allowedTransferRate);
                                senderBelowInvHandler.extractItem(i, allowedTransferRate, false);
                                senderPedestal.addItem(copyIncoming);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)FIMPORT);
    }
}

