/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseExp;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExpEnchanter
extends ItemUpgradeBaseExp {
    public static final Item XPENCHANTER = (Item)new ItemUpgradeExpEnchanter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/xpenchanter"));

    public ItemUpgradeExpEnchanter(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public int getExpBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 15 + 30;
        return overEnchanted > this.maxLVLStored ? this.maxLVLStored : overEnchanted;
    }

    public float getEnchantmentPowerFromSorroundings(World world, BlockPos posOfPedestal, ItemStack coinInPedestal) {
        float enchantPower = 0.0f;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                for (int k = 0; k <= 2; ++k) {
                    BlockPos blockpos = posOfPedestal.func_177982_a(i, k, j);
                    BlockState blockNearBy = world.func_180495_p(blockpos);
                    if (!(blockNearBy.func_177230_c().getEnchantPowerBonus(blockNearBy, (IWorldReader)world, blockpos) > 0.0f)) continue;
                    enchantPower += blockNearBy.func_177230_c().getEnchantPowerBonus(blockNearBy, (IWorldReader)world, blockpos);
                }
            }
        }
        return enchantPower;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(world, itemInPedestal, coinInPedestal, pedestalPos);
            }
        }
    }

    public void upgradeAction(World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        int getMaxXpValue = this.getExpCountByLevel(this.getExpBuffer(coinInPedestal));
        if (!this.hasMaxXpSet(coinInPedestal) || this.readMaxXpFromNBT(coinInPedestal) != getMaxXpValue) {
            this.setMaxXP(coinInPedestal, getMaxXpValue);
        }
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        LazyOptional<IItemHandler> cap = ItemUpgradeExpEnchanter.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
            cap = ItemUpgradeExpEnchanter.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if (!this.isInventoryEmpty(cap) && cap.isPresent()) {
            int i;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            if (!(this.hasAdvancedInventoryTargeting(coinInPedestal) && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null && (i = this.getNextSlotWithItemsCap(cap, this.getStackInPedestal(world, posOfPedestal))) >= 0) {
                PedestalTileEntity pedestal;
                itemFromInv = handler.getStackInSlot(i);
                int slotCount = itemFromInv.func_190916_E();
                TileEntity pedestalInv = world.func_175625_s(posOfPedestal);
                if (pedestalInv instanceof PedestalTileEntity && !(pedestal = (PedestalTileEntity)pedestalInv).hasItem()) {
                    if (itemFromInv.func_77956_u() || itemFromInv.func_77973_b().equals(Items.field_151122_aG)) {
                        int expNeeded;
                        float level = this.getEnchantmentPowerFromSorroundings(world, posOfPedestal, coinInPedestal);
                        int actualEnchantingLevel = level * 2.0f < 1.0f ? 1 : (int)(level * 2.0f);
                        int currentlyStoredExp = this.getXPStored(coinInPedestal);
                        int currentLevelFromStoredXp = this.getExpLevelFromCount(currentlyStoredExp);
                        int xpLevelsNeeded = actualEnchantingLevel / 10;
                        int xpAtEnchantingLevel = this.getExpCountByLevel(actualEnchantingLevel);
                        int xpAtLevelsBelowRequired = this.getExpCountByLevel(actualEnchantingLevel - xpLevelsNeeded < 1 ? 0 : actualEnchantingLevel - xpLevelsNeeded);
                        int n = expNeeded = xpAtEnchantingLevel - xpAtLevelsBelowRequired < 7 ? 7 : xpAtEnchantingLevel - xpAtLevelsBelowRequired;
                        if (currentlyStoredExp >= expNeeded && currentLevelFromStoredXp >= actualEnchantingLevel) {
                            Random rand = new Random();
                            ItemStack itemToEnchant = itemFromInv.func_77946_l();
                            itemToEnchant.func_190920_e(1);
                            ItemStack stackToReturn = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)itemToEnchant, (int)actualEnchantingLevel, (boolean)true);
                            if ((!stackToReturn.func_190926_b() && stackToReturn.func_77948_v() || stackToReturn.func_77973_b().equals(Items.field_151134_bR)) && !handler.extractItem(i, stackToReturn.func_190916_E(), true).func_190926_b()) {
                                int getExpLeftInPedestal = currentlyStoredExp - expNeeded;
                                this.setXPStored(coinInPedestal, getExpLeftInPedestal);
                                handler.extractItem(i, stackToReturn.func_190916_E(), false);
                                if (!pedestal.hasMuffler()) {
                                    world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 0.35f, 1.0f);
                                }
                                pedestal.addItemOverride(stackToReturn);
                            }
                        }
                    } else {
                        ItemStack toReturn = itemFromInv.func_77946_l();
                        if (!handler.extractItem(i, toReturn.func_190916_E(), true).func_190926_b()) {
                            handler.extractItem(i, toReturn.func_190916_E(), false);
                            pedestal.addItemOverride(toReturn);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        int expNeeded;
        ItemStack coin = pedestal.getCoinOnPedestal();
        float level = this.getEnchantmentPowerFromSorroundings(world, pos, coin);
        int actualEnchantingLevel = level * 2.0f < 1.0f ? 1 : (int)(level * 2.0f);
        int currentlyStoredExp = this.getXPStored(coin);
        int currentLevelFromStoredXp = this.getExpLevelFromCount(currentlyStoredExp);
        int xpLevelsNeeded = actualEnchantingLevel / 10;
        int xpAtEnchantingLevel = this.getExpCountByLevel(actualEnchantingLevel);
        int xpAtLevelsBelowRequired = this.getExpCountByLevel(actualEnchantingLevel - xpLevelsNeeded < 1 ? 0 : actualEnchantingLevel - xpLevelsNeeded);
        int n = expNeeded = xpAtEnchantingLevel - xpAtLevelsBelowRequired < 7 ? 7 : xpAtEnchantingLevel - xpAtLevelsBelowRequired;
        if (!world.func_175640_z(pos)) {
            for (int i = -2; i <= 2; ++i) {
                block1: for (int j = -2; j <= 2; ++j) {
                    if (i > -2 && i < 2 && j == -1) {
                        j = 2;
                    }
                    if (rand.nextInt(16) != 0) continue;
                    for (int k = 0; k <= 2; ++k) {
                        BlockPos blockpos = pos.func_177982_a(i, k, j);
                        if (!(world.func_180495_p(blockpos).getEnchantPowerBonus((IWorldReader)world, pos) > 0.0f)) continue;
                        if (!world.func_175623_d(pos.func_177982_a(i / 2, 0, j / 2))) continue block1;
                        if (pedestal.hasParticleDiffuser()) continue;
                        world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat() - 1.0f), (double)((float)j + rand.nextFloat()) - 0.5);
                    }
                }
            }
            if (this.getXPStored(pedestal.getCoinOnPedestal()) > 0 && !pedestal.hasParticleDiffuser()) {
                this.spawnParticleAroundPedestalBase(world, tick, pos, 0.1f, 0.9f, 0.1f, 1.0f);
            }
            if (currentlyStoredExp >= expNeeded && currentLevelFromStoredXp >= actualEnchantingLevel) {
                BlockPos directionalPos = this.getPosOfBlockBelow(world, pos, 0);
                if (!pedestal.hasParticleDiffuser()) {
                    this.spawnParticleAbovePedestal(world, directionalPos, 0.94f, 0.8f, 0.95f, 1.0f);
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_xp");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        float enchanting = this.getEnchantmentPowerFromSorroundings(pedestal.func_145831_w(), pedestal.func_174877_v(), pedestal.getCoinOnPedestal());
        TranslationTextComponent enchantlvl = new TranslationTextComponent(this.func_77658_a() + ".chat_enchant");
        enchantlvl.func_240702_b_("" + (int)(enchanting * 2.0f) + "");
        enchantlvl.func_240699_a_(TextFormatting.LIGHT_PURPLE);
        player.func_145747_a((ITextComponent)enchantlvl, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)XPENCHANTER);
    }
}

