/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseExp;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExpDropper
extends ItemUpgradeBaseExp {
    public int range = 0;
    public static final Item XPDROPPER = (Item)new ItemUpgradeExpDropper(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/xpdropper"));

    public ItemUpgradeExpDropper(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    public int getTransferRate(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 5;
        int summonRate = 1;
        switch (capacityOver) {
            case 0: {
                summonRate = 1;
                break;
            }
            case 1: {
                summonRate = 5;
                break;
            }
            case 2: {
                summonRate = 10;
                break;
            }
            case 3: {
                summonRate = 15;
                break;
            }
            case 4: {
                summonRate = 20;
                break;
            }
            case 5: {
                summonRate = 25;
                break;
            }
            default: {
                summonRate = overEnchanted > this.maxLVLStored ? this.maxLVLStored : overEnchanted;
            }
        }
        return summonRate;
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        return this.getPosOfBlockBelow(world, pos, -range).func_177958_n();
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        return new int[]{this.getPosOfBlockBelow(world, pos, -range).func_177956_o(), 1};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        return this.getPosOfBlockBelow(world, pos, -range).func_177952_p();
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxXpValue = this.getExpCountByLevel(this.getExpBuffer(coinInPedestal));
            if (!this.hasMaxXpSet(coinInPedestal)) {
                this.setMaxXP(coinInPedestal, getMaxXpValue);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L && this.getXPStored(coinInPedestal) > 0) {
                this.upgradeAction(world, coinInPedestal, pedestalPos);
            }
        }
    }

    public void upgradeAction(World world, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        int rate = this.getExpCountByLevel(this.getTransferRate(coinInPedestal));
        int range = this.getRangeSmall(coinInPedestal);
        TileEntity pedestalInv = world.func_175625_s(posOfPedestal);
        if (pedestalInv instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)pedestalInv;
            int currentlyStoredExp = this.getXPStored(coinInPedestal);
            if (currentlyStoredExp > 0) {
                if (currentlyStoredExp < rate) {
                    rate = currentlyStoredExp;
                }
                ExperienceOrbEntity expEntity = new ExperienceOrbEntity(world, (double)this.getPosOfBlockBelow(world, posOfPedestal, -range).func_177958_n() + 0.5, (double)this.getPosOfBlockBelow(world, posOfPedestal, -range).func_177956_o(), (double)this.getPosOfBlockBelow(world, posOfPedestal, -range).func_177952_p() + 0.5, rate);
                expEntity.func_213293_j(0.0, 0.0, 0.0);
                int getExpLeftInPedestal = currentlyStoredExp - rate;
                if (!pedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187601_be, SoundCategory.BLOCKS, 0.25f, 1.0f);
                }
                this.setXPStored(coinInPedestal, getExpLeftInPedestal);
                world.func_217376_c((Entity)expEntity);
            }
        }
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
    }

    @Override
    public int getExpBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 5 + 5;
        return overEnchanted >= this.maxLVLStored ? this.maxLVLStored : overEnchanted;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        int tr = this.getTransferRate(stack);
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_xp");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".chat_range");
        range.func_240702_b_("" + this.getRangeSmall(stack) + "");
        range.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)range, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + tr + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int tr = this.getTransferRate(stack);
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".tooltip_range");
        range.func_240702_b_("" + this.getRangeSmall(stack) + "");
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + tr + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        range.func_240699_a_(TextFormatting.WHITE);
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)range);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)XPDROPPER);
    }
}

