/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseEnergy;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEnergyTank
extends ItemUpgradeBaseEnergy {
    public static final Item RFTANK = (Item)new ItemUpgradeEnergyTank(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/rftank"));

    public ItemUpgradeEnergyTank(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptOpSpeed() {
        return false;
    }

    @Override
    public int getEnergyBuffer(ItemStack stack) {
        int energyBuffer = 100000;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                energyBuffer = 100000;
                break;
            }
            case 1: {
                energyBuffer = 500000;
                break;
            }
            case 2: {
                energyBuffer = 1000000;
                break;
            }
            case 3: {
                energyBuffer = 500000000;
                break;
            }
            case 4: {
                energyBuffer = 1000000000;
                break;
            }
            case 5: {
                energyBuffer = 2000000000;
                break;
            }
            default: {
                energyBuffer = 100000;
            }
        }
        return energyBuffer;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                this.upgradeActionSendEnergy(pedestal);
                int getMaxEnergyValue = this.getEnergyBuffer(coinInPedestal);
                if (!this.hasMaxEnergySet(coinInPedestal) || this.readMaxEnergyFromNBT(coinInPedestal) != getMaxEnergyValue) {
                    this.setMaxEnergy(coinInPedestal, getMaxEnergyValue);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)RFTANK);
    }
}

