/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseEnergy;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEnergyField
extends ItemUpgradeBaseEnergy {
    public static final Item ENERGYFIELD = (Item)new ItemUpgradeEnergyField(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/rffield"));

    public ItemUpgradeEnergyField(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                int getMaxEnergyValue = this.getEnergyBuffer(coinInPedestal);
                if (!this.hasMaxEnergySet(coinInPedestal) || this.readMaxEnergyFromNBT(coinInPedestal) != getMaxEnergyValue) {
                    this.setMaxEnergy(coinInPedestal, getMaxEnergyValue);
                }
                if (world.func_82737_E() % 200L == 0L) {
                    this.writeStoredIntTwoToNBT(coinInPedestal, -1);
                }
                if (world.func_82737_E() % (long)speed == 0L) {
                    this.upgradeAction(pedestal, world, itemInPedestal, coinInPedestal, pedestalPos);
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        int width = this.getAreaWidth(coinInPedestal);
        int height = this.getHeight(coinInPedestal);
        int val = this.readStoredIntTwoFromNBT(coinInPedestal);
        if (val < 0) {
            this.removeWorkQueueFromCoin(coinInPedestal);
            this.writeStoredIntTwoToNBT(coinInPedestal, 0);
        }
        if (this.workQueueSize(coinInPedestal) <= 0) {
            this.buildWorkQueue(pedestal, width, height);
        }
        if (val > 0) {
            this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
        } else if (this.workQueueSize(coinInPedestal) > 0) {
            List<BlockPos> workQueue = this.readWorkQueueFromNBT(coinInPedestal);
            for (int i = 0; i < workQueue.size(); ++i) {
                BlockPos targetPos = workQueue.get(i);
                BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                BlockState targetBlock = world.func_180495_p(blockToMinePos);
                if (this.canMineBlock(pedestal, blockToMinePos)) {
                    this.sendEnergyToBlocks(pedestal, blockToMinePos);
                    continue;
                }
                workQueue.remove(i);
            }
            this.writeWorkQueueToNBT(coinInPedestal, workQueue);
        } else {
            this.writeStoredIntTwoToNBT(coinInPedestal, 100);
        }
    }

    private boolean sendEnergyToBlocks(PedestalTileEntity pedestal, BlockPos target) {
        IEnergyStorage handler;
        World world = pedestal.func_145831_w();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        if (world.func_175625_s(target) instanceof PedestalTileEntity) {
            this.sendEnergyToPedestal(pedestal, (PedestalTileEntity)world.func_175625_s(target));
            return true;
        }
        LazyOptional<IEnergyStorage> cap = ItemUpgradeEnergyField.findEnergyHandlerAtPos(world, target, this.getPedestalFacing(world, posOfPedestal), true);
        if (cap.isPresent() && (handler = (IEnergyStorage)cap.orElse(null)) != null && handler.canReceive()) {
            int transferRate;
            int containerMaxEnergy = handler.getMaxEnergyStored();
            int containerCurrentEnergy = handler.getEnergyStored();
            int containerEnergySpace = containerMaxEnergy - containerCurrentEnergy;
            int getCurrentEnergy = this.getEnergyStored(coinInPedestal);
            int n = transferRate = containerEnergySpace >= this.getEnergyTransferRate(coinInPedestal) ? this.getEnergyTransferRate(coinInPedestal) : containerEnergySpace;
            if (getCurrentEnergy < transferRate) {
                transferRate = getCurrentEnergy;
            }
            if (handler.receiveEnergy(transferRate, true) > 0) {
                int energyRemainingInUpgrade = getCurrentEnergy - transferRate;
                this.setEnergyStored(coinInPedestal, energyRemainingInUpgrade);
                return handler.receiveEnergy(transferRate, false) > 0;
            }
        }
        return false;
    }

    private boolean isEnergyPedestal(PedestalTileEntity pedestal, BlockPos blockToCheck) {
        PedestalTileEntity pedestalBeingChecked;
        ItemStack coin;
        boolean returner = false;
        World world = pedestal.func_145831_w();
        if (world.func_180495_p(blockToCheck).func_177230_c() instanceof PedestalBlock && world.func_175625_s(blockToCheck) instanceof PedestalTileEntity && (coin = (pedestalBeingChecked = (PedestalTileEntity)world.func_175625_s(blockToCheck)).getCoinOnPedestal()).func_77973_b() instanceof ItemUpgradeBaseEnergy) {
            returner = true;
        }
        return returner;
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        LazyOptional<IEnergyStorage> cap;
        World world = pedestal.func_145831_w();
        BlockState blockStateEnergyConsumer = world.func_180495_p(blockToMinePos);
        Block blockEnergyConsumer = blockStateEnergyConsumer.func_177230_c();
        return !blockEnergyConsumer.isAir(blockStateEnergyConsumer, (IBlockReader)world, blockToMinePos) && ((cap = ItemUpgradeEnergyField.findEnergyHandlerAtPos(world, blockToMinePos, this.getPedestalFacing(world, pedestal.func_174877_v()), false)).isPresent() || this.isEnergyPedestal(pedestal, blockToMinePos));
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        LazyOptional<IEnergyStorage> cap;
        World world = pedestal.func_145831_w();
        BlockState blockStateEnergyConsumer = world.func_180495_p(blockToMinePos);
        Block blockEnergyConsumer = blockStateEnergyConsumer.func_177230_c();
        BlockPos pedestalPos = pedestal.func_174877_v();
        return !(blockEnergyConsumer.isAir(blockStateEnergyConsumer, (IBlockReader)world, blockToMinePos) && pedestalPos.equals((Object)blockToMinePos) || !(cap = ItemUpgradeEnergyField.findEnergyHandlerAtPos(world, blockToMinePos, this.getPedestalFacing(world, pedestal.func_174877_v()), false)).isPresent() && !this.isEnergyPedestal(pedestal, blockToMinePos));
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent rfstored = new TranslationTextComponent(this.func_77658_a() + ".chat_rfstored");
        rfstored.func_240702_b_("" + this.getEnergyStored(stack) + "");
        rfstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)rfstored, Util.field_240973_b_);
        TranslationTextComponent energyRate = new TranslationTextComponent(this.func_77658_a() + ".chat_rfrate");
        energyRate.func_240702_b_("" + this.getEnergyTransferRate(stack) + "");
        energyRate.func_240699_a_(TextFormatting.AQUA);
        player.func_145747_a((ITextComponent)energyRate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)area);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ENERGYFIELD);
    }
}

