/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.api.upgrade.IUpgradeBase;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.enchants.EnchantmentRegistry;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEnderFilteredRestock
extends ItemUpgradeBase {
    public static final Item ENDERFRESTOCK = (Item)new ItemUpgradeEnderFilteredRestock(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/enderfilteredrestock"));

    public ItemUpgradeEnderFilteredRestock(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptOpSpeed() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.func_77973_b() instanceof IUpgradeBase && enchantment.getRegistryName().func_110624_b().equals("pedestals")) {
            return !EnchantmentRegistry.COINUPGRADE.equals((Object)enchantment.field_77351_y) && super.canApplyAtEnchantingTable(stack, enchantment);
        }
        return false;
    }

    @Override
    public int func_77619_b() {
        return 10;
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return stack.func_190916_E() == 1 ? super.isBookEnchantable(stack, book) : false;
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    @Override
    public int canAcceptCount(World world, BlockPos posPedestal, ItemStack inPedestal, ItemStack itemStackIncoming) {
        TileEntity tile = world.func_175625_s(posPedestal);
        if (tile instanceof PedestalTileEntity) {
            PedestalTileEntity ped = (PedestalTileEntity)tile;
            ItemStack coinInPedestal = ped.getCoinOnPedestal();
            ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            PlayerEntity player = sworld.func_217371_b(this.getPlayerFromCoin(coinInPedestal));
            if (player != null) {
                if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
                    int range = player.field_71071_by.func_70302_i_();
                    ItemStack stack = IntStream.range(0, range).mapToObj(arg_0 -> ((PlayerInventory)player.field_71071_by).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_190916_E() != itemStack.func_77976_d()).filter(itemStack -> this.doItemsMatch((ItemStack)itemStack, itemStackIncoming)).findFirst().orElse(ItemStack.field_190927_a);
                    if (!stack.func_190926_b() && stack.func_190916_E() + inPedestal.func_190916_E() < itemStackIncoming.func_77976_d()) {
                        return itemStackIncoming.func_77976_d() - (stack.func_190916_E() + inPedestal.func_190916_E());
                    }
                } else {
                    int range = player.func_71005_bN().func_70302_i_();
                    ItemStack stack = IntStream.range(0, range).mapToObj(arg_0 -> ((EnderChestInventory)player.func_71005_bN()).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_190916_E() != itemStack.func_77976_d()).filter(itemStack -> this.doItemsMatch((ItemStack)itemStack, itemStackIncoming)).findFirst().orElse(ItemStack.field_190927_a);
                    if (!stack.func_190926_b() && stack.func_190916_E() + inPedestal.func_190916_E() < itemStackIncoming.func_77976_d()) {
                        return itemStackIncoming.func_77976_d() - (stack.func_190916_E() + inPedestal.func_190916_E());
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public boolean canAcceptItem(World world, BlockPos posPedestal, ItemStack itemStackIn) {
        boolean returner = false;
        TileEntity tile = world.func_175625_s(posPedestal);
        if (tile instanceof PedestalTileEntity) {
            PedestalTileEntity ped = (PedestalTileEntity)tile;
            ItemStack coinInPedestal = ped.getCoinOnPedestal();
            ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            PlayerEntity player = sworld.func_217371_b(this.getPlayerFromCoin(coinInPedestal));
            if (player != null) {
                if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
                    int range = player.field_71071_by.func_70302_i_();
                    ItemStack itemFromInv = ItemStack.field_190927_a;
                    itemFromInv = IntStream.range(0, range).mapToObj(arg_0 -> ((PlayerInventory)player.field_71071_by).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_190916_E() != itemStack.func_77976_d()).filter(itemStack -> this.doItemsMatch((ItemStack)itemStack, itemStackIn)).findFirst().orElse(ItemStack.field_190927_a);
                    if (!itemFromInv.func_190926_b()) {
                        returner = true;
                    }
                } else {
                    int range = player.func_71005_bN().func_70302_i_();
                    ItemStack itemFromInv = ItemStack.field_190927_a;
                    itemFromInv = IntStream.range(0, range).mapToObj(arg_0 -> ((EnderChestInventory)player.func_71005_bN()).func_70301_a(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_190916_E() != itemStack.func_77976_d()).filter(itemStack -> this.doItemsMatch((ItemStack)itemStack, itemStackIn)).findFirst().orElse(ItemStack.field_190927_a);
                    if (!itemFromInv.func_190926_b()) {
                        returner = true;
                    }
                }
            }
        }
        return returner;
    }

    public int getSlotNumberNext(int currentSlotNumber, int range, ItemStack inPedestal, ItemStack inInventory) {
        int i;
        int slotToReturn = -1;
        int slots = currentSlotNumber + 1;
        int ranger = range;
        if (slots >= ranger) {
            slots = 0;
        }
        for (i = slots; i < ranger; ++i) {
            if (!this.doItemsMatch(inPedestal, inInventory)) continue;
            slotToReturn = i;
            break;
        }
        if (slotToReturn == -1) {
            for (i = 0; i < ranger; ++i) {
                if (!this.doItemsMatch(inPedestal, inInventory)) continue;
                slotToReturn = i;
                break;
            }
        }
        return slots;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(world, pedestalPos, itemInPedestal, coinInPedestal);
            }
        }
    }

    public void upgradeAction(World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        int i = this.getStoredInt(coinInPedestal);
        int upgradeTransferRate = 64;
        ItemStack itemFromPedestal = this.getStackInPedestal(world, posOfPedestal);
        ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
        if (!itemFromPedestal.func_190926_b() && !itemFromPedestal.equals(ItemStack.field_190927_a)) {
            PlayerEntity player = sworld.func_217371_b(this.getPlayerFromCoin(coinInPedestal));
            PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
            if (player != null) {
                if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
                    ItemStack itemFromInventory = ItemStack.field_190927_a;
                    itemFromPedestal = itemInPedestal.func_77946_l();
                    if (i < inventory.getSlots() && inventory.getStackInSlot(i) != null) {
                        itemFromInventory = inventory.getStackInSlot(i);
                    }
                    if (i >= 0 && i < inventory.getSlots()) {
                        if (inventory.isItemValid(i, itemFromPedestal)) {
                            int slotnext = this.getSlotNumberNext(i, inventory.getSlots(), itemFromPedestal, itemFromInventory);
                            if (this.doItemsMatch(itemFromPedestal, itemFromInventory)) {
                                int spaceInInventoryStack = inventory.getStackInSlot(i).func_190926_b() ? 0 : inventory.getStackInSlot(i).func_77976_d() - itemFromInventory.func_190916_E();
                                int allowedTransferRate = upgradeTransferRate;
                                if (inventory.getStackInSlot(i).func_77976_d() <= allowedTransferRate) {
                                    allowedTransferRate = inventory.getStackInSlot(i).func_77976_d();
                                }
                                if (allowedTransferRate > spaceInInventoryStack) {
                                    allowedTransferRate = spaceInInventoryStack;
                                }
                                if (allowedTransferRate > itemFromPedestal.func_190916_E()) {
                                    allowedTransferRate = itemFromPedestal.func_190916_E();
                                }
                                itemFromPedestal.func_190920_e(allowedTransferRate);
                                if (inventory.insertItem(i, itemFromPedestal, true).equals(ItemStack.field_190927_a)) {
                                    this.removeFromPedestal(world, posOfPedestal, allowedTransferRate);
                                    inventory.insertItem(i, itemFromPedestal, false);
                                    this.writeStoredIntToNBT(coinInPedestal, slotnext);
                                }
                            } else {
                                this.writeStoredIntToNBT(coinInPedestal, slotnext);
                            }
                        }
                    } else {
                        int slotnext = this.getSlotNumberNext(i, inventory.getSlots(), itemFromPedestal, itemFromInventory);
                        this.writeStoredIntToNBT(coinInPedestal, slotnext);
                    }
                } else {
                    ItemStack itemFromInventory = ItemStack.field_190927_a;
                    itemFromPedestal = itemInPedestal.func_77946_l();
                    if (i < player.func_71005_bN().func_70302_i_() && player.func_71005_bN().func_70301_a(i) != null) {
                        itemFromInventory = player.func_71005_bN().func_70301_a(i);
                    }
                    if (i >= 0 && i < player.func_71005_bN().func_70302_i_()) {
                        if (player.func_71005_bN().func_94041_b(i, itemFromPedestal)) {
                            int slotnext = this.getSlotNumberNext(i, player.func_71005_bN().func_70302_i_(), itemFromPedestal, itemFromInventory);
                            if (this.doItemsMatch(itemFromPedestal, itemFromInventory)) {
                                int spaceInInventoryStack = player.func_71005_bN().func_70301_a(i).func_190926_b() ? 0 : player.func_71005_bN().func_70301_a(i).func_77976_d() - itemFromInventory.func_190916_E();
                                int allowedTransferRate = upgradeTransferRate;
                                if (player.func_71005_bN().func_70301_a(i).func_77976_d() <= allowedTransferRate) {
                                    allowedTransferRate = player.func_71005_bN().func_70301_a(i).func_77976_d();
                                }
                                if (allowedTransferRate > spaceInInventoryStack) {
                                    allowedTransferRate = spaceInInventoryStack;
                                }
                                if (allowedTransferRate > itemFromPedestal.func_190916_E()) {
                                    allowedTransferRate = itemFromPedestal.func_190916_E();
                                }
                                itemFromPedestal.func_190920_e(allowedTransferRate);
                                ItemStack leftovers = player.func_71005_bN().func_174894_a(itemFromPedestal);
                                if (leftovers.func_190926_b()) {
                                    this.removeFromPedestal(world, posOfPedestal, itemFromPedestal.func_190916_E());
                                } else {
                                    int remover = itemFromPedestal.func_190916_E() - leftovers.func_190916_E();
                                    this.removeFromPedestal(world, posOfPedestal, remover);
                                }
                            } else {
                                this.writeStoredIntToNBT(coinInPedestal, slotnext);
                            }
                        }
                    } else {
                        int slotnext = this.getSlotNumberNext(i, player.func_71005_bN().func_70302_i_(), itemFromPedestal, itemFromInventory);
                        this.writeStoredIntToNBT(coinInPedestal, slotnext);
                    }
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ENDERFRESTOCK);
    }
}

