/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEffectPlanter
extends ItemUpgradeBase {
    public static final Item PLANTER = (Item)new ItemUpgradeEffectPlanter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/planter"));

    public ItemUpgradeEffectPlanter(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            ItemStack coin = pedestal.getCoinOnPedestal();
            int amount = this.workQueueSize(coin);
            int area = this.workQueueTwoSize(coin);
            if (amount > 0) {
                float f = (float)amount / (float)area;
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                BlockPos posNums;
                int rangeWidth = this.getAreaWidth(coinInPedestal);
                int rangeHeight = this.getHeight(coinInPedestal);
                BlockState pedestalState = world.func_180495_p(pedestalPos);
                Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
                BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight);
                if (world.func_175707_a(negNums, posNums = this.getPosRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight))) {
                    int speed = this.getOperationSpeed(coinInPedestal);
                    int val = this.readStoredIntTwoFromNBT(coinInPedestal);
                    if (val > 0) {
                        this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
                    } else {
                        if (this.workQueueSize(coinInPedestal) <= 0) {
                            this.buildWorkQueue(pedestal, rangeWidth, rangeHeight);
                            this.buildWorkQueueTwo(pedestal, rangeWidth, rangeHeight);
                        }
                        if (this.workQueueSize(coinInPedestal) > 0) {
                            List<BlockPos> workQueue = this.readWorkQueueFromNBT(coinInPedestal);
                            if (world.func_82737_E() % (long)speed == 0L) {
                                for (int i = 0; i < workQueue.size(); ++i) {
                                    BlockPos targetPos = workQueue.get(i);
                                    BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                                    BlockState targetBlock = world.func_180495_p(blockToMinePos);
                                    if (this.canMineBlock(pedestal, blockToMinePos)) {
                                        workQueue.remove(i);
                                        this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                                        this.upgradeAction(world, pedestal, itemInPedestal, pedestalPos, targetPos, targetBlock);
                                        if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
                                        break;
                                    }
                                    workQueue.remove(i);
                                }
                                this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                            }
                        } else {
                            this.writeStoredIntTwoToNBT(coinInPedestal, 100);
                        }
                    }
                }
            }
        }
    }

    public void upgradeAction(World world, PedestalTileEntity pedestal, ItemStack itemInPedestal, BlockPos posOfPedestal, BlockPos posTarget, BlockState target) {
        Random rand = new Random();
        Item singleItemInPedestal = itemInPedestal.func_77973_b();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        if (world.func_180495_p(posTarget).func_177230_c().equals(Blocks.field_150350_a) && !singleItemInPedestal.equals(Items.field_190931_a) && singleItemInPedestal instanceof BlockItem && ((BlockItem)singleItemInPedestal).func_179223_d() instanceof IPlantable && !itemInPedestal.func_190926_b() && itemInPedestal.func_77973_b() instanceof BlockItem && ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d() instanceof IPlantable) {
            FakePlayer fakePlayer;
            Block block = ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d();
            if (world.func_180495_p(posTarget.func_177977_b()).canSustainPlant((IBlockReader)world, posTarget.func_177977_b(), Direction.UP, (IPlantable)block) && (fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get()) != null) {
                BlockItemUseContext blockContext;
                ActionResultType result;
                fakePlayer.func_174810_b(true);
                if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(posOfPedestal.func_177958_n(), posOfPedestal.func_177956_o(), posOfPedestal.func_177952_p()))) {
                    fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
                }
                if ((result = ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)(blockContext = new BlockItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, itemInPedestal.func_77946_l(), new BlockRayTraceResult(Vector3d.field_186680_a, Direction.UP, posTarget.func_177977_b(), false))))) == ActionResultType.CONSUME) {
                    this.removeFromPedestal(world, posOfPedestal, 1);
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posTarget.func_177958_n(), (double)posTarget.func_177956_o(), (double)posTarget.func_177952_p(), SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                }
            }
        }
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        World world = pedestal.func_145831_w();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        BlockPos targetPos = blockToMinePos;
        BlockPos blockToPlantPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        BlockState blockToPlantState = world.func_180495_p(blockToPlantPos);
        Block blockToPlant = blockToPlantState.func_177230_c();
        Item singleItemInPedestal = itemInPedestal.func_77973_b();
        if (blockToPlant.equals(Blocks.field_150350_a) && !singleItemInPedestal.equals(Items.field_190931_a) && singleItemInPedestal instanceof BlockItem && ((BlockItem)singleItemInPedestal).func_179223_d() instanceof IPlantable && !itemInPedestal.func_190926_b() && itemInPedestal.func_77973_b() instanceof BlockItem && ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d() instanceof IPlantable) {
            Block block = ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d();
            if (world.func_180495_p(blockToPlantPos.func_177977_b()).canSustainPlant((IBlockReader)world, blockToPlantPos.func_177977_b(), Direction.UP, (IPlantable)block)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        World world = pedestal.func_145831_w();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        BlockPos targetPos = blockToMinePos;
        BlockPos blockToPlantPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        BlockState blockToPlantState = world.func_180495_p(blockToPlantPos);
        Block blockToPlant = blockToPlantState.func_177230_c();
        Item singleItemInPedestal = itemInPedestal.func_77973_b();
        if (blockToPlant.equals(Blocks.field_150350_a) && !singleItemInPedestal.equals(Items.field_190931_a) && singleItemInPedestal instanceof BlockItem && ((BlockItem)singleItemInPedestal).func_179223_d() instanceof IPlantable && !itemInPedestal.func_190926_b() && itemInPedestal.func_77973_b() instanceof BlockItem && ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d() instanceof IPlantable) {
            Block block = ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d();
            if (world.func_180495_p(blockToPlantPos.func_177977_b()).canSustainPlant((IBlockReader)world, blockToPlantPos.func_177977_b(), Direction.UP, (IPlantable)block)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canMineBlockTwo(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        World world = pedestal.func_145831_w();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        BlockPos targetPos = blockToMinePos;
        BlockPos blockToPlantPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
        BlockState blockToPlantState = world.func_180495_p(blockToPlantPos);
        Block blockToPlant = blockToPlantState.func_177230_c();
        Item singleItemInPedestal = itemInPedestal.func_77973_b();
        if (!singleItemInPedestal.equals(Items.field_190931_a) && singleItemInPedestal instanceof BlockItem && ((BlockItem)singleItemInPedestal).func_179223_d() instanceof IPlantable && !itemInPedestal.func_190926_b() && itemInPedestal.func_77973_b() instanceof BlockItem && ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d() instanceof IPlantable) {
            Block block = ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d();
            if (world.func_180495_p(blockToPlantPos.func_177977_b()).canSustainPlant((IBlockReader)world, blockToPlantPos.func_177977_b(), Direction.UP, (IPlantable)block)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent btm = new TranslationTextComponent(this.func_77658_a() + ".chat_btm");
        btm.func_240702_b_("" + this.workQueueSize(stack) + "");
        btm.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)btm, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)area);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)PLANTER);
    }
}

