/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.google.common.collect.Maps;
import com.mowmaster.pedestals.item.ItemCraftingPlaceholder;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseMachine;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeCraftermk2
extends ItemUpgradeBaseMachine {
    public static final Item CRAFTER_ONE = (Item)new ItemUpgradeCraftermk2(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/crafter1mk2"));
    public static final Item CRAFTER_TWO = (Item)new ItemUpgradeCraftermk2(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/crafter2mk2"));
    public static final Item CRAFTER_THREE = (Item)new ItemUpgradeCraftermk2(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/crafter3mk2"));

    public ItemUpgradeCraftermk2(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public int getGridSize(ItemStack itemStack) {
        int gridSize = 0;
        gridSize = itemStack.func_77973_b().equals(CRAFTER_ONE) ? 1 : (itemStack.func_77973_b().equals(CRAFTER_TWO) ? 2 : (itemStack.func_77973_b().equals(CRAFTER_THREE) ? 3 : 1));
        return gridSize;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
    }

    public static IRecipe<CraftingInventory> findRecipe(CraftingInventory inv, World world) {
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inv, world).orElse(null);
    }

    public void removeAllOfThisItemFromInventory(LazyOptional<IItemHandler> cap, ItemStack stackToRemove, int countToRemove) {
        if (cap.isPresent()) {
            int inSlotCount;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            for (int counter = countToRemove; counter > 0; counter -= inSlotCount) {
                int slotToFind = this.getSlotWithMatchingStack(cap, stackToRemove);
                inSlotCount = handler.getStackInSlot(slotToFind).func_190916_E();
                if (inSlotCount >= counter) {
                    handler.extractItem(slotToFind, counter, false);
                    break;
                }
                handler.extractItem(slotToFind, inSlotCount, false);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal) {
        LazyOptional<IItemHandler> cap;
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coin = pedestal.getCoinOnPedestal();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        int gridSize = this.getGridSize(coin);
        int intBatchCraftingSize = this.getItemTransferRate(coin);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        BlockPos posInventory = this.getPosOfBlockBelow(world, pedestalPos, 1);
        int intGridCount = gridSize * gridSize;
        if (this.getFilterChangeStatus(pedestal.getCoinOnPedestal())) {
            this.buildOutputIngredientMapFromPattern(pedestal);
            this.setFilterChangeUpdated(pedestal.getCoinOnPedestal());
        }
        if (pedestal.hasFilter() && itemInPedestal.func_190926_b() && !this.isInventoryEmpty(cap = ItemUpgradeCraftermk2.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, pedestalPos), true)) && cap.isPresent()) {
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            int intInventorySlotCount = handler.getSlots();
            if (!(this.hasAdvancedInventoryTargeting(coin) && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null) {
                LinkedHashMap itemExtractionMap = Maps.newLinkedHashMap();
                Map<ItemStack, List<ItemStack>> craftingMap = this.readOutputIngredientMapFromNBT(coin);
                if (craftingMap.size() <= 0) {
                    this.buildOutputIngredientMapFromPattern(pedestal);
                    this.setFilterChangeUpdated(pedestal.getCoinOnPedestal());
                    craftingMap = this.readOutputIngredientMapFromNBT(coin);
                }
                int counter = 0;
                for (Map.Entry<ItemStack, List<ItemStack>> entry : craftingMap.entrySet()) {
                    if (counter >= craftingMap.size()) break;
                    int intGetNextIteration = this.getStoredInt(coin);
                    if (intGetNextIteration >= craftingMap.size()) {
                        intGetNextIteration = 0;
                    }
                    if (intGetNextIteration == counter) {
                        ItemStack stackIngredent;
                        ItemStack result = entry.getKey();
                        if (result == null || pedestal.canAcceptItems(world, pedestalPos, result) <= 0) continue;
                        List<ItemStack> ingredientList = entry.getValue();
                        int hasIngredents = 0;
                        if (intBatchCraftingSize <= 0) continue;
                        int intRecipeResultCount = result.func_190916_E();
                        int intBatchCraftedAmount = intRecipeResultCount * intBatchCraftingSize;
                        if (intBatchCraftedAmount > 64) {
                            intBatchCraftingSize = Math.floorDiv(64, intRecipeResultCount);
                        }
                        for (int ing = 0; ing < ingredientList.size(); ++ing) {
                            int sizeNeeded;
                            stackIngredent = ingredientList.get(ing);
                            if (stackIngredent.func_190926_b() || stackIngredent.func_77973_b().equals(ItemCraftingPlaceholder.PLACEHOLDER)) {
                                ++hasIngredents;
                                continue;
                            }
                            if (stackIngredent.hasContainerItem() || this.hasEnoughInInv(cap, stackIngredent, sizeNeeded = intBatchCraftingSize * ingredientList.get(ing).func_190916_E()) < sizeNeeded) break;
                            ++hasIngredents;
                        }
                        if (hasIngredents == ingredientList.size()) {
                            for (int extract = 0; extract < ingredientList.size(); ++extract) {
                                stackIngredent = ingredientList.get(extract);
                                int countItems = stackIngredent.func_190916_E();
                                if (stackIngredent.func_190926_b() || stackIngredent.func_77973_b().equals(ItemCraftingPlaceholder.PLACEHOLDER)) continue;
                                this.removeAllOfThisItemFromInventory(cap, stackIngredent, stackIngredent.func_190916_E());
                            }
                            result.func_190920_e(intBatchCraftedAmount);
                            if (!pedestal.hasMuffler()) {
                                world.func_184148_a((PlayerEntity)null, (double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), SoundEvents.field_219705_mM, SoundCategory.BLOCKS, 0.25f, 1.0f);
                            }
                            this.addToPedestalOverride(world, pedestalPos, result);
                            this.writeStoredIntToNBT(coin, intGetNextIteration + 1);
                            break;
                        }
                        this.writeStoredIntToNBT(coin, intGetNextIteration + 1);
                        continue;
                    }
                    ++counter;
                }
            }
        }
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
    }

    @Override
    public String getOperationSpeedString(ItemStack stack) {
        TranslationTextComponent normal = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_0");
        TranslationTextComponent twox = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_1");
        TranslationTextComponent fourx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_2");
        TranslationTextComponent sixx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_3");
        TranslationTextComponent tenx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_4");
        TranslationTextComponent twentyx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_5");
        String str = normal.getString();
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                str = normal.getString();
                break;
            }
            case 1: {
                str = twox.getString();
                break;
            }
            case 2: {
                str = fourx.getString();
                break;
            }
            case 3: {
                str = sixx.getString();
                break;
            }
            case 4: {
                str = tenx.getString();
                break;
            }
            case 5: {
                str = twentyx.getString();
                break;
            }
            default: {
                str = normal.getString();
            }
        }
        return str;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        List<ItemStack> list = this.readCraftingQueueFromNBT(stack);
        if (list.size() > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_recipes");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (int i = 0; i < list.size(); ++i) {
                TranslationTextComponent enchants = new TranslationTextComponent(list.get(i).func_190926_b() ? " - " : " - " + list.get(i).func_200301_q().getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        TranslationTextComponent WIP = new TranslationTextComponent("pedestals.wip");
        WIP.func_240699_a_(TextFormatting.YELLOW);
        tooltip.add((ITextComponent)WIP);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        int s2 = this.getItemTransferRate(stack);
        String trr = this.getOperationSpeedString(stack);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + s2 + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(trr);
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)CRAFTER_ONE);
        event.getRegistry().register((IForgeRegistryEntry)CRAFTER_TWO);
        event.getRegistry().register((IForgeRegistryEntry)CRAFTER_THREE);
    }
}

