/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseEnergy;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemUpgradeBaseEnergyMachine
extends ItemUpgradeBaseEnergy {
    public final int rfCostPerItemSmelted = 2500;

    public ItemUpgradeBaseEnergyMachine(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public int getCapacityModifier(ItemStack stack) {
        int capacity = 0;
        if (this.hasEnchant(stack)) {
            capacity = this.getCapacityModifierOverEnchanted(stack) > 10 ? 10 : this.getCapacityModifierOverEnchanted(stack);
        }
        return capacity;
    }

    @Override
    public int getEnergyBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int energyBuffer = capacityOver * 20000;
        switch (capacityOver) {
            case 0: {
                energyBuffer = 10000;
                break;
            }
            case 1: {
                energyBuffer = 20000;
                break;
            }
            case 2: {
                energyBuffer = 40000;
                break;
            }
            case 3: {
                energyBuffer = 60000;
                break;
            }
            case 4: {
                energyBuffer = 80000;
                break;
            }
            case 5: {
                energyBuffer = 100000;
                break;
            }
            default: {
                energyBuffer = energyBuffer > this.maxStored ? this.maxStored : energyBuffer;
            }
        }
        return energyBuffer;
    }

    @Override
    public int getItemTransferRate(ItemStack stack) {
        int itemsPerSmelt = 1;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                itemsPerSmelt = 1;
                break;
            }
            case 1: {
                itemsPerSmelt = 4;
                break;
            }
            case 2: {
                itemsPerSmelt = 8;
                break;
            }
            case 3: {
                itemsPerSmelt = 12;
                break;
            }
            case 4: {
                itemsPerSmelt = 16;
                break;
            }
            case 5: {
                itemsPerSmelt = 24;
                break;
            }
            case 6: {
                itemsPerSmelt = 32;
                break;
            }
            case 7: {
                itemsPerSmelt = 40;
                break;
            }
            case 8: {
                itemsPerSmelt = 48;
                break;
            }
            case 9: {
                itemsPerSmelt = 56;
                break;
            }
            case 10: {
                itemsPerSmelt = 64;
                break;
            }
            default: {
                itemsPerSmelt = 1;
            }
        }
        return itemsPerSmelt;
    }

    @Override
    public int intOperationalSpeedModifier(ItemStack stack) {
        int rate = 0;
        if (this.hasEnchant(stack)) {
            rate = this.intOperationalSpeedModifierOverride(stack) > 10 ? 10 : this.intOperationalSpeedModifierOverride(stack);
        }
        return rate;
    }

    public int getSmeltingSpeed(ItemStack stack) {
        int smeltingSpeed = 200;
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                smeltingSpeed = 200;
                break;
            }
            case 1: {
                smeltingSpeed = 100;
                break;
            }
            case 2: {
                smeltingSpeed = 50;
                break;
            }
            case 3: {
                smeltingSpeed = 40;
                break;
            }
            case 4: {
                smeltingSpeed = 33;
                break;
            }
            case 5: {
                smeltingSpeed = 20;
                break;
            }
            case 6: {
                smeltingSpeed = 10;
                break;
            }
            case 7: {
                smeltingSpeed = 5;
                break;
            }
            case 8: {
                smeltingSpeed = 3;
                break;
            }
            case 9: {
                smeltingSpeed = 2;
                break;
            }
            case 10: {
                smeltingSpeed = 1;
                break;
            }
            default: {
                smeltingSpeed = 200;
            }
        }
        return smeltingSpeed;
    }

    @Override
    public String getOperationSpeedString(ItemStack stack) {
        TranslationTextComponent normal = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_0");
        TranslationTextComponent twox = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_1");
        TranslationTextComponent fourx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_2");
        TranslationTextComponent fivex = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_3");
        TranslationTextComponent sixx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_4");
        TranslationTextComponent tenx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_5");
        TranslationTextComponent twentyx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_6");
        TranslationTextComponent fourtyx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_7");
        TranslationTextComponent sixtyx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_8");
        TranslationTextComponent onehunx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_9");
        TranslationTextComponent twohunx = new TranslationTextComponent("pedestals.upgrade_machine_tooltips.speed_10");
        String str = normal.getString();
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                str = normal.getString();
                break;
            }
            case 1: {
                str = twox.getString();
                break;
            }
            case 2: {
                str = fourx.getString();
                break;
            }
            case 3: {
                str = fivex.getString();
                break;
            }
            case 4: {
                str = sixx.getString();
                break;
            }
            case 5: {
                str = tenx.getString();
                break;
            }
            case 6: {
                str = twentyx.getString();
                break;
            }
            case 7: {
                str = fourtyx.getString();
                break;
            }
            case 8: {
                str = sixtyx.getString();
                break;
            }
            case 9: {
                str = onehunx.getString();
                break;
            }
            case 10: {
                str = twohunx.getString();
                break;
            }
            default: {
                str = normal.getString();
            }
        }
        return str;
    }

    public int removeEnergyFuel(PedestalTileEntity pedestal, int amountToRemove, boolean simulate) {
        int amountToSet = 0;
        ItemStack coin = pedestal.getCoinOnPedestal();
        int fuelLeft = this.getEnergyStored(coin);
        amountToSet = fuelLeft - amountToRemove;
        if (amountToRemove > fuelLeft) {
            amountToSet = -1;
        }
        if (!simulate) {
            if (amountToSet == -1) {
                amountToSet = 0;
            }
            this.setEnergyStored(coin, amountToSet);
            pedestal.update();
        }
        return amountToSet;
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        int fuelValue;
        if (!pedestal.hasParticleDiffuser() && !world.func_175640_z(pos) && (fuelValue = this.getEnergyStored(pedestal.getCoinOnPedestal())) >= 2500) {
            this.spawnParticleAroundPedestalBase(world, tick, pos, 1.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int fuelValue = this.getEnergyStored(pedestal.getCoinOnPedestal());
        TranslationTextComponent fuel = new TranslationTextComponent(this.func_77658_a() + ".chat_fuel");
        fuel.func_240702_b_("" + fuelValue / 2500 + "");
        fuel.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)fuel, Util.field_240973_b_);
        TranslationTextComponent energyRate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        energyRate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        energyRate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)energyRate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rfstored");
        xpstored.func_240702_b_("" + this.getEnergyStored(stack) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        tooltip.add((ITextComponent)xpstored);
        TranslationTextComponent xpcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rfcapacity");
        xpcapacity.func_240702_b_("" + this.getEnergyBuffer(stack) + "");
        xpcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)xpcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }
}

