/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalFilters;

import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.item.pedestalFilters.ItemFilterBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemFilterRestricted
extends ItemFilterBase {
    public static final Item RESTRICTIONFILTER = (Item)new ItemFilterRestricted(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "filter/filterrestriction"));

    public ItemFilterRestricted(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public int canAcceptCount(PedestalTileEntity pedestal, World world, BlockPos posPedestal, ItemStack inPedestal, ItemStack itemStackIncoming) {
        if (inPedestal.func_190926_b()) {
            ItemStack filter = pedestal.getFilterInPedestal();
            List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter);
            int range = stackCurrent.size();
            int count = 0;
            int maxIncomming = itemStackIncoming.func_77976_d();
            for (int i = 0; i < range && (count += stackCurrent.get(i).func_190916_E()) < maxIncomming; ++i) {
            }
            return count > 0 ? (count > maxIncomming ? maxIncomming : count) : 1;
        }
        return 0;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        ItemStack itemInHand;
        RayTraceResult result = p_77659_2_.func_213324_a(5.0, 0.0f, false);
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && p_77659_2_.func_213453_ef() && (itemInHand = p_77659_2_.func_184586_b(p_77659_3_)).func_77973_b() instanceof IFilterBase) {
            ItemUseContext context = new ItemUseContext(p_77659_2_, p_77659_3_, (BlockRayTraceResult)result);
            BlockRayTraceResult res = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), false);
            BlockPos posBlock = res.func_216350_a();
            List<ItemStack> buildQueue = this.buildFilterQueue(p_77659_1_, posBlock);
            if (buildQueue.size() > 0) {
                this.writeFilterQueueToNBT(itemInHand, buildQueue);
                return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
            return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
        }
        return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack filterStack = pedestal.getFilterInPedestal();
        TranslationTextComponent filterList = new TranslationTextComponent(filterStack.func_200301_q().getString());
        filterList.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)filterList, Util.field_240973_b_);
        TranslationTextComponent enchant = new TranslationTextComponent("pedestals.filters.tooltip_filterlist_count");
        enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
        player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
        TranslationTextComponent enchants = new TranslationTextComponent("1");
        List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack);
        int range = filterQueue.size();
        if (range > 0) {
            int count = 0;
            for (int i = 0; i < range && (count += filterQueue.get(i).func_190916_E()) < 64; ++i) {
            }
            enchants = new TranslationTextComponent("" + (count > 0 ? (count > 64 ? 64 : count) : 1) + "");
        }
        enchants.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent enchant = new TranslationTextComponent("pedestals.filters.tooltip_filterlist_count");
        enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
        tooltip.add((ITextComponent)enchant);
        TranslationTextComponent enchants = new TranslationTextComponent("1");
        List<ItemStack> filterQueue = this.readFilterQueueFromNBT(stack);
        int range = filterQueue.size();
        if (range > 0) {
            int count = 0;
            for (int i = 0; i < range && (count += filterQueue.get(i).func_190916_E()) < 64; ++i) {
            }
            enchants = new TranslationTextComponent("" + (count > 0 ? (count > 64 ? 64 : count) : 1) + "");
        }
        enchants.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)enchants);
    }

    public static void handleItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((itemstack, tintIndex) -> {
            if (tintIndex == 1) {
                return 65280;
            }
            return -1;
        }, new IItemProvider[]{RESTRICTIONFILTER});
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)RESTRICTIONFILTER);
    }
}

