/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.enchants.EnchantmentRegistry;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.network.PacketHandler;
import com.mowmaster.pedestals.network.PacketParticles;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeQuarry
extends ItemUpgradeBase {
    public static final Item QUARRY = (Item)new ItemUpgradeQuarry(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/quarry"));

    public ItemUpgradeQuarry(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return false;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public boolean canAcceptMagnet() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getRangeHeight(ItemStack stack) {
        return this.getHeight(stack);
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeLargest(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            ItemStack coin = pedestal.getCoinOnPedestal();
            int width = this.getAreaWidth(pedestal.getCoinOnPedestal());
            int widdth = width * 2 + 1;
            int height = this.getRangeHeight(pedestal.getCoinOnPedestal());
            int amount = this.workQueueSize(coin);
            int area = Math.multiplyExact(Math.multiplyExact(widdth, widdth), height);
            if (amount > 0) {
                float f = (float)amount / (float)area;
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    @Override
    public int intOperationalSpeedModifier(ItemStack stack) {
        int rate = 0;
        if (this.hasEnchant(stack)) {
            rate = this.intOperationalSpeedModifierOverride(stack) > 10 ? 10 : this.intOperationalSpeedModifierOverride(stack);
        }
        return rate;
    }

    @Override
    public int getOperationSpeed(ItemStack stack) {
        int intOperationalSpeed;
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                intOperationalSpeed = 128;
                break;
            }
            case 1: {
                intOperationalSpeed = 112;
                break;
            }
            case 2: {
                intOperationalSpeed = 96;
                break;
            }
            case 3: {
                intOperationalSpeed = 80;
                break;
            }
            case 4: {
                intOperationalSpeed = 64;
                break;
            }
            case 5: {
                intOperationalSpeed = 32;
                break;
            }
            case 6: {
                intOperationalSpeed = 16;
                break;
            }
            case 7: {
                intOperationalSpeed = 8;
                break;
            }
            case 8: {
                intOperationalSpeed = 4;
                break;
            }
            case 9: {
                intOperationalSpeed = 2;
                break;
            }
            case 10: {
                intOperationalSpeed = 1;
                break;
            }
            default: {
                intOperationalSpeed = 128;
            }
        }
        return intOperationalSpeed;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            BlockPos posNums;
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int rangeWidth = this.getAreaWidth(coinInPedestal);
            int rangeHeight = this.getRangeHeight(coinInPedestal);
            int speed = this.getOperationSpeed(coinInPedestal);
            BlockState pedestalState = world.func_180495_p(pedestalPos);
            Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
            int height = enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight;
            BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, rangeWidth, height);
            if (world.func_175707_a(negNums, posNums = this.getPosRangePosEntity(world, pedestalPos, rangeWidth, height)) && !pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                int val;
                AxisAlignedBB getBox;
                List itemList;
                if (this.hasMagnetEnchant(coinInPedestal) && (itemList = world.func_217357_a(ItemEntity.class, getBox = new AxisAlignedBB(negNums, posNums))).size() > 0) {
                    this.upgradeActionMagnet(pedestal, world, itemList, itemInPedestal, pedestalPos);
                }
                if ((val = this.readStoredIntTwoFromNBT(coinInPedestal)) > 0) {
                    if (world.func_82737_E() % 5L == 0L) {
                        BlockPos directionalPos = this.getPosOfBlockBelow(world, pedestalPos, 0);
                        if (!pedestal.hasParticleDiffuser()) {
                            PacketHandler.sendToNearby(world, pedestalPos, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, directionalPos.func_177958_n(), (double)directionalPos.func_177956_o(), (double)directionalPos.func_177952_p(), 145, 145, 145));
                        }
                    }
                    this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
                } else {
                    if (this.workQueueSize(coinInPedestal) <= 0) {
                        this.buildWorkQueue(pedestal, rangeWidth, rangeHeight);
                    }
                    if (this.workQueueSize(coinInPedestal) > 0) {
                        List<BlockPos> workQueue = this.readWorkQueueFromNBT(coinInPedestal);
                        if (world.func_82737_E() % (long)speed == 0L) {
                            for (int i = 0; i < workQueue.size(); ++i) {
                                BlockPos targetPos = workQueue.get(i);
                                BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                                BlockState targetBlock = world.func_180495_p(blockToMinePos);
                                if (this.canMineBlock(pedestal, blockToMinePos)) {
                                    workQueue.remove(i);
                                    this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                                    this.upgradeAction(pedestal, world, itemInPedestal, coinInPedestal, targetPos, targetBlock, pedestalPos);
                                    if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
                                    break;
                                }
                                workQueue.remove(i);
                            }
                            this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                        }
                    } else {
                        int delay = rangeWidth * rangeWidth * rangeHeight;
                        this.writeStoredIntTwoToNBT(coinInPedestal, delay < 100 ? 100 : delay);
                    }
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos blockToMinePos, BlockState blockToMine, BlockPos posOfPedestal) {
        ItemStack pick = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151046_w, 1);
        FakePlayer fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get();
        if (fakePlayer != null) {
            fakePlayer.func_174810_b(true);
            if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(posOfPedestal.func_177958_n(), posOfPedestal.func_177956_o(), posOfPedestal.func_177952_p()))) {
                fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
            }
            if (!pedestal.hasTool()) {
                pick = this.getToolDefaultEnchanted(coinInPedestal, pick);
            }
            if (!fakePlayer.func_184614_ca().equals(pick)) {
                fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, pick);
            }
            ToolType tool = blockToMine.getHarvestTool();
            int toolLevel = fakePlayer.func_184614_ca().getHarvestLevel(tool, (PlayerEntity)fakePlayer, blockToMine);
            ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            if (this.canMineBlock(pedestal, blockToMinePos, (PlayerEntity)fakePlayer) && ForgeHooks.canHarvestBlock((BlockState)blockToMine, (PlayerEntity)fakePlayer, (IBlockReader)world, (BlockPos)blockToMinePos)) {
                blockToMine.func_177230_c().func_180657_a(world, (PlayerEntity)fakePlayer, blockToMinePos, blockToMine, null, fakePlayer.func_184614_ca());
                blockToMine.func_177230_c().func_176208_a(world, blockToMinePos, blockToMine, (PlayerEntity)fakePlayer);
                int expdrop = blockToMine.func_177230_c().getExpDrop(blockToMine, (IWorldReader)world, blockToMinePos, EnchantmentHelper.func_82781_a((ItemStack)fakePlayer.func_184614_ca()).containsKey(Enchantments.field_185308_t) ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)fakePlayer.func_184614_ca()) : 0, EnchantmentHelper.func_82781_a((ItemStack)fakePlayer.func_184614_ca()).containsKey(Enchantments.field_185306_r) ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)fakePlayer.func_184614_ca()) : 0);
                if (expdrop > 0) {
                    blockToMine.func_177230_c().func_180637_b(sworld, posOfPedestal, expdrop);
                }
                world.func_217377_a(blockToMinePos, false);
                if (!pedestal.hasParticleDiffuser()) {
                    PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR_CENTERED, blockToMinePos.func_177958_n(), (double)blockToMinePos.func_177956_o(), (double)blockToMinePos.func_177952_p(), 255, 164, 0));
                }
            }
        }
    }

    @Override
    public boolean passesFilter(World world, BlockPos posPedestal, Block blockIn) {
        Item filterInPedestal;
        PedestalTileEntity pedestal;
        boolean returner = true;
        if (world.func_175625_s(posPedestal) instanceof PedestalTileEntity && (pedestal = (PedestalTileEntity)world.func_175625_s(posPedestal)).hasFilter() && (filterInPedestal = pedestal.getFilterInPedestal().func_77973_b()) instanceof IFilterBase) {
            returner = ((IFilterBase)filterInPedestal).canAcceptItem(pedestal, new ItemStack((IItemProvider)blockIn));
        }
        return returner;
    }

    @Override
    public String getOperationSpeedString(ItemStack stack) {
        TranslationTextComponent zero = new TranslationTextComponent("pedestals.quarry_tooltips.speed_0");
        TranslationTextComponent one = new TranslationTextComponent("pedestals.quarry_tooltips.speed_1");
        TranslationTextComponent two = new TranslationTextComponent("pedestals.quarry_tooltips.speed_2");
        TranslationTextComponent three = new TranslationTextComponent("pedestals.quarry_tooltips.speed_3");
        TranslationTextComponent four = new TranslationTextComponent("pedestals.quarry_tooltips.speed_4");
        TranslationTextComponent five = new TranslationTextComponent("pedestals.quarry_tooltips.speed_5");
        TranslationTextComponent six = new TranslationTextComponent("pedestals.quarry_tooltips.speed_6");
        TranslationTextComponent seven = new TranslationTextComponent("pedestals.quarry_tooltips.speed_7");
        TranslationTextComponent eight = new TranslationTextComponent("pedestals.quarry_tooltips.speed_8");
        TranslationTextComponent nine = new TranslationTextComponent("pedestals.quarry_tooltips.speed_9");
        TranslationTextComponent ten = new TranslationTextComponent("pedestals.quarry_tooltips.speed_10");
        String str = zero.getString();
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                str = zero.getString();
                break;
            }
            case 1: {
                str = one.getString();
                break;
            }
            case 2: {
                str = two.getString();
                break;
            }
            case 3: {
                str = three.getString();
                break;
            }
            case 4: {
                str = four.getString();
                break;
            }
            case 5: {
                str = five.getString();
                break;
            }
            case 6: {
                str = six.getString();
                break;
            }
            case 7: {
                str = seven.getString();
                break;
            }
            case 8: {
                str = eight.getString();
                break;
            }
            case 9: {
                str = nine.getString();
                break;
            }
            case 10: {
                str = ten.getString();
                break;
            }
            default: {
                str = zero.getString();
            }
        }
        return str;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        int s4 = this.getRangeHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + s4 + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent btm = new TranslationTextComponent(this.func_77658_a() + ".chat_btm");
        btm.func_240702_b_("" + (this.workQueueSize(stack) > 0 ? this.workQueueSize(stack) : 0) + "");
        btm.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)btm, Util.field_240973_b_);
        ItemStack toolStack = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151046_w);
        TranslationTextComponent tool = new TranslationTextComponent(this.func_77658_a() + ".chat_tool");
        tool.func_230529_a_(toolStack.func_200301_q());
        tool.func_240699_a_(TextFormatting.BLUE);
        player.func_145747_a((ITextComponent)tool, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)(pedestal.hasTool() ? pedestal.getToolOnPedestal() : stack));
        if (this.hasAdvancedInventoryTargeting(stack)) {
            map.put(EnchantmentRegistry.ADVANCED, 1);
        }
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int s3 = this.getAreaWidth(stack);
        int s4 = this.getRangeHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + s4 + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        area.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)area);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)QUARRY);
    }
}

