/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeImport
extends ItemUpgradeBase {
    public static final Item IMPORT = (Item)new ItemUpgradeImport(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/import"));

    public ItemUpgradeImport(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(pedestal, world, pedestalPos, coinInPedestal);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, BlockPos posOfPedestal, ItemStack coinInPedestal) {
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        int transferRate = this.getItemTransferRate(coinInPedestal);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        LazyOptional<IItemHandler> cap = ItemUpgradeImport.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
            cap = ItemUpgradeImport.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if (!this.isInventoryEmpty(cap) && cap.isPresent()) {
            int i;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            if (invToPullFrom instanceof PedestalTileEntity) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null && (i = this.getNextSlotWithItemsCapFiltered(pedestal, cap, this.getStackInPedestal(world, posOfPedestal))) >= 0) {
                int maxStackSizeAllowedInPedestal = 0;
                int roomLeftInPedestal = 0;
                itemFromInv = handler.getStackInSlot(i);
                ItemStack itemFromPedestal = this.getStackInPedestal(world, posOfPedestal);
                if (itemFromInv != null && !itemFromInv.func_190926_b() && itemFromInv.func_77973_b() != Items.field_190931_a) {
                    maxStackSizeAllowedInPedestal = itemFromPedestal.func_190926_b() || itemFromPedestal.equals(ItemStack.field_190927_a) ? 64 : itemFromPedestal.func_77976_d();
                    roomLeftInPedestal = maxStackSizeAllowedInPedestal - itemFromPedestal.func_190916_E();
                    int itemCountInInv = itemFromInv.func_190916_E();
                    int allowedTransferRate = transferRate;
                    if (roomLeftInPedestal < transferRate) {
                        allowedTransferRate = roomLeftInPedestal;
                    }
                    if (itemCountInInv < allowedTransferRate) {
                        allowedTransferRate = itemCountInInv;
                    }
                    ItemStack copyIncoming = itemFromInv.func_77946_l();
                    copyIncoming.func_190920_e(allowedTransferRate);
                    TileEntity pedestalInv = world.func_175625_s(posOfPedestal);
                    if (pedestalInv instanceof PedestalTileEntity && !handler.extractItem(i, allowedTransferRate, true).func_190926_b()) {
                        handler.extractItem(i, allowedTransferRate, false);
                        ((PedestalTileEntity)pedestalInv).addItem(copyIncoming);
                    }
                }
            }
        }
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            TileEntity pedestalInv;
            ItemStack getItemStack = ((ItemEntity)entityIn).func_92059_d();
            ItemStack itemFromPedestal = this.getStackInPedestal(world, posPedestal);
            if (itemFromPedestal.func_190926_b() && this.canThisPedestalReceiveItemStack(tilePedestal, world, posPedestal, getItemStack) && (pedestalInv = world.func_175625_s(posPedestal)) instanceof PedestalTileEntity) {
                entityIn.func_70106_y();
                ((PedestalTileEntity)pedestalInv).addItem(getItemStack);
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)IMPORT);
    }
}

