/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.crafting.CalculateColor;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseFluid;
import com.mowmaster.pedestals.network.PacketHandler;
import com.mowmaster.pedestals.network.PacketParticles;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeFluidPump
extends ItemUpgradeBaseFluid {
    public static final Item FLUIDPUMP = (Item)new ItemUpgradeFluidPump(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fluidpump"));

    public ItemUpgradeFluidPump(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeLarge(stack);
    }

    public void placeBlock(PedestalTileEntity pedestal, BlockPos targetPos) {
        World world = pedestal.func_145831_w();
        BlockPos pedPos = pedestal.func_174877_v();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        ItemStack coinOnPedestal = pedestal.getCoinOnPedestal();
        if (!itemInPedestal.func_190926_b()) {
            FakePlayer fakePlayer;
            Block blockBelow = world.func_180495_p(targetPos).func_177230_c();
            Item singleItemInPedestal = itemInPedestal.func_77973_b();
            if (blockBelow.equals(Blocks.field_150350_a) && !singleItemInPedestal.equals(Items.field_190931_a) && singleItemInPedestal instanceof BlockItem && ((BlockItem)singleItemInPedestal).func_179223_d() instanceof Block && !itemInPedestal.func_190926_b() && itemInPedestal.func_77973_b() instanceof BlockItem && ((BlockItem)itemInPedestal.func_77973_b()).func_179223_d() instanceof Block && (fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get()) != null) {
                BlockItemUseContext blockContext;
                ActionResultType result;
                fakePlayer.func_174810_b(true);
                if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(pedPos.func_177958_n(), pedPos.func_177956_o(), pedPos.func_177952_p()))) {
                    fakePlayer.func_70107_b((double)pedPos.func_177958_n(), (double)pedPos.func_177956_o(), (double)pedPos.func_177952_p());
                }
                if ((result = ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)(blockContext = new BlockItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, itemInPedestal.func_77946_l(), new BlockRayTraceResult(Vector3d.field_186680_a, this.getPedestalFacing(world, pedPos), targetPos, false))))) == ActionResultType.CONSUME) {
                    this.removeFromPedestal(world, pedPos, 1);
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                }
            }
        }
    }

    public int getWidth(ItemStack stack) {
        return this.getAreaModifier(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getWidth(coin);
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            ItemStack coin = pedestal.getCoinOnPedestal();
            int width = this.getWidth(pedestal.getCoinOnPedestal());
            int widdth = width * 2 + 1;
            int height = this.getHeight(pedestal.getCoinOnPedestal());
            int amount = this.workQueueSize(coin);
            int area = Math.multiplyExact(Math.multiplyExact(widdth, widdth), height);
            if (amount > 0) {
                float f = (float)amount / (float)area;
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFluidValue = this.getFluidbuffer(coinInPedestal);
            if (!this.hasMaxFluidSet(coinInPedestal) || this.readMaxFluidFromNBT(coinInPedestal) != getMaxFluidValue) {
                this.setMaxFluid(coinInPedestal, getMaxFluidValue);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                BlockPos posNums;
                if (this.hasFluidInCoin(coinInPedestal) && world.func_82737_E() % (long)speed == 0L) {
                    this.upgradeActionSendFluid(pedestal);
                }
                int rangeWidth = this.getWidth(coinInPedestal);
                int rangeHeight = this.getHeight(coinInPedestal);
                BlockState pedestalState = world.func_180495_p(pedestalPos);
                Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
                BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight);
                if (world.func_175707_a(negNums, posNums = this.getPosRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight))) {
                    int val = this.readStoredIntTwoFromNBT(coinInPedestal);
                    if (val > 0) {
                        this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
                    } else {
                        if (this.workQueueSize(coinInPedestal) <= 0) {
                            this.buildWorkQueue(pedestal, rangeWidth, rangeHeight);
                        }
                        if (this.workQueueSize(coinInPedestal) > 0) {
                            if (this.availableFluidSpaceInCoin(coinInPedestal) >= 1000 || this.getFluidStored(coinInPedestal).isEmpty()) {
                                List<BlockPos> workQueue = this.readWorkQueueFromNBT(coinInPedestal);
                                if (world.func_82737_E() % (long)speed == 0L) {
                                    for (int i = 0; i < workQueue.size(); ++i) {
                                        BlockPos targetPos = workQueue.get(i);
                                        BlockPos blockToPumpPos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                                        BlockState targetFluidState = world.func_180495_p(blockToPumpPos);
                                        Block targetFluidBlock = targetFluidState.func_177230_c();
                                        if (this.canMineBlock(pedestal, blockToPumpPos)) {
                                            workQueue.remove(i);
                                            this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                                            this.upgradeAction(pedestal, targetPos, itemInPedestal, coinInPedestal);
                                            if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
                                            break;
                                        }
                                        workQueue.remove(i);
                                    }
                                    this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                                }
                            }
                        } else {
                            this.writeStoredIntTwoToNBT(coinInPedestal, (rangeWidth * 2 + 1) * 20 + 20);
                        }
                    }
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, BlockPos targetPos, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        IFluidBlock fluidBlock;
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        BlockState targetFluidState = world.func_180495_p(targetPos);
        Block targetFluidBlock = targetFluidState.func_177230_c();
        FluidStack fluidToStore = FluidStack.EMPTY;
        if (targetFluidBlock instanceof FlowingFluidBlock && (Integer)targetFluidState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
            FlowingFluid fluid = ((FlowingFluidBlock)targetFluidBlock).getFluid();
            FluidStack fluidToPickup = new FluidStack((Fluid)fluid, 1000);
            if (this.canAddFluidToCoin(pedestal, coinInPedestal, fluidToPickup) && !(fluidToStore = fluidToPickup.copy()).isEmpty() && this.addFluid(pedestal, coinInPedestal, fluidToStore, true)) {
                world.func_180501_a(targetPos, Blocks.field_150350_a.func_176223_P(), 11);
                this.addFluid(pedestal, coinInPedestal, fluidToStore, false);
                if (itemInPedestal.func_190926_b()) {
                    int[] rgb = CalculateColor.getRGBColorFromInt(fluidToStore.getFluid().getAttributes().getColor());
                    if (!pedestal.hasParticleDiffuser()) {
                        PacketHandler.sendToNearby(world, pedestalPos, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR_CENTERED, targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), rgb[0], rgb[1], rgb[2]));
                    }
                } else {
                    this.placeBlock(pedestal, targetPos);
                }
            }
        } else if (targetFluidBlock instanceof IFluidBlock && (fluidBlock = (IFluidBlock)targetFluidBlock).canDrain(world, targetPos) && !(fluidToStore = fluidBlock.drain(world, targetPos, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && this.addFluid(pedestal, coinInPedestal, fluidToStore, true)) {
            fluidToStore = fluidBlock.drain(world, targetPos, IFluidHandler.FluidAction.EXECUTE);
            this.addFluid(pedestal, coinInPedestal, fluidToStore, false);
            if (itemInPedestal.func_190926_b()) {
                int[] rgb = CalculateColor.getRGBColorFromInt(fluidToStore.getFluid().getAttributes().getColor());
                if (!pedestal.hasParticleDiffuser()) {
                    PacketHandler.sendToNearby(world, pedestalPos, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR_CENTERED, targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), rgb[0], rgb[1], rgb[2]));
                }
            } else {
                this.placeBlock(pedestal, targetPos);
            }
        }
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        BlockPos blockToPumpPos;
        World world = pedestal.func_145831_w();
        BlockState targetFluidState = world.func_180495_p(blockToPumpPos = new BlockPos(blockToMinePos.func_177958_n(), blockToMinePos.func_177956_o(), blockToMinePos.func_177952_p()));
        Block targetFluidBlock = targetFluidState.func_177230_c();
        if (targetFluidBlock instanceof FlowingFluidBlock && (Integer)targetFluidState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0 || targetFluidBlock instanceof IFluidBlock) {
            FluidStack fluidToPickup = FluidStack.EMPTY;
            if (targetFluidBlock instanceof FlowingFluidBlock && (Integer)targetFluidState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                FlowingFluid fluid = ((FlowingFluidBlock)targetFluidBlock).getFluid();
                fluidToPickup = new FluidStack((Fluid)fluid, 1000);
            } else if (targetFluidBlock instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)targetFluidBlock;
                fluidToPickup = new FluidStack(fluidBlock.getFluid(), 1000);
            }
            return this.fluidMatchFilter(pedestal, fluidToPickup);
        }
        return false;
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        BlockPos blockToPumpPos;
        World world = pedestal.func_145831_w();
        BlockState targetFluidState = world.func_180495_p(blockToPumpPos = new BlockPos(blockToMinePos.func_177958_n(), blockToMinePos.func_177956_o(), blockToMinePos.func_177952_p()));
        Block targetFluidBlock = targetFluidState.func_177230_c();
        if (targetFluidBlock instanceof FlowingFluidBlock && (Integer)targetFluidState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0 || targetFluidBlock instanceof IFluidBlock) {
            FluidStack fluidToPickup = FluidStack.EMPTY;
            if (targetFluidBlock instanceof FlowingFluidBlock && (Integer)targetFluidState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                FlowingFluid fluid = ((FlowingFluidBlock)targetFluidBlock).getFluid();
                fluidToPickup = new FluidStack((Fluid)fluid, 1000);
            } else if (targetFluidBlock instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)targetFluidBlock;
                fluidToPickup = new FluidStack(fluidBlock.getFluid(), 1000);
            }
            return this.fluidMatchFilter(pedestal, fluidToPickup);
        }
        return false;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getWidth(stack);
        int s4 = this.getHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + s4 + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)fluid, Util.field_240973_b_);
        }
        TranslationTextComponent btm = new TranslationTextComponent(this.func_77658_a() + ".chat_btm");
        btm.func_240702_b_("" + (this.workQueueSize(stack) > 0 ? this.workQueueSize(stack) : 0) + "");
        btm.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)btm, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240702_b_(fluidLabel.getString());
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            tooltip.add((ITextComponent)fluid);
        }
        int s3 = this.getWidth(stack);
        int s4 = this.getHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + s4 + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)area);
        TranslationTextComponent fluidcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidcapacity");
        fluidcapacity.func_240702_b_("" + this.getFluidbuffer(stack) + "");
        fluidcapacity.func_240702_b_(fluidLabel.getString());
        fluidcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)fluidcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240702_b_(fluidLabel.getString());
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)FLUIDPUMP);
    }
}

