/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.ItemCraftingPlaceholder;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseFluid;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeFluidCrafter
extends ItemUpgradeBaseFluid {
    public static final Item FLUIDCRAFTER_ONE = (Item)new ItemUpgradeFluidCrafter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fluidcrafter1"));
    public static final Item FLUIDCRAFTER_TWO = (Item)new ItemUpgradeFluidCrafter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fluidcrafter2"));
    public static final Item FLUIDCRAFTER_THREE = (Item)new ItemUpgradeFluidCrafter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fluidcrafter3"));

    public ItemUpgradeFluidCrafter(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public int getItemTransferRate(ItemStack stack) {
        int itemsPerSmelt = 1;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                itemsPerSmelt = 1;
                break;
            }
            case 1: {
                itemsPerSmelt = 2;
                break;
            }
            case 2: {
                itemsPerSmelt = 4;
                break;
            }
            case 3: {
                itemsPerSmelt = 8;
                break;
            }
            case 4: {
                itemsPerSmelt = 12;
                break;
            }
            case 5: {
                itemsPerSmelt = 16;
                break;
            }
            default: {
                itemsPerSmelt = 1;
            }
        }
        return itemsPerSmelt;
    }

    @Override
    public int getGridSize(ItemStack itemStack) {
        int gridSize = 0;
        gridSize = itemStack.func_77973_b().equals(FLUIDCRAFTER_ONE) ? 1 : (itemStack.func_77973_b().equals(FLUIDCRAFTER_TWO) ? 2 : (itemStack.func_77973_b().equals(FLUIDCRAFTER_THREE) ? 3 : 1));
        return gridSize;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int storedTwo = this.readStoredIntTwoFromNBT(coinInPedestal);
            int craftingCount = this.readCraftingQueueFromNBT(coinInPedestal).size();
            int getMaxFluidValue = this.getFluidbuffer(coinInPedestal);
            if (!this.hasMaxFluidSet(coinInPedestal) || this.readMaxFluidFromNBT(coinInPedestal) != getMaxFluidValue) {
                this.setMaxFluid(coinInPedestal, getMaxFluidValue);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                if (world.func_82737_E() % (long)speed == 0L) {
                    this.upgradeAction(pedestal);
                }
                if (storedTwo >= craftingCount && world.func_82737_E() % 100L == 0L) {
                    this.onPedestalNeighborChanged(pedestal);
                }
            }
        }
    }

    public static IRecipe<CraftingInventory> findRecipe(CraftingInventory inv, World world) {
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inv, world).orElse(null);
    }

    public void upgradeAction(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coin = pedestal.getCoinOnPedestal();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        int gridSize = this.getGridSize(coin);
        int intBatchCraftingSize = this.getItemTransferRate(coin);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        BlockPos posInventory = this.getPosOfBlockBelow(world, pedestalPos, 1);
        int intGridCount = gridSize * gridSize;
        List<ItemStack> stackCurrent = this.readInventoryQueueFromNBT(coin);
        List<ItemStack> craftingCurrent = this.readCraftingQueueFromNBT(coin);
        LazyOptional<IItemHandler> cap = ItemUpgradeFluidCrafter.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, pedestalPos), true);
        if (cap.isPresent()) {
            if (itemInPedestal.func_190926_b() && !this.isInventoryEmpty(cap)) {
                IItemHandler handler = (IItemHandler)cap.orElse(null);
                TileEntity invToPullFrom = world.func_175625_s(posInventory);
                int intInventorySlotCount = handler.getSlots();
                if (!(this.hasAdvancedInventoryTargeting(coin) && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
                    itemFromInv = ItemStack.field_190927_a;
                } else if (handler != null) {
                    if (stackCurrent.size() != intInventorySlotCount || this.checkFirstNine(cap, stackCurrent)) {
                        List<ItemStack> stackIn = this.buildInventoryQueue(pedestal);
                        this.writeInventoryQueueToNBT(coin, stackIn);
                        this.buildAndWriteCraftingQueue(pedestal, stackIn);
                    }
                    if (intInventorySlotCount >= intGridCount) {
                        int intGetNextIteration = this.getStoredInt(coin);
                        if (intGetNextIteration == 0) {
                            intGetNextIteration = 1;
                        }
                        if (craftingCurrent.size() > 0) {
                            ItemStack getRecipe;
                            int intSlotToStartFrom = intGetNextIteration * intGridCount - intGridCount;
                            int intSlotToEndBefore = intGetNextIteration * intGridCount;
                            if (intSlotToEndBefore > intInventorySlotCount) {
                                intGetNextIteration = 1;
                                intSlotToStartFrom = intGetNextIteration * intGridCount - intGridCount;
                                intSlotToEndBefore = intGetNextIteration * intGridCount;
                            }
                            if (!(getRecipe = craftingCurrent.get(intGetNextIteration - 1).func_77946_l()).func_190926_b()) {
                                int fluidBucketsNeeded = 0;
                                for (int s = intSlotToStartFrom; s < intSlotToEndBefore; ++s) {
                                    ItemStack getIngredientStack = stackCurrent.get(s);
                                    int stackSize = getIngredientStack.func_190916_E();
                                    if (getIngredientStack.func_77973_b().hasContainerItem(getIngredientStack)) {
                                        if (this.doItemsMatch(getIngredientStack.func_77973_b().getContainerItem(getIngredientStack), getIngredientStack)) {
                                            int damage;
                                            int maxdamage;
                                            int durabilityCurrent;
                                            if (!getIngredientStack.func_77984_f() || (durabilityCurrent = (maxdamage = getIngredientStack.func_77958_k()) - (damage = getIngredientStack.func_77952_i())) >= intBatchCraftingSize) continue;
                                            intBatchCraftingSize = durabilityCurrent;
                                            continue;
                                        }
                                        if (getIngredientStack.func_77976_d() < intBatchCraftingSize) {
                                            intBatchCraftingSize = getIngredientStack.func_77976_d();
                                            continue;
                                        }
                                        if (stackSize >= intBatchCraftingSize) continue;
                                        intBatchCraftingSize = stackSize - 1;
                                        continue;
                                    }
                                    if (getIngredientStack.func_190926_b() || getIngredientStack.func_77973_b().equals(ItemCraftingPlaceholder.PLACEHOLDER)) continue;
                                    if (getIngredientStack.func_77973_b().equals(ItemCraftingPlaceholder.PLACEHOLDER_BUCKET)) {
                                        ++fluidBucketsNeeded;
                                        continue;
                                    }
                                    if (stackSize < intBatchCraftingSize) {
                                        intBatchCraftingSize = stackSize - 1;
                                        continue;
                                    }
                                    if (stackSize != 1) continue;
                                    intBatchCraftingSize = 0;
                                }
                                int fluidStoredAmount = this.getFluidStored(coin).getAmount();
                                if (1000 * fluidBucketsNeeded * intBatchCraftingSize > fluidStoredAmount) {
                                    intBatchCraftingSize = Math.floorDiv(fluidStoredAmount, 1000 * fluidBucketsNeeded);
                                }
                                if (intBatchCraftingSize > 0) {
                                    ArrayList<ItemStack> extractedItemsList = new ArrayList<ItemStack>();
                                    ItemStack returnedStack = ItemStack.field_190927_a;
                                    int intRecipeResultCount = getRecipe.func_190916_E();
                                    int intBatchCraftedAmount = intRecipeResultCount * intBatchCraftingSize;
                                    if (intBatchCraftedAmount > 64) {
                                        intBatchCraftingSize = Math.floorDiv(64, intRecipeResultCount);
                                    }
                                    for (int s = intSlotToStartFrom; s < intSlotToEndBefore; ++s) {
                                        ItemStack stackInHandler = handler.getStackInSlot(s);
                                        ItemStack stackInRecipe = stackCurrent.get(s);
                                        if (stackInRecipe.func_190926_b() || stackInRecipe.func_77973_b().equals(ItemCraftingPlaceholder.PLACEHOLDER)) continue;
                                        if (stackInRecipe.func_77973_b().equals(ItemCraftingPlaceholder.PLACEHOLDER_BUCKET)) {
                                            this.removeFluid(pedestal, coin, fluidBucketsNeeded * 1000 * intBatchCraftingSize, false);
                                            continue;
                                        }
                                        if (stackInRecipe.func_77973_b().hasContainerItem(stackInRecipe)) {
                                            ItemStack queueStack;
                                            ItemStack container = stackInRecipe.func_77973_b().getContainerItem(stackInRecipe);
                                            if (!this.hasAdvancedInventoryTargeting(coin)) {
                                                if (!world.field_72995_K) {
                                                    world.func_217376_c((Entity)new ItemEntity(world, (double)this.getPosOfBlockBelow(world, pedestalPos, -1).func_177958_n() + 0.5, (double)this.getPosOfBlockBelow(world, pedestalPos, -1).func_177956_o() + 0.5, (double)this.getPosOfBlockBelow(world, pedestalPos, -1).func_177952_p() + 0.5, container));
                                                }
                                                queueStack = stackCurrent.get(s);
                                                queueStack.func_190918_g(intBatchCraftingSize);
                                                stackCurrent.set(s, queueStack);
                                                returnedStack = handler.extractItem(s, intBatchCraftingSize, false);
                                                if (returnedStack.func_190926_b()) continue;
                                                extractedItemsList.add(returnedStack);
                                                continue;
                                            }
                                            if (!container.func_77973_b().equals(stackInRecipe.func_77973_b())) {
                                                if (!world.field_72995_K) {
                                                    world.func_217376_c((Entity)new ItemEntity(world, (double)this.getPosOfBlockBelow(world, pedestalPos, -1).func_177958_n() + 0.5, (double)this.getPosOfBlockBelow(world, pedestalPos, -1).func_177956_o() + 0.5, (double)this.getPosOfBlockBelow(world, pedestalPos, -1).func_177952_p() + 0.5, container));
                                                }
                                                queueStack = stackCurrent.get(s);
                                                queueStack.func_190918_g(intBatchCraftingSize);
                                                stackCurrent.set(s, queueStack);
                                                returnedStack = handler.extractItem(s, intBatchCraftingSize, false);
                                                if (!returnedStack.func_190926_b()) {
                                                    extractedItemsList.add(returnedStack);
                                                }
                                            }
                                            if (!(queueStack = stackCurrent.get(s)).func_77984_f()) continue;
                                            if (queueStack.func_77952_i() > queueStack.func_77958_k()) {
                                                stackCurrent.set(s, ItemStack.field_190927_a);
                                                returnedStack = handler.extractItem(s, intBatchCraftingSize, false);
                                                if (returnedStack.func_190926_b()) continue;
                                                extractedItemsList.add(returnedStack);
                                                continue;
                                            }
                                            int damage = queueStack.func_77952_i();
                                            queueStack.func_196085_b(damage + 1);
                                            stackCurrent.set(s, queueStack);
                                            handler.getStackInSlot(s).func_196085_b(queueStack.func_77952_i());
                                            continue;
                                        }
                                        ItemStack queueStack = stackCurrent.get(s);
                                        queueStack.func_190918_g(intBatchCraftingSize);
                                        stackCurrent.set(s, queueStack);
                                        returnedStack = handler.extractItem(s, intBatchCraftingSize, false);
                                        if (returnedStack.func_190926_b()) continue;
                                        extractedItemsList.add(returnedStack);
                                    }
                                    if (extractedItemsList.size() > 0) {
                                        getRecipe.func_190920_e(intBatchCraftedAmount);
                                        if (!pedestal.hasMuffler()) {
                                            world.func_184148_a((PlayerEntity)null, (double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), SoundEvents.field_187621_J, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                        }
                                        this.addToPedestal(world, pedestalPos, getRecipe);
                                        this.onPedestalNeighborChanged(pedestal);
                                        this.writeStoredIntToNBT(coin, intGetNextIteration + 1);
                                    }
                                } else {
                                    this.writeStoredIntToNBT(coin, intGetNextIteration + 1);
                                    this.writeStoredIntTwoToNBT(coin, this.readStoredIntTwoFromNBT(coin) + 1);
                                }
                            } else {
                                this.writeStoredIntToNBT(coin, intGetNextIteration + 1);
                                this.writeStoredIntTwoToNBT(coin, this.readStoredIntTwoFromNBT(coin) + 1);
                            }
                        } else {
                            this.writeStoredIntToNBT(coin, intGetNextIteration + 1);
                            this.writeStoredIntTwoToNBT(coin, this.readStoredIntTwoFromNBT(coin) + 1);
                        }
                    }
                } else {
                    if (craftingCurrent.size() > 0) {
                        this.removeCraftingQueue(coin);
                    }
                    if (stackCurrent.size() > 0) {
                        this.removeInventoryQueue(coin);
                    }
                }
            }
        } else {
            if (craftingCurrent.size() > 0) {
                this.removeCraftingQueue(coin);
            }
            if (stackCurrent.size() > 0) {
                this.removeInventoryQueue(coin);
            }
        }
    }

    private boolean checkFirstNine(LazyOptional<IItemHandler> cap, List<ItemStack> queue) {
        IItemHandler handler;
        boolean returner = false;
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null && handler.getSlots() == queue.size()) {
            int checksize = handler.getSlots() >= 9 ? 9 : handler.getSlots();
            int checker = 0;
            for (int i = 0; i < checksize; ++i) {
                if (!handler.getStackInSlot(i).equals(queue.get(i))) continue;
                ++checker;
            }
            if (checker == checksize) {
                returner = true;
            }
        }
        return returner;
    }

    @Override
    public void onPedestalNeighborChanged(PedestalTileEntity pedestal) {
        List<ItemStack> stackCurrent;
        ItemStack coin = pedestal.getCoinOnPedestal();
        List<ItemStack> stackIn = this.buildInventoryQueue(pedestal);
        if (!this.doInventoryQueuesMatch(stackIn, stackCurrent = this.readInventoryQueueFromNBT(coin))) {
            this.writeInventoryQueueToNBT(coin, stackIn);
            this.writeStoredIntTwoToNBT(coin, 0);
            this.buildAndWriteCraftingQueue(pedestal, stackIn);
        } else {
            this.writeInventoryQueueToNBT(coin, stackIn);
            this.writeStoredIntTwoToNBT(coin, 0);
        }
    }

    @Override
    public void notifyTransferUpdate(PedestalTileEntity receiverTile) {
        ItemStack coin = receiverTile.getCoinOnPedestal();
        if (this.readStoredIntTwoFromNBT(coin) > 0) {
            this.writeStoredIntTwoToNBT(coin, 0);
            List<ItemStack> invQue = this.readInventoryQueueFromNBT(coin);
            this.buildAndWriteCraftingQueue(receiverTile, invQue);
        }
    }

    @Override
    public void buildAndWriteCraftingQueue(PedestalTileEntity pedestal, List<ItemStack> inventoryQueue) {
        World world = pedestal.func_145831_w();
        ItemStack coin = pedestal.getCoinOnPedestal();
        int gridSize = this.getGridSize(coin);
        int intGridCount = gridSize * gridSize;
        List<ItemStack> invQueue = inventoryQueue;
        int recipeCount = Math.floorDiv(invQueue.size(), intGridCount);
        ArrayList<ItemStack> recipeQueue = new ArrayList<ItemStack>();
        CraftingInventory craft = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, gridSize, gridSize);
        for (int r = 1; r <= recipeCount; ++r) {
            for (int s = 0; s < intGridCount; ++s) {
                int getActualIndex = r * intGridCount - intGridCount + s;
                ItemStack getStack = invQueue.get(getActualIndex);
                if (getStack.func_190926_b() || getStack.func_77973_b().equals(ItemCraftingPlaceholder.PLACEHOLDER)) {
                    craft.func_70299_a(s, ItemStack.field_190927_a);
                    continue;
                }
                if (getStack.func_77973_b().equals(ItemCraftingPlaceholder.PLACEHOLDER_BUCKET)) {
                    ItemStack bucketStack = new ItemStack((IItemProvider)Items.field_221803_eL);
                    if (this.removeFluid(pedestal, coin, 1000, true)) {
                        FluidStack fluidToBucket = this.getFluidStored(coin);
                        Item bucket = fluidToBucket.getFluid().func_204524_b();
                        bucketStack = new ItemStack((IItemProvider)bucket);
                    } else {
                        this.writeStoredIntTwoToNBT(coin, 1);
                    }
                    craft.func_70299_a(s, bucketStack);
                    continue;
                }
                if (getStack.func_77976_d() == 1 || getStack.func_77984_f()) {
                    craft.func_70299_a(s, getStack);
                    continue;
                }
                if (getStack.func_190916_E() <= 0) continue;
                craft.func_70299_a(s, getStack);
            }
            if (craft.func_70302_i_() < intGridCount) continue;
            IRecipe<CraftingInventory> recipe = ItemUpgradeFluidCrafter.findRecipe(craft, world);
            if (recipe != null && recipe.func_77569_a((IInventory)craft, world)) {
                ItemStack stackRecipeResult = recipe.func_77572_b((IInventory)craft);
                recipeQueue.add(stackRecipeResult);
                continue;
            }
            recipeQueue.add(ItemStack.field_190927_a);
        }
        this.writeCraftingQueueToNBT(coin, recipeQueue);
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        List<ItemStack> list;
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)fluid, Util.field_240973_b_);
        }
        if ((list = this.readCraftingQueueFromNBT(stack)).size() > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_recipes");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (int i = 0; i < list.size(); ++i) {
                TranslationTextComponent enchants = new TranslationTextComponent(list.get(i).func_190926_b() ? " - " : " - " + list.get(i).func_200301_q().getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            tooltip.add((ITextComponent)fluid);
        }
        TranslationTextComponent fluidcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidcapacity");
        fluidcapacity.func_240702_b_("" + this.getFluidbuffer(stack) + "");
        fluidcapacity.func_240702_b_(fluidLabel.getString());
        fluidcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)fluidcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getItemTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)FLUIDCRAFTER_ONE);
        event.getRegistry().register((IForgeRegistryEntry)FLUIDCRAFTER_TWO);
        event.getRegistry().register((IForgeRegistryEntry)FLUIDCRAFTER_THREE);
    }
}

