/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeFan
extends ItemUpgradeBase {
    public static final Item FAN = (Item)new ItemUpgradeFan(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fan"));

    public ItemUpgradeFan(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        return this.getAreaModifier(stack);
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeMedium(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    protected void useFanOnEntities(PedestalTileEntity pedestal, Block filterBlock, double speed, AxisAlignedBB getBox) {
        World world = pedestal.func_145831_w();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        List entityList = world.func_217357_a(LivingEntity.class, getBox);
        if (entityList.size() == 0) {
            this.writeStoredIntToNBT(coinInPedestal, 0);
        }
        if (entityList.size() > 0) {
            if (this.readStoredIntTwoFromNBT(coinInPedestal) != entityList.size()) {
                this.writeStoredIntTwoToNBT(coinInPedestal, entityList.size());
                pedestal.update();
            }
            BlockState state = world.func_180495_p(posOfPedestal);
            Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            for (LivingEntity entity : entityList) {
                LivingEntity getEntity = this.getTargetEntity(filterBlock, entity);
                if (getEntity == null) continue;
                if (getEntity instanceof PlayerEntity) {
                    if (!((PlayerEntity)getEntity).field_71075_bZ.field_75100_b && !((PlayerEntity)getEntity).func_213453_ef()) {
                        this.addMotion(world, posOfPedestal, speed, enumfacing, getEntity);
                        this.writeStoredIntToNBT(coinInPedestal, 1);
                    }
                } else {
                    this.addMotion(world, posOfPedestal, speed, enumfacing, getEntity);
                    this.writeStoredIntToNBT(coinInPedestal, 1);
                }
                if (enumfacing != Direction.UP) continue;
                getEntity.field_70143_R = 0.0f;
            }
        }
    }

    protected void useFanOnEntitiesAdvanced(PedestalTileEntity pedestal, Block filterBlock, double speed, AxisAlignedBB getBox) {
        World world = pedestal.func_145831_w();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        List entityList = world.func_217357_a(Entity.class, getBox);
        if (entityList.size() == 0) {
            this.writeStoredIntToNBT(coinInPedestal, 0);
        }
        if (entityList.size() > 0) {
            if (this.readStoredIntTwoFromNBT(coinInPedestal) != entityList.size()) {
                this.writeStoredIntTwoToNBT(coinInPedestal, entityList.size());
                pedestal.update();
            }
            BlockState state = world.func_180495_p(posOfPedestal);
            Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            for (Entity entity : entityList) {
                Entity getEntity = this.getTargetEntityAdvanced(filterBlock, entity);
                if (getEntity == null) continue;
                if (getEntity instanceof PlayerEntity) {
                    if (!((PlayerEntity)getEntity).field_71075_bZ.field_75100_b && !((PlayerEntity)getEntity).func_213453_ef()) {
                        this.addMotionAdvanced(world, posOfPedestal, speed, enumfacing, getEntity);
                        this.writeStoredIntToNBT(coinInPedestal, 1);
                    }
                } else {
                    this.addMotionAdvanced(world, posOfPedestal, speed, enumfacing, getEntity);
                    this.writeStoredIntToNBT(coinInPedestal, 1);
                }
                if (enumfacing != Direction.UP) continue;
                getEntity.field_70143_R = 0.0f;
            }
        }
    }

    protected void addMotion(World world, BlockPos posOfPedestal, double speed, Direction enumfacing, LivingEntity entity) {
        switch (enumfacing) {
            case DOWN: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b - speed, entity.func_213322_ci().field_72449_c);
                break;
            }
            case UP: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b + speed, entity.func_213322_ci().field_72449_c);
                break;
            }
            case NORTH: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c - speed);
                break;
            }
            case SOUTH: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c + speed);
                break;
            }
            case WEST: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a - speed, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c);
                break;
            }
            case EAST: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a + speed, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c);
            }
        }
    }

    protected void addMotionAdvanced(World world, BlockPos posOfPedestal, double speed, Direction enumfacing, Entity entity) {
        switch (enumfacing) {
            case DOWN: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b - speed, entity.func_213322_ci().field_72449_c);
                break;
            }
            case UP: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b + speed, entity.func_213322_ci().field_72449_c);
                break;
            }
            case NORTH: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c - speed);
                break;
            }
            case SOUTH: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c + speed);
                break;
            }
            case WEST: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a - speed, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c);
                break;
            }
            case EAST: {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a + speed, entity.func_213322_ci().field_72448_b, entity.func_213322_ci().field_72449_c);
            }
        }
    }

    public double getFanSpeed(ItemStack stack) {
        double intOperationalSpeed = 0.25;
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                intOperationalSpeed = 0.1;
                break;
            }
            case 1: {
                intOperationalSpeed = 0.2;
                break;
            }
            case 2: {
                intOperationalSpeed = 0.4;
                break;
            }
            case 3: {
                intOperationalSpeed = 0.6;
                break;
            }
            case 4: {
                intOperationalSpeed = 1.0;
                break;
            }
            case 5: {
                intOperationalSpeed = 2.0;
                break;
            }
            default: {
                intOperationalSpeed = 0.1;
            }
        }
        return intOperationalSpeed;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int entityCount;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && (entityCount = this.readStoredIntTwoFromNBT(coin = (pedestal = (PedestalTileEntity)tileEntity).getCoinOnPedestal())) > 0) {
            float f = (float)entityCount / (float)this.getMaxFuelDeviderBasedOnFuelStored(entityCount);
            intItem = MathHelper.func_76141_d((float)(f * 15.0f));
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockPos pedestalPos = pedestal.func_174877_v();
        if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
            this.upgradeAction(pedestal);
            if (this.readStoredIntFromNBT(coinInPedestal) > 0) {
                int speedSound = this.getOperationSpeed(coinInPedestal);
                if (world.func_82737_E() % (long)speedSound == 0L && !pedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), SoundEvents.field_206944_gn, SoundCategory.BLOCKS, 0.25f, 1.0f);
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal) {
        Block filterBlock;
        World world = pedestal.func_145831_w();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        ItemStack coin = pedestal.getCoinOnPedestal();
        int width = this.getAreaWidth(coin);
        int height = this.getHeight(coin);
        BlockPos negBlockPos = this.getNegRangePosEntity(world, posOfPedestal, width, height);
        BlockPos posBlockPos = this.getPosRangePosEntity(world, posOfPedestal, width, height);
        double speed = this.getFanSpeed(coin);
        AxisAlignedBB getBox = new AxisAlignedBB(negBlockPos, posBlockPos);
        if (!this.hasFilterBlock(coin)) {
            this.writeFilterBlockToNBT(pedestal);
        }
        Block block = filterBlock = !world.field_72995_K ? this.readFilterBlockFromNBT(coin) : this.getBaseBlockBelow(world, posOfPedestal);
        if (filterBlock.equals(Blocks.field_235397_ng_)) {
            speed *= 2.0;
        }
        if (this.hasAdvancedInventoryTargeting(coin)) {
            this.useFanOnEntitiesAdvanced(pedestal, filterBlock, speed, getBox);
        } else {
            this.useFanOnEntities(pedestal, filterBlock, speed, getBox);
        }
    }

    @Override
    public void onPedestalBelowNeighborChanged(PedestalTileEntity pedestal, BlockState blockChanged, BlockPos blockChangedPos) {
        BlockPos blockBelow = this.getPosOfBlockBelow(pedestal.func_145831_w(), pedestal.func_174877_v(), 1);
        if (blockBelow.equals((Object)blockChangedPos)) {
            this.writeFilterBlockToNBT(pedestal);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        Block filterBlock = this.hasFilterBlock(stack) ? this.readFilterBlockFromNBT(stack) : Blocks.field_150350_a;
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        int s4 = this.getHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + s4 + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (map.size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent entityType = new TranslationTextComponent(this.func_77658_a() + ".chat_entity");
        if (this.hasAdvancedInventoryTargeting(stack)) {
            entityType.func_240702_b_(this.getTargetEntityAdvanced(filterBlock));
        } else {
            entityType.func_240702_b_(this.getTargetEntity(filterBlock));
        }
        entityType.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)entityType, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        int s4 = this.getHeight(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        String trr = "" + s4 + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(trr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)area);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)FAN);
    }
}

