/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseExp;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseFluid;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.recipes.FluidtoExpConverterRecipe;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExpFluidConverter
extends ItemUpgradeBaseFluid {
    public static final Item FLUIDXPCONVERTER = (Item)new ItemUpgradeExpFluidConverter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/fluidxpconverter"));

    public ItemUpgradeExpFluidConverter(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public boolean canSendItem(PedestalTileEntity tile) {
        if (tile != null) {
            FluidStack fluidInItem = this.getFluidInItem(tile.getItemInPedestal());
            return fluidInItem.isEmpty() || !this.getFluidStored(tile.getCoinOnPedestal()).isFluidEqual(fluidInItem);
        }
        return true;
    }

    @Override
    public int canAcceptCount(World world, BlockPos pos, ItemStack inPedestal, ItemStack itemStackIncoming) {
        FluidStack fluidIn = this.getFluidInItem(inPedestal);
        if (fluidIn.isEmpty()) {
            return 0;
        }
        return this.canRecieveFluid(world, pos, fluidIn) ? 1 : 0;
    }

    @Override
    public boolean canRecieveFluid(World world, BlockPos posPedestal, FluidStack fluidIncoming) {
        boolean returner = false;
        if (world.func_175625_s(posPedestal) instanceof PedestalTileEntity) {
            Collection<ItemStack> jsonResults;
            ItemStack resultSmelted;
            PedestalTileEntity pedestal = (PedestalTileEntity)world.func_175625_s(posPedestal);
            ItemStack coin = pedestal.getCoinOnPedestal();
            ItemStack bucketStack = new ItemStack((IItemProvider)Items.field_221803_eL);
            if (!fluidIncoming.isEmpty()) {
                FluidStack fluidToBucket = fluidIncoming;
                Item bucket = fluidToBucket.getFluid().func_204524_b();
                bucketStack = new ItemStack((IItemProvider)bucket);
            }
            ItemStack itemStack = resultSmelted = (jsonResults = this.getProcessResults(this.getRecipe(world, bucketStack))).iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResults.iterator().next();
            if (resultSmelted.func_77973_b().equals(Items.field_151062_by)) {
                return true;
            }
        }
        return returner;
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return 0;
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{0, 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return 0;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFluidValue = this.getFluidbuffer(coinInPedestal);
            if (!this.hasMaxFluidSet(coinInPedestal) || this.readMaxFluidFromNBT(coinInPedestal) != getMaxFluidValue) {
                this.setMaxFluid(coinInPedestal, getMaxFluidValue);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (this.getXPStored(coinInPedestal) > 0) {
                this.upgradeActionSendExp(pedestal);
            }
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                if (this.hasFluidInCoin(coinInPedestal)) {
                    this.upgradeAction(pedestal);
                }
                this.upgradeActionItem(pedestal);
                this.upgradeActionBlock(pedestal);
            }
        }
    }

    public FluidStack getFluidInItem(ItemStack itemInPedestal) {
        if (FluidUtil.getFluidHandler((ItemStack)itemInPedestal).isPresent()) {
            FluidStack fluidInItem = FluidUtil.getFluidContained((ItemStack)itemInPedestal).orElse(FluidStack.EMPTY);
            return fluidInItem;
        }
        return FluidStack.EMPTY;
    }

    public void upgradeActionItem(PedestalTileEntity pedestal) {
        FluidStack fluidIn;
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        int getMaxXpValue = this.getExpCountByLevel(this.getExpBuffer(coinInPedestal));
        if (!this.hasMaxXpSet(coinInPedestal) || this.readMaxXpFromNBT(coinInPedestal) != getMaxXpValue) {
            this.setMaxXP(coinInPedestal, getMaxXpValue);
        }
        if (!itemInPedestal.func_190926_b() && !(fluidIn = this.getFluidInItem(itemInPedestal)).isEmpty()) {
            FluidStack fluidInCoin = this.getFluidInItem(coinInPedestal);
            Optional fluidContainerItemIn = FluidUtil.getFluidHandler((ItemStack)itemInPedestal).resolve();
            if (fluidContainerItemIn.isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidContainerItemIn.get();
                int tanks = ((IFluidHandlerItem)fluidContainerItemIn.get()).getTanks();
                if (tanks > 1) {
                    if (!fluidInCoin.isEmpty()) {
                        int transferRate;
                        int rate;
                        FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(0);
                        int amountIn = fluidInTank.getAmount();
                        int spaceInCoin = this.availableFluidSpaceInCoin(coinInPedestal);
                        int actualCoinRate = spaceInCoin >= (rate = this.getFluidTransferRate(coinInPedestal)) ? rate : spaceInCoin;
                        int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                        if (spaceInCoin >= transferRate || this.getFluidStored(coinInPedestal).isEmpty()) {
                            FluidStack estFluidToDrain = new FluidStack(fluidInTank, transferRate);
                            FluidStack fluidToActuallyDrain = fluidHandlerItem.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                            if (!fluidInTank.isEmpty() && this.addFluid(pedestal, coinInPedestal, fluidToActuallyDrain, true)) {
                                FluidStack fluidDrained = fluidHandlerItem.drain(estFluidToDrain, IFluidHandler.FluidAction.EXECUTE);
                                this.addFluid(pedestal, coinInPedestal, fluidDrained, false);
                                ItemStack returnerStack = fluidHandlerItem.getContainer();
                                pedestal.removeItemOverride();
                                pedestal.addItem(returnerStack);
                            }
                        }
                    } else {
                        FluidStack fluidMatching = FluidStack.EMPTY;
                        fluidMatching = IntStream.range(0, tanks).mapToObj(arg_0 -> ((IFluidHandlerItem)fluidHandlerItem).getFluidInTank(arg_0)).filter(fluidStack -> fluidInCoin.isFluidEqual(fluidStack)).findFirst().orElse(FluidStack.EMPTY);
                        if (!fluidMatching.isEmpty()) {
                            int transferRate;
                            int rate;
                            int amountIn = fluidMatching.getAmount();
                            int spaceInCoin = this.availableFluidSpaceInCoin(coinInPedestal);
                            int actualCoinRate = spaceInCoin >= (rate = this.getFluidTransferRate(coinInPedestal)) ? rate : spaceInCoin;
                            int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                            if (spaceInCoin >= transferRate || this.getFluidStored(coinInPedestal).isEmpty()) {
                                FluidStack estFluidToDrain = new FluidStack(fluidMatching, transferRate);
                                FluidStack fluidToActuallyDrain = fluidHandlerItem.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                                if (!fluidMatching.isEmpty() && this.addFluid(pedestal, coinInPedestal, fluidToActuallyDrain, true)) {
                                    FluidStack fluidDrained = fluidHandlerItem.drain(estFluidToDrain, IFluidHandler.FluidAction.EXECUTE);
                                    this.addFluid(pedestal, coinInPedestal, fluidDrained, false);
                                    ItemStack returnerStack = fluidHandlerItem.getContainer();
                                    pedestal.removeItemOverride();
                                    pedestal.addItem(returnerStack);
                                }
                            }
                        }
                    }
                } else {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tanks - 1);
                    if (fluidInCoin.isEmpty() || fluidInCoin.isFluidEqual(fluidInTank)) {
                        int transferRate;
                        int rate;
                        int amountIn = fluidInTank.getAmount();
                        int spaceInCoin = this.availableFluidSpaceInCoin(coinInPedestal);
                        int actualCoinRate = spaceInCoin >= (rate = this.getFluidTransferRate(coinInPedestal)) ? rate : spaceInCoin;
                        int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                        if (spaceInCoin >= transferRate || this.getFluidStored(coinInPedestal).isEmpty()) {
                            FluidStack estFluidToDrain = new FluidStack(fluidInTank, transferRate);
                            FluidStack fluidToActuallyDrain = fluidHandlerItem.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                            if (!fluidInTank.isEmpty() && this.addFluid(pedestal, coinInPedestal, fluidToActuallyDrain, true)) {
                                FluidStack fluidDrained = fluidHandlerItem.drain(estFluidToDrain, IFluidHandler.FluidAction.EXECUTE);
                                this.addFluid(pedestal, coinInPedestal, fluidDrained, false);
                                ItemStack returnerStack = fluidHandlerItem.getContainer();
                                pedestal.removeItemOverride();
                                pedestal.addItem(returnerStack);
                            }
                        }
                    }
                }
            }
        }
    }

    public void upgradeActionBlock(PedestalTileEntity pedestal) {
        IFluidHandler handler;
        World world = pedestal.func_145831_w();
        BlockPos posPedestal = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockPos posInventory = this.getPosOfBlockBelow(world, posPedestal, 1);
        ItemStack itemFromPedestal = ItemStack.field_190927_a;
        LazyOptional<IFluidHandler> cap = ItemUpgradeExpFluidConverter.findFluidHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posPedestal), true);
        TileEntity invToPushTo = world.func_175625_s(posInventory);
        if (invToPushTo instanceof PedestalTileEntity) {
            itemFromPedestal = ItemStack.field_190927_a;
        } else if (cap.isPresent() && (handler = (IFluidHandler)cap.orElse(null)) != null) {
            int tanks = handler.getTanks();
            FluidStack fluidCheckedMatching = FluidStack.EMPTY;
            fluidCheckedMatching = IntStream.range(0, tanks).mapToObj(arg_0 -> ((IFluidHandler)handler).getFluidInTank(arg_0)).filter(fluidStack -> !fluidStack.isEmpty()).findFirst().orElse(FluidStack.EMPTY);
            if (!fluidCheckedMatching.isEmpty()) {
                FluidStack fluidInCoin = this.getFluidStored(coinInPedestal);
                if (tanks > 1) {
                    if (!fluidInCoin.isEmpty()) {
                        int transferRate;
                        int rate;
                        FluidStack fluidInTank = handler.getFluidInTank(0);
                        int amountIn = fluidInTank.getAmount();
                        int spaceInCoin = this.availableFluidSpaceInCoin(coinInPedestal);
                        int actualCoinRate = spaceInCoin >= (rate = this.getFluidTransferRate(coinInPedestal)) ? rate : spaceInCoin;
                        int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                        if (spaceInCoin >= transferRate || this.getFluidStored(coinInPedestal).isEmpty()) {
                            FluidStack estFluidToDrain = new FluidStack(fluidInTank, transferRate);
                            FluidStack fluidToActuallyDrain = handler.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                            if (!fluidInTank.isEmpty() && this.addFluid(pedestal, coinInPedestal, fluidToActuallyDrain, true)) {
                                FluidStack fluidDrained = handler.drain(estFluidToDrain, IFluidHandler.FluidAction.EXECUTE);
                                this.addFluid(pedestal, coinInPedestal, fluidDrained, false);
                            }
                        }
                    } else {
                        FluidStack fluidMatching = FluidStack.EMPTY;
                        fluidMatching = IntStream.range(0, tanks).mapToObj(arg_0 -> ((IFluidHandler)handler).getFluidInTank(arg_0)).filter(fluidStack -> fluidInCoin.isFluidEqual(fluidStack)).findFirst().orElse(FluidStack.EMPTY);
                        if (!fluidMatching.isEmpty()) {
                            int transferRate;
                            int rate;
                            int amountIn = fluidMatching.getAmount();
                            int spaceInCoin = this.availableFluidSpaceInCoin(coinInPedestal);
                            int actualCoinRate = spaceInCoin >= (rate = this.getFluidTransferRate(coinInPedestal)) ? rate : spaceInCoin;
                            int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                            if (spaceInCoin >= transferRate || this.getFluidStored(coinInPedestal).isEmpty()) {
                                FluidStack estFluidToDrain = new FluidStack(fluidMatching, transferRate);
                                FluidStack fluidToActuallyDrain = handler.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                                if (!fluidMatching.isEmpty() && this.addFluid(pedestal, coinInPedestal, fluidToActuallyDrain, true)) {
                                    FluidStack fluidDrained = handler.drain(estFluidToDrain, IFluidHandler.FluidAction.EXECUTE);
                                    this.addFluid(pedestal, coinInPedestal, fluidDrained, false);
                                }
                            }
                        }
                    }
                } else {
                    FluidStack fluidInTank = handler.getFluidInTank(tanks - 1);
                    if (fluidInCoin.isEmpty() || fluidInCoin.isFluidEqual(fluidInTank)) {
                        int transferRate;
                        int rate;
                        int amountIn = fluidInTank.getAmount();
                        int spaceInCoin = this.availableFluidSpaceInCoin(coinInPedestal);
                        int actualCoinRate = spaceInCoin >= (rate = this.getFluidTransferRate(coinInPedestal)) ? rate : spaceInCoin;
                        int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                        if (spaceInCoin >= transferRate || this.getFluidStored(coinInPedestal).isEmpty()) {
                            FluidStack estFluidToDrain = new FluidStack(fluidInTank, transferRate);
                            FluidStack fluidToActuallyDrain = handler.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                            if (!fluidInTank.isEmpty() && this.addFluid(pedestal, coinInPedestal, fluidToActuallyDrain, true)) {
                                FluidStack fluidDrained = handler.drain(estFluidToDrain, IFluidHandler.FluidAction.EXECUTE);
                                this.addFluid(pedestal, coinInPedestal, fluidDrained, false);
                            }
                        }
                    }
                }
            }
        }
    }

    @Nullable
    protected FluidtoExpConverterRecipe getRecipe(World world, ItemStack stackIn) {
        Inventory inv = new Inventory(new ItemStack[]{stackIn});
        return world == null ? null : (FluidtoExpConverterRecipe)world.func_199532_z().func_215371_a(FluidtoExpConverterRecipe.recipeType, (IInventory)inv, world).orElse(null);
    }

    protected Collection<ItemStack> getProcessResults(FluidtoExpConverterRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.field_190927_a) : Collections.singleton(recipe.getResult());
    }

    public void upgradeAction(PedestalTileEntity pedestal) {
        Collection<ItemStack> jsonResults;
        ItemStack resultSmelted;
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack bucketStack = new ItemStack((IItemProvider)Items.field_221803_eL);
        if (this.removeFluid(pedestal, coinInPedestal, 1000, true)) {
            FluidStack fluidToBucket = this.getFluidStored(coinInPedestal);
            Item bucket = fluidToBucket.getFluid().func_204524_b();
            bucketStack = new ItemStack((IItemProvider)bucket);
        }
        ItemStack itemStack = resultSmelted = (jsonResults = this.getProcessResults(this.getRecipe(world, bucketStack))).iterator().next().func_190926_b() ? ItemStack.field_190927_a : jsonResults.iterator().next();
        if (!resultSmelted.func_190926_b() && resultSmelted.func_77973_b().equals(Items.field_151062_by)) {
            int current;
            int outputCount = resultSmelted.func_190916_E();
            int max = this.readMaxXpFromNBT(coinInPedestal);
            int spaceXP = max - (current = this.getXPStored(coinInPedestal));
            if (spaceXP >= outputCount) {
                this.setXPStored(coinInPedestal, current + outputCount);
                this.removeFluid(pedestal, coinInPedestal, 1000, false);
            }
        }
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && this.getXPStored(coin = (pedestal = (PedestalTileEntity)tileEntity).getCoinOnPedestal()) > 0) {
            float f = (float)this.getXPStored(coin) / (float)this.readMaxXpFromNBT(coin);
            intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
        }
        return intItem;
    }

    public void setMaxXP(ItemStack stack, int value) {
        this.writeMaxXpToNBT(stack, value);
    }

    public int getExpTransferRate(ItemStack stack) {
        int overEnchanted = this.getExpCountByLevel(this.getCapacityModifierOverEnchanted(stack) * 5 + 5);
        return overEnchanted >= 20000 ? 20000 : overEnchanted;
    }

    public int getExpTransferRateLevel(ItemStack stack) {
        int overEnchanted = this.getCapacityModifierOverEnchanted(stack) * 5 + 5;
        return overEnchanted >= 20000 ? 20000 : overEnchanted;
    }

    public String getExpTransferRateString(ItemStack stack) {
        return "" + this.getExpTransferRateLevel(stack) + "";
    }

    public void upgradeActionSendExp(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ItemStack coinMainPedestal = pedestal.getCoinOnPedestal();
        BlockPos posMainPedestal = pedestal.func_174877_v();
        int xpMainPedestal = this.getXPStored(coinMainPedestal);
        if (xpMainPedestal > 0 && pedestal.getNumberOfStoredLocations() > 0) {
            for (int i = 0; i < pedestal.getNumberOfStoredLocations(); ++i) {
                PedestalTileEntity tileStoredPedestal;
                ItemStack coinStoredPedestal;
                TileEntity storedPedestal;
                BlockPos posStoredPedestal = pedestal.getStoredPositionAt(i);
                if (world.func_175640_z(posStoredPedestal) || !world.func_175667_e(posStoredPedestal) || posStoredPedestal == posMainPedestal || !((storedPedestal = world.func_175625_s(posStoredPedestal)) instanceof PedestalTileEntity) || !((coinStoredPedestal = (tileStoredPedestal = (PedestalTileEntity)storedPedestal).getCoinOnPedestal()).func_77973_b() instanceof ItemUpgradeBaseExp)) continue;
                int xpMaxStoredPedestal = ((ItemUpgradeBaseExp)coinStoredPedestal.func_77973_b()).readMaxXpFromNBT(coinStoredPedestal);
                int xpStoredPedestal = this.getXPStored(coinStoredPedestal);
                if (xpStoredPedestal >= xpMaxStoredPedestal) continue;
                int transferRate = this.getExpTransferRate(coinMainPedestal);
                if (xpMainPedestal >= transferRate) {
                    int xpRemainingMainPedestal = xpMainPedestal - transferRate;
                    int xpRemainingStoredPedestal = xpStoredPedestal + transferRate;
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posMainPedestal.func_177958_n(), (double)posMainPedestal.func_177956_o(), (double)posMainPedestal.func_177952_p(), SoundEvents.field_187601_be, SoundCategory.BLOCKS, 0.05f, 1.0f);
                    }
                    this.setXPStored(coinMainPedestal, xpRemainingMainPedestal);
                    pedestal.update();
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posStoredPedestal.func_177958_n(), (double)posStoredPedestal.func_177956_o(), (double)posStoredPedestal.func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.05f, 1.0f);
                    }
                    this.setXPStored(coinStoredPedestal, xpRemainingStoredPedestal);
                    tileStoredPedestal.update();
                    break;
                }
                int xpRemainingMainPedestal = 0;
                int xpRemainingStoredPedestal = xpStoredPedestal + xpMainPedestal;
                if (!pedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)posMainPedestal.func_177958_n(), (double)posMainPedestal.func_177956_o(), (double)posMainPedestal.func_177952_p(), SoundEvents.field_187601_be, SoundCategory.BLOCKS, 0.05f, 1.0f);
                }
                this.setXPStored(coinMainPedestal, xpRemainingMainPedestal);
                pedestal.update();
                if (!pedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)posStoredPedestal.func_177958_n(), (double)posStoredPedestal.func_177956_o(), (double)posStoredPedestal.func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.05f, 1.0f);
                }
                this.setXPStored(coinStoredPedestal, xpRemainingStoredPedestal);
                tileStoredPedestal.update();
                break;
            }
        }
    }

    public int getExpCountByLevel(int level) {
        int expUsed = 0;
        if (level <= 16) {
            expUsed = level * level + 6 * level;
        } else if (level > 16 && level <= 31) {
            expUsed = (int)(2.5 * (double)(level * level) - 40.5 * (double)level + 360.0);
        } else if (level > 31) {
            expUsed = (int)(4.5 * (double)(level * level) - 162.5 * (double)level + 2220.0);
        }
        return expUsed;
    }

    public int getExpLevelFromCount(int value) {
        boolean level = false;
        long maths = 0L;
        int i = 0;
        boolean j = false;
        if (value > 0 && value <= 352) {
            maths = (long)Math.sqrt(Math.addExact(36L, Math.addExact(4L, (long)value)));
            i = Math.round(Math.addExact(-6L, maths) / 2L);
        }
        if (value > 352 && value <= 1507) {
            maths = (long)Math.sqrt(Math.subtractExact(164025L, Math.multiplyExact(100L, Math.subtractExact(3600L, Math.multiplyExact(10L, (long)value)))));
            i = (int)(Math.addExact(405L, maths) / 50L);
        }
        if (value > 1507) {
            maths = (long)Math.sqrt(Math.subtractExact(2640625L, Math.multiplyExact(180L, Math.subtractExact(22200L, Math.multiplyExact(10L, (long)value)))));
            i = (int)(Math.addExact(1625L, maths) / 90L);
        }
        return Math.abs(i);
    }

    public int spaceForXP(ItemStack coin) {
        int stored;
        int max = this.readMaxXpFromNBT(coin);
        int space = max - (stored = this.getXPStored(coin));
        return space > 0 ? space : 0;
    }

    public void setXPStored(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("xpstored", value);
        stack.func_77982_d(compound);
    }

    public int getXPStored(ItemStack stack) {
        int storedxp = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            storedxp = getCompound.func_74762_e("xpstored");
        }
        return storedxp;
    }

    public boolean hasMaxXpSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("maxxp")) {
            returner = true;
        }
        return returner;
    }

    public void writeMaxXpToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("maxxp", value);
        stack.func_77982_d(compound);
    }

    public int readMaxXpFromNBT(ItemStack stack) {
        int maxxp = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxxp = getCompound.func_74762_e("maxxp");
        }
        return maxxp;
    }

    public int getExpBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 5 + 30;
        return overEnchanted >= this.maxLVLStored ? this.maxLVLStored : overEnchanted;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_xp");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)fluid, Util.field_240973_b_);
        }
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_(this.getExpTransferRateString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            tooltip.add((ITextComponent)fluid);
        }
        TranslationTextComponent fluidcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidcapacity");
        fluidcapacity.func_240702_b_("" + this.getFluidbuffer(stack) + "");
        fluidcapacity.func_240702_b_(fluidLabel.getString());
        fluidcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)fluidcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_(this.getExpTransferRateString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)FLUIDXPCONVERTER);
    }
}

