/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseExp;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExpBottler
extends ItemUpgradeBaseExp {
    public static final Item XPBOTTLER = (Item)new ItemUpgradeExpBottler(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/xpbottler"));

    public ItemUpgradeExpBottler(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getBottlingRate(ItemStack stack) {
        int bottlingRate = 1;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                bottlingRate = 1;
                break;
            }
            case 1: {
                bottlingRate = 2;
                break;
            }
            case 2: {
                bottlingRate = 4;
                break;
            }
            case 3: {
                bottlingRate = 8;
                break;
            }
            case 4: {
                bottlingRate = 12;
                break;
            }
            case 5: {
                bottlingRate = 16;
                break;
            }
            default: {
                bottlingRate = 1;
            }
        }
        return bottlingRate;
    }

    @Override
    public int getExpBuffer(ItemStack stack) {
        int value = 30;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                value = 5;
                break;
            }
            case 1: {
                value = 10;
                break;
            }
            case 2: {
                value = 15;
                break;
            }
            case 3: {
                value = 20;
                break;
            }
            case 4: {
                value = 25;
                break;
            }
            case 5: {
                value = 30;
                break;
            }
            default: {
                value = 5;
            }
        }
        return value;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(pedestal, world, coinInPedestal, pedestalPos);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        int getMaxXpValue = this.getExpCountByLevel(this.getExpBuffer(coinInPedestal));
        if (!this.hasMaxXpSet(coinInPedestal) || this.readMaxXpFromNBT(coinInPedestal) != getMaxXpValue) {
            this.setMaxXP(coinInPedestal, getMaxXpValue);
        }
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        LazyOptional<IItemHandler> cap = ItemUpgradeExpBottler.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
            cap = ItemUpgradeExpBottler.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if (!this.isInventoryEmpty(cap) && cap.isPresent()) {
            int i;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            if (!(this.hasAdvancedInventoryTargeting(coinInPedestal) && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity))) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null && (i = this.getNextSlotWithItemsCap(cap, this.getStackInPedestal(world, posOfPedestal))) >= 0) {
                itemFromInv = handler.getStackInSlot(i);
                int slotCount = itemFromInv.func_190916_E();
                if (itemFromInv.func_77973_b().equals(Items.field_151069_bo)) {
                    int xpCost = 11;
                    int modifier = this.getBottlingRate(coinInPedestal);
                    int adjustedModifier = Math.min(handler.extractItem(i, modifier, true).func_190916_E(), modifier);
                    if (adjustedModifier > 0) {
                        int rate = adjustedModifier * xpCost;
                        ItemStack getBottle = new ItemStack((IItemProvider)Items.field_151062_by, adjustedModifier);
                        if (pedestal.canAcceptItems(world, posOfPedestal, getBottle) >= adjustedModifier) {
                            int currentlyStoredExp = this.getXPStored(coinInPedestal);
                            if (currentlyStoredExp >= rate) {
                                int getExpLeftInPedestal = currentlyStoredExp - rate;
                                this.setXPStored(coinInPedestal, getExpLeftInPedestal);
                                if (!handler.extractItem(i, adjustedModifier, true).func_190926_b()) {
                                    handler.extractItem(i, adjustedModifier, false);
                                    pedestal.addItem(getBottle);
                                    if (!pedestal.hasMuffler()) {
                                        world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                    }
                                }
                            } else {
                                adjustedModifier = Math.floorDiv(currentlyStoredExp, xpCost);
                                rate = adjustedModifier * xpCost;
                                getBottle = new ItemStack((IItemProvider)Items.field_151062_by, adjustedModifier);
                                int getExpLeftInPedestal = currentlyStoredExp - rate;
                                this.setXPStored(coinInPedestal, getExpLeftInPedestal);
                                if (!handler.extractItem(i, adjustedModifier, true).func_190926_b()) {
                                    handler.extractItem(i, adjustedModifier, false);
                                    pedestal.addItem(getBottle);
                                    if (!pedestal.hasMuffler()) {
                                        world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int modifier = this.getBottlingRate(coin);
        int rate = modifier * 11;
        if (!world.func_175640_z(pos) && this.getXPStored(coin) >= rate && !pedestal.hasParticleDiffuser()) {
            this.spawnParticleAroundPedestalBase(world, tick, pos, 0.2f, 0.95f, 0.2f, 1.0f);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_xp");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getBottlingRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getBottlingRate(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)XPBOTTLER);
    }
}

