/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.google.common.collect.Maps;
import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseExp;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeExpAnvil
extends ItemUpgradeBaseExp {
    public static final Item XPANVIL = (Item)new ItemUpgradeExpAnvil(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/xpanvil"));

    public ItemUpgradeExpAnvil(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public int getExpBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 15 + 30;
        return overEnchanted > this.maxLVLStored ? this.maxLVLStored : overEnchanted;
    }

    public int getRepairRate(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 10 + 10;
        return overEnchanted > this.maxStored ? this.maxStored : overEnchanted;
    }

    private int correctlyPlacedSorroundingPedestals(World world, BlockPos posPedestal) {
        int around = 0;
        ArrayList<BlockPos> posSorroundingPedestals = new ArrayList<BlockPos>();
        posSorroundingPedestals.add(posPedestal.func_177982_a(2, 0, 0));
        posSorroundingPedestals.add(posPedestal.func_177982_a(0, 0, 2));
        posSorroundingPedestals.add(posPedestal.func_177982_a(-2, 0, 0));
        posSorroundingPedestals.add(posPedestal.func_177982_a(0, 0, -2));
        for (int i = 0; i < posSorroundingPedestals.size(); ++i) {
            Block pedestal = world.func_180495_p((BlockPos)posSorroundingPedestals.get(i)).func_177230_c();
            if (!(pedestal instanceof PedestalBlock)) continue;
            ++around;
        }
        return around;
    }

    private ArrayList<ItemStack> doSorroundingPedestalsHaveItemsToCombine(World world, BlockPos pedestalPos) {
        ArrayList<ItemStack> stackOnSorroundingPedestal = new ArrayList<ItemStack>();
        ArrayList<BlockPos> posSorroundingPedestals = new ArrayList<BlockPos>();
        posSorroundingPedestals.add(pedestalPos.func_177982_a(2, 0, 0));
        posSorroundingPedestals.add(pedestalPos.func_177982_a(0, 0, 2));
        posSorroundingPedestals.add(pedestalPos.func_177982_a(-2, 0, 0));
        posSorroundingPedestals.add(pedestalPos.func_177982_a(0, 0, -2));
        for (int i = 0; i < posSorroundingPedestals.size(); ++i) {
            PedestalTileEntity tilePedestal;
            ItemStack stack;
            TileEntity tile;
            if (world.func_180495_p((BlockPos)posSorroundingPedestals.get(i)).func_177230_c().equals(Blocks.field_150350_a) || !((tile = world.func_175625_s((BlockPos)posSorroundingPedestals.get(i))) instanceof PedestalTileEntity) || !(stack = (tilePedestal = (PedestalTileEntity)tile).getItemInPedestal()).func_77948_v() && !stack.func_77973_b().equals(Items.field_151134_bR) && !stack.func_77973_b().equals(Items.field_151057_cb) && !stack.func_77973_b().equals(Items.field_151045_i)) continue;
            stackOnSorroundingPedestal.add(stack);
        }
        return stackOnSorroundingPedestal;
    }

    private void deleteItemsOnPedestals(World world, BlockPos pedestalPos, int crystals) {
        int crystalsToRemove = crystals;
        ArrayList<BlockPos> posSorroundingPedestals = new ArrayList<BlockPos>();
        posSorroundingPedestals.add(pedestalPos.func_177982_a(2, 0, 0));
        posSorroundingPedestals.add(pedestalPos.func_177982_a(0, 0, 2));
        posSorroundingPedestals.add(pedestalPos.func_177982_a(-2, 0, 0));
        posSorroundingPedestals.add(pedestalPos.func_177982_a(0, 0, -2));
        for (int i = 0; i < posSorroundingPedestals.size(); ++i) {
            TileEntity tile;
            if (world.func_180495_p((BlockPos)posSorroundingPedestals.get(i)).func_177230_c().equals(Blocks.field_150350_a) || !((tile = world.func_175625_s((BlockPos)posSorroundingPedestals.get(i))) instanceof PedestalTileEntity)) continue;
            PedestalTileEntity tilePedestal = (PedestalTileEntity)tile;
            ItemStack stack = tilePedestal.getItemInPedestal();
            if (stack.func_77948_v() || stack.func_77973_b().equals(Items.field_151134_bR) || stack.func_77973_b().equals(Items.field_151057_cb)) {
                tilePedestal.removeItem(1);
                continue;
            }
            if (!stack.func_77973_b().equals(Items.field_151045_i)) continue;
            if (stack.func_190916_E() >= crystalsToRemove) {
                tilePedestal.removeItem(crystalsToRemove);
                crystalsToRemove = 0;
                continue;
            }
            crystalsToRemove -= stack.func_190916_E();
            tilePedestal.removeItem();
        }
    }

    private int getCrystals(ArrayList<ItemStack> stackToCombine) {
        int crystals = 0;
        for (int i = 0; i < stackToCombine.size(); ++i) {
            if (!stackToCombine.get(i).func_77973_b().equals(Items.field_151045_i)) continue;
            crystals += stackToCombine.get(i).func_190916_E();
        }
        return crystals;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(world, itemInPedestal, coinInPedestal, pedestalPos);
            }
        }
    }

    public int getNextSlotWithItemsCapAnvil(LazyOptional<IItemHandler> cap, ItemStack stackInPedestal) {
        ITag BLACKLIST_ALL = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("pedestals", "anvil/blacklist_all"));
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b() || itemHandler.extractItem(i, 1, true).equals(ItemStack.field_190927_a) || BLACKLIST_ALL.func_230235_a_((Object)stackInSlot.func_77973_b())) continue;
                    if (stackInPedestal.func_190926_b()) {
                        slot.set(i);
                        break;
                    }
                    if (!this.doItemsMatch(stackInPedestal, stackInSlot)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    public void upgradeAction(World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        int overCombine;
        int getMaxXpValue = this.getExpCountByLevel(this.getExpBuffer(coinInPedestal));
        if (!this.hasMaxXpSet(coinInPedestal) || this.readMaxXpFromNBT(coinInPedestal) != getMaxXpValue) {
            this.setMaxXP(coinInPedestal, getMaxXpValue);
        }
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        ItemStack itemFromInv = ItemStack.field_190927_a;
        ArrayList<ItemStack> stackToCombine = this.doSorroundingPedestalsHaveItemsToCombine(world, posOfPedestal);
        String strNameToChangeTo = "";
        LinkedHashMap enchantsMap = Maps.newLinkedHashMap();
        int overCombineCopy = overCombine = this.getCrystals(stackToCombine);
        int crystalsToRemoveCount = 0;
        int intExpInCoin = this.getXPStored(coinInPedestal);
        int intRepairRate = this.getRepairRate(coinInPedestal);
        int intLevelCostToCombine = 0;
        LazyOptional<IItemHandler> cap = ItemUpgradeExpAnvil.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        if (this.hasAdvancedInventoryTargeting(coinInPedestal)) {
            cap = ItemUpgradeExpAnvil.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        }
        if (!this.isInventoryEmpty(cap) && cap.isPresent()) {
            int i;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            TileEntity invToPullFrom = world.func_175625_s(posInventory);
            if (invToPullFrom instanceof PedestalTileEntity) {
                itemFromInv = ItemStack.field_190927_a;
            } else if (handler != null && (i = this.getNextSlotWithItemsCapAnvil(cap, this.getStackInPedestal(world, posOfPedestal))) >= 0) {
                PedestalTileEntity tilePedestal;
                itemFromInv = handler.getStackInSlot(i);
                int slotCount = itemFromInv.func_190916_E();
                TileEntity pedestalInv = world.func_175625_s(posOfPedestal);
                if (pedestalInv instanceof PedestalTileEntity && !(tilePedestal = (PedestalTileEntity)pedestalInv).hasItem()) {
                    ITag BLACKLIST_COMBINE = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("pedestals", "anvil/blacklist_combine"));
                    ITag BLACKLIST_REPAIR = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("pedestals", "anvil/blacklist_repair"));
                    if (itemFromInv.func_77951_h() && !BLACKLIST_REPAIR.func_230235_a_((Object)itemFromInv.func_77973_b())) {
                        if (itemFromInv.func_77973_b().isRepairable(itemFromInv) && itemFromInv.func_77973_b().getMaxDamage(itemFromInv) > 0 && intExpInCoin >= intRepairRate) {
                            this.setXPStored(coinInPedestal, intExpInCoin - intRepairRate);
                            itemFromInv.func_196085_b(itemFromInv.func_77952_i() - intRepairRate * 2);
                        }
                    } else if (stackToCombine.size() > 0 && !BLACKLIST_COMBINE.func_230235_a_((Object)itemFromInv.func_77973_b())) {
                        int intExpCostToCombine;
                        stackToCombine.add(itemFromInv);
                        for (int e = 0; e < stackToCombine.size(); ++e) {
                            if (stackToCombine.get(e).func_77948_v() || stackToCombine.get(e).func_77973_b().equals(Items.field_151134_bR)) {
                                Map map = EnchantmentHelper.func_82781_a((ItemStack)stackToCombine.get(e));
                                for (Map.Entry entry : map.entrySet()) {
                                    Enchantment enchantment = (Enchantment)entry.getKey();
                                    Integer integer = (Integer)entry.getValue();
                                    switch (enchantment.func_77324_c()) {
                                        case COMMON: {
                                            intLevelCostToCombine += Math.round(2.0f * (float)(integer + 1));
                                            break;
                                        }
                                        case UNCOMMON: {
                                            intLevelCostToCombine += Math.round(4.0f * (float)(integer + 1));
                                            break;
                                        }
                                        case RARE: {
                                            intLevelCostToCombine += Math.round(6.0f * (float)(integer + 1));
                                            break;
                                        }
                                        case VERY_RARE: {
                                            intLevelCostToCombine += Math.round(8.0f * (float)(integer + 1));
                                        }
                                    }
                                    if (enchantsMap.containsKey(enchantment)) {
                                        int e2;
                                        int intNewValue = 0;
                                        int e1 = (Integer)enchantsMap.get(enchantment);
                                        if (e1 == (e2 = integer.intValue())) {
                                            intNewValue = e2 + 1;
                                            if (intNewValue > enchantment.func_77325_b()) {
                                                if (overCombine - crystalsToRemoveCount >= intNewValue) {
                                                    crystalsToRemoveCount += intNewValue;
                                                } else {
                                                    intNewValue = enchantment.func_77325_b();
                                                }
                                            }
                                            enchantsMap.put(enchantment, intNewValue);
                                            continue;
                                        }
                                        if (e1 > e2) continue;
                                        enchantsMap.put(enchantment, integer);
                                        continue;
                                    }
                                    enchantsMap.put(enchantment, integer);
                                }
                                continue;
                            }
                            if (!stackToCombine.get(e).func_77973_b().equals(Items.field_151057_cb)) continue;
                            strNameToChangeTo = stackToCombine.get(e).func_200301_q().getString();
                        }
                        if (this.getStoredInt(coinInPedestal) != intLevelCostToCombine) {
                            this.writeStoredIntToNBT(coinInPedestal, intLevelCostToCombine);
                        }
                        if (intExpInCoin >= (intExpCostToCombine = this.getExpCountByLevel(intLevelCostToCombine))) {
                            ItemStack itemFromInvCopy = itemFromInv.func_77946_l();
                            itemFromInvCopy.func_190920_e(1);
                            if (!handler.extractItem(i, itemFromInvCopy.func_190916_E(), true).func_190926_b()) {
                                this.setXPStored(coinInPedestal, intExpInCoin - intExpCostToCombine);
                                this.deleteItemsOnPedestals(world, posOfPedestal, crystalsToRemoveCount);
                                EnchantmentHelper.func_82782_a((Map)enchantsMap, (ItemStack)itemFromInvCopy);
                                if (strNameToChangeTo != "") {
                                    itemFromInvCopy.func_200302_a((ITextComponent)new TranslationTextComponent(strNameToChangeTo));
                                }
                                handler.extractItem(i, itemFromInvCopy.func_190916_E(), false);
                                if (!tilePedestal.hasMuffler()) {
                                    world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187698_i, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                }
                                tilePedestal.addItemOverride(itemFromInvCopy);
                                this.removeStoredIntFromCoin(coinInPedestal);
                            }
                        }
                    } else {
                        ItemStack itemFromInvCopy = itemFromInv.func_77946_l();
                        if (!handler.extractItem(i, itemFromInvCopy.func_190916_E(), true).func_190926_b()) {
                            handler.extractItem(i, itemFromInvCopy.func_190916_E(), false);
                            tilePedestal.addItemOverride(itemFromInvCopy);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_xp");
        xpstored.func_240702_b_("" + this.getExpLevelFromCount(this.getXPStored(stack)) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        if (this.getStoredInt(stack) > 0) {
            TranslationTextComponent xpLevelCost = new TranslationTextComponent(this.func_77658_a() + ".chat_xpcost");
            xpLevelCost.func_240702_b_("" + this.getStoredInt(stack) + "");
            xpLevelCost.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)xpLevelCost, Util.field_240973_b_);
        }
        TranslationTextComponent sorround = new TranslationTextComponent(this.func_77658_a() + ".chat_sorround");
        sorround.func_240702_b_("" + this.correctlyPlacedSorroundingPedestals(pedestal.func_145831_w(), pedestal.func_174877_v()) + "");
        sorround.func_240699_a_(TextFormatting.AQUA);
        player.func_145747_a((ITextComponent)sorround, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)XPANVIL);
    }
}

