/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseEnergy;
import com.mowmaster.pedestals.network.PacketHandler;
import com.mowmaster.pedestals.network.PacketParticles;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEnergyGenerator
extends ItemUpgradeBaseEnergy {
    public static final Item RFFUELGEN = (Item)new ItemUpgradeEnergyGenerator(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/rffuelgen"));

    public ItemUpgradeEnergyGenerator(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    public double getCapicityModifier(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        double rate = (double)capacityOver * 0.01 + 0.5;
        double rater = rate > 0.9 ? 0.9 : rate;
        double intModifier = 1.0;
        switch (capacityOver) {
            case 0: {
                intModifier = 1.0;
                break;
            }
            case 1: {
                intModifier = 0.9;
                break;
            }
            case 2: {
                intModifier = 0.8;
                break;
            }
            case 3: {
                intModifier = 0.7;
                break;
            }
            case 4: {
                intModifier = 0.6;
                break;
            }
            case 5: {
                intModifier = 0.5;
                break;
            }
            default: {
                intModifier = 1.0 - rater;
            }
        }
        return intModifier;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int fuelStored;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && (fuelStored = this.getFuelStored(coin = (pedestal = (PedestalTileEntity)tileEntity).getCoinOnPedestal())) > 0) {
            float f = (float)fuelStored / (float)this.getMaxFuelDeviderBasedOnFuelStored(fuelStored);
            intItem = MathHelper.func_76141_d((float)(f * 15.0f));
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFuelValue = 2000000000;
            if (!this.hasMaxFuelSet(coinInPedestal) || this.readMaxFuelFromNBT(coinInPedestal) != getMaxFuelValue) {
                this.setMaxFuel(coinInPedestal, getMaxFuelValue);
            }
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                this.upgradeActionSendEnergy(pedestal);
                if (this.getFuelStored(coinInPedestal) > 0 && this.getEnergyStored(coinInPedestal) < this.getEnergyBuffer(coinInPedestal)) {
                    if (world.func_82737_E() % 5L == 0L) {
                        BlockPos directionalPos = this.getPosOfBlockBelow(world, pedestalPos, -1);
                        if (!pedestal.hasParticleDiffuser()) {
                            PacketHandler.sendToNearby(world, pedestalPos, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, directionalPos.func_177958_n(), (double)directionalPos.func_177956_o(), (double)directionalPos.func_177952_p(), 145, 145, 145));
                        }
                    }
                    if (world.func_82737_E() % 20L == 0L) {
                        this.upgradeAction(world, pedestalPos, itemInPedestal, coinInPedestal);
                    }
                }
            }
        }
    }

    public void upgradeAction(World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        double speedMultiplier;
        int baseFuel;
        int fuelConsumed;
        double speed = this.getOperationSpeedOverride(coinInPedestal);
        double capacityRate = this.getCapicityModifier(coinInPedestal);
        int getMaxEnergyValue = this.getEnergyBuffer(coinInPedestal);
        if (!this.hasMaxEnergySet(coinInPedestal) || this.readMaxEnergyFromNBT(coinInPedestal) != getMaxEnergyValue) {
            this.setMaxEnergy(coinInPedestal, getMaxEnergyValue);
        }
        if (this.removeFuel(world, posOfPedestal, fuelConsumed = (int)Math.round((double)(baseFuel = (int)(20.0 * (speedMultiplier = 20.0 / speed))) * capacityRate), true)) {
            this.doEnergyProcess(world, coinInPedestal, posOfPedestal, baseFuel, capacityRate);
        } else {
            int fuelLeft = this.getFuelStored(coinInPedestal);
            this.doEnergyProcess(world, coinInPedestal, posOfPedestal, fuelLeft, capacityRate);
        }
    }

    public void doEnergyProcess(World world, ItemStack coinInPedestal, BlockPos posOfPedestal, int baseFuel, double capacityRate) {
        int fuelConsumed = (int)Math.round((double)baseFuel * capacityRate);
        int energyMax = this.getEnergyBuffer(coinInPedestal);
        int energyCurrent = this.getEnergyStored(coinInPedestal);
        int estEnergyProduced = (int)Math.round((double)baseFuel * 12.5);
        if (this.addEnergy(coinInPedestal, estEnergyProduced, true)) {
            this.removeFuel(world, posOfPedestal, fuelConsumed, false);
            this.addEnergy(coinInPedestal, estEnergyProduced, false);
        } else {
            int energyCanProduce = energyMax - energyCurrent;
            int fuelCanConsume = (int)Math.floor((double)energyCanProduce / 12.5);
            estEnergyProduced = (int)Math.round((double)fuelCanConsume * 12.5);
            int actualFuelConsumed = (int)Math.round((double)fuelCanConsume * capacityRate);
            this.removeFuel(world, posOfPedestal, actualFuelConsumed, false);
            this.addEnergy(coinInPedestal, estEnergyProduced, false);
        }
    }

    public void setFuelStored(ItemStack stack, int fuel) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("fuel", fuel);
        stack.func_77982_d(compound);
    }

    public boolean hasFuel(ItemStack stack) {
        return this.getFuelStored(stack) > 0;
    }

    public int getFuelStored(ItemStack stack) {
        int storedFuel = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            storedFuel = getCompound.func_74762_e("fuel");
        }
        return storedFuel;
    }

    public void setMaxFuel(ItemStack stack, int amountMax) {
        this.writeMaxFuelToNBT(stack, amountMax);
    }

    public boolean hasMaxFuelSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("maxfuel")) {
            returner = true;
        }
        return returner;
    }

    public void writeMaxFuelToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("maxfuel", value);
        stack.func_77982_d(compound);
    }

    public int readMaxFuelFromNBT(ItemStack stack) {
        int maxfuel = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxfuel = getCompound.func_74762_e("maxfuel");
        }
        return maxfuel;
    }

    public boolean addFuel(PedestalTileEntity pedestal, int amountToAdd, boolean simulate) {
        int currentFuel;
        int addAmount;
        int maxFuel;
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (this.hasMaxFuelSet(coin) && (maxFuel = this.readMaxFuelFromNBT(coin)) > (addAmount = (currentFuel = this.getFuelStored(coin)) + amountToAdd)) {
            if (!simulate) {
                this.setFuelStored(coin, addAmount);
                pedestal.update();
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean removeFuel(World world, BlockPos posPedestal, int amountToRemove, boolean simulate) {
        TileEntity entity = world.func_175625_s(posPedestal);
        if (entity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)entity;
            return this.removeFuel(pedestal, amountToRemove, simulate);
        }
        return false;
    }

    public boolean removeFuel(PedestalTileEntity pedestal, int amountToRemove, boolean simulate) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (this.hasFuel(coin)) {
            int fuelLeft = this.getFuelStored(coin);
            int amountToSet = fuelLeft - amountToRemove;
            if (fuelLeft >= amountToRemove) {
                if (!simulate) {
                    if (amountToSet == -1) {
                        amountToSet = 0;
                    }
                    this.setFuelStored(coin, amountToSet);
                    pedestal.update();
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static int getItemFuelBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        int burnTime = ForgeHooks.getBurnTime((ItemStack)fuel);
        return burnTime;
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        int getBurnTimeForStack;
        ItemStack getItemStack;
        if (!world.field_72995_K && !world.func_175640_z(posPedestal) && entityIn instanceof ItemEntity && ItemUpgradeEnergyGenerator.getItemFuelBurnTime(getItemStack = ((ItemEntity)entityIn).func_92059_d()) > 0 && this.addFuel(tilePedestal, getBurnTimeForStack = ItemUpgradeEnergyGenerator.getItemFuelBurnTime(getItemStack) * getItemStack.func_190916_E(), true)) {
            this.addFuel(tilePedestal, getBurnTimeForStack, false);
            if (getItemStack.func_77973_b().equals(Items.field_151129_at)) {
                ItemStack getReturned = new ItemStack((IItemProvider)Items.field_151133_ar, getItemStack.func_190916_E());
                ItemEntity items1 = new ItemEntity(world, (double)posPedestal.func_177958_n() + 0.5, (double)posPedestal.func_177956_o() + 1.0, (double)posPedestal.func_177952_p() + 0.5, getReturned);
                if (!tilePedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)posPedestal.func_177958_n(), (double)posPedestal.func_177956_o(), (double)posPedestal.func_177952_p(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.25f, 1.0f);
                }
                entityIn.func_70106_y();
                world.func_217376_c((Entity)items1);
            }
            if (!tilePedestal.hasMuffler()) {
                world.func_184148_a((PlayerEntity)null, (double)posPedestal.func_177958_n(), (double)posPedestal.func_177956_o(), (double)posPedestal.func_177952_p(), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.25f, 1.0f);
            }
            entityIn.func_70106_y();
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int fuelLeft = this.getFuelStored(pedestal.getCoinOnPedestal());
        TranslationTextComponent fuel = new TranslationTextComponent(this.func_77658_a() + ".chat_fuel");
        fuel.func_240702_b_("" + fuelLeft + "");
        fuel.func_240699_a_(TextFormatting.DARK_GREEN);
        player.func_145747_a((ITextComponent)fuel, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_rfstored");
        xpstored.func_240702_b_("" + this.getEnergyStored(stack) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        int opSpeed = this.getOperationSpeed(stack);
        double capacityRate = this.getCapicityModifier(stack);
        double speedMultiplier = 20 / opSpeed;
        int rfPerTick = (int)(12.5 * speedMultiplier);
        TranslationTextComponent energyRate = new TranslationTextComponent(this.func_77658_a() + ".chat_rfrate");
        energyRate.func_240702_b_("" + rfPerTick + "");
        energyRate.func_240699_a_(TextFormatting.AQUA);
        player.func_145747_a((ITextComponent)energyRate, Util.field_240973_b_);
        int capacityRateModified = (int)Math.round((1.0 - this.getCapicityModifier(stack)) * 100.0);
        TranslationTextComponent rate2 = new TranslationTextComponent(this.func_77658_a() + ".chat_rfrate2");
        rate2.func_240702_b_("" + capacityRateModified + "%");
        rate2.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate2, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)name);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        TranslationTextComponent fuelStored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fuelstored");
        fuelStored.func_240702_b_("" + this.getFuelStored(stack) + "");
        fuelStored.func_240699_a_(TextFormatting.DARK_GREEN);
        tooltip.add((ITextComponent)fuelStored);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rfstored");
        xpstored.func_240702_b_("" + this.getEnergyStored(stack) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        tooltip.add((ITextComponent)xpstored);
        TranslationTextComponent xpcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rfcapacity");
        xpcapacity.func_240702_b_("" + this.getEnergyBuffer(stack) + "");
        xpcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)xpcapacity);
        int opSpeed = this.getOperationSpeed(stack);
        double speedMultiplier = 20 / opSpeed;
        int rfPerTick = (int)(12.5 * speedMultiplier);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + rfPerTick + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        int capacityRate = (int)Math.round((1.0 - this.getCapicityModifier(stack)) * 100.0);
        TranslationTextComponent rate2 = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate2");
        rate2.func_240702_b_("" + capacityRate + "%");
        rate2.func_240699_a_(TextFormatting.DARK_GRAY);
        tooltip.add((ITextComponent)rate2);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)RFFUELGEN);
    }
}

