/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.augments;

import com.mowmaster.pedestals.item.augments.ItemPedestalUpgrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemPedestalRenderAugment
extends ItemPedestalUpgrades {
    public int pedestalRenderType = 0;
    public static final Item RENDERAUGMENT = (Item)new ItemPedestalRenderAugment().setRegistryName(new ResourceLocation("pedestals", "upgraderenderaugment"));

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        RayTraceResult result = p_77659_2_.func_213324_a(5.0, 0.0f, false);
        if (result != null && result.func_216346_c() == RayTraceResult.Type.MISS && p_77659_2_.func_213453_ef()) {
            ItemStack itemInHand = p_77659_2_.func_184586_b(p_77659_3_);
            if (itemInHand.func_77973_b() instanceof ItemPedestalRenderAugment) {
                int next = this.nextAugmentType(itemInHand);
                this.setAugmentType(itemInHand, next);
                TranslationTextComponent changed = new TranslationTextComponent("pedestals.augments.chat_augmentchange");
                switch (next) {
                    case 0: {
                        changed = new TranslationTextComponent("pedestals.augments.chat_augment_both");
                        changed.func_240699_a_(TextFormatting.RED);
                        break;
                    }
                    case 1: {
                        changed = new TranslationTextComponent("pedestals.augments.chat_augment_upgrade");
                        changed.func_240699_a_(TextFormatting.GREEN);
                        break;
                    }
                    case 2: {
                        changed = new TranslationTextComponent("pedestals.augments.chat_augment_item");
                        changed.func_240699_a_(TextFormatting.BLUE);
                        break;
                    }
                    default: {
                        changed = new TranslationTextComponent("pedestals.augments.chat_augment_both");
                        changed.func_240699_a_(TextFormatting.RED);
                    }
                }
                p_77659_2_.func_146105_b((ITextComponent)changed, true);
                return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
            return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
        }
        return super.func_77659_a(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    public int getAugmentType(ItemStack augmentItem) {
        this.getAugmentTypeFromNBT(augmentItem);
        return this.pedestalRenderType;
    }

    public int nextAugmentType(ItemStack augmentItem) {
        int next = this.getAugmentType(augmentItem) + 1;
        int nextFinal = next > 2 ? 0 : next;
        return nextFinal;
    }

    public void setAugmentType(ItemStack augmentItem, int augmentSet) {
        this.pedestalRenderType = augmentSet;
        this.writeAugmentTypeToNBT(augmentItem);
    }

    public static int getColorFromNBT(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("augment_type")) {
            CompoundNBT getCompound = stack.func_77978_p();
            int renderType = getCompound.func_74762_e("augment_type");
            if (renderType == 0) {
                return 255;
            }
            if (renderType == 1) {
                return 65280;
            }
            if (renderType == 2) {
                return 0xFF0000;
            }
        }
        return 255;
    }

    private void writeAugmentTypeToNBT(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("augment_type", this.pedestalRenderType);
        stack.func_77982_d(compound);
    }

    private int getAugmentTypeFromNBT(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            this.pedestalRenderType = getCompound.func_74762_e("augment_type");
        }
        return this.pedestalRenderType;
    }

    public static void handleItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((itemstack, tintIndex) -> {
            if (tintIndex == 1) {
                return ItemPedestalRenderAugment.getColorFromNBT(itemstack);
            }
            return -1;
        }, new IItemProvider[]{RENDERAUGMENT});
    }

    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)RENDERAUGMENT);
    }
}

