/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.client.RenderPedestalOutline;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mowmaster.pedestals.client.RenderPedestalOutline.RenderPedestalType;
import com.mowmaster.pedestals.item.ItemLinkingTool;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class RenderPedestalOutline {
    public static void render(RenderWorldLastEvent event) {
        ItemStack stack;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack itemStack = stack = player.func_184592_cb().func_77973_b() instanceof ItemLinkingTool ? player.func_184592_cb() : player.func_184614_ca();
        if (stack.func_77948_v() && stack.func_77973_b() instanceof ItemLinkingTool) {
            ItemLinkingTool LT = (ItemLinkingTool)stack.func_77973_b();
            if (stack.func_77942_o()) {
                LT.getPosFromNBT(stack);
                BlockPos pos = LT.getStoredPosition(stack);
                List<BlockPos> storedRecievers = LT.getStoredPositionList(stack);
                RenderPedestalOutline.locateTileEntities(player, event.getMatrixStack(), pos, storedRecievers);
            }
        }
    }

    public static BlockPos getNegRangePosEntity(World world, BlockPos posOfPedestal, int intWidth, int intHeight) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(-intWidth, 0, -intWidth);
            }
            case DOWN: {
                return blockBelow.func_177982_a(-intWidth, -intHeight, -intWidth);
            }
            case NORTH: {
                return blockBelow.func_177982_a(-intWidth, -intWidth, -intHeight);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(-intWidth, -intWidth, 0);
            }
            case EAST: {
                return blockBelow.func_177982_a(0, -intWidth, -intWidth);
            }
            case WEST: {
                return blockBelow.func_177982_a(-intHeight, -intWidth, -intWidth);
            }
        }
        return blockBelow;
    }

    public static BlockPos getPosRangePosEntity(World world, BlockPos posOfPedestal, int intWidth, int intHeight) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(intWidth + 1, intHeight, intWidth + 1);
            }
            case DOWN: {
                return blockBelow.func_177982_a(intWidth + 1, 0, intWidth + 1);
            }
            case NORTH: {
                return blockBelow.func_177982_a(intWidth + 1, intWidth, 1);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(intWidth + 1, intWidth, intHeight + 1);
            }
            case EAST: {
                return blockBelow.func_177982_a(intHeight + 1, intWidth, intWidth + 1);
            }
            case WEST: {
                return blockBelow.func_177982_a(1, intWidth, intWidth + 1);
            }
        }
        return blockBelow;
    }

    private static void blueLine(IVertexBuilder builder, Matrix4f positionMatrix, BlockPos pos, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2) {
        builder.func_227888_a_(positionMatrix, (float)pos.func_177958_n() + dx1, (float)pos.func_177956_o() + dy1, (float)pos.func_177952_p() + dz1).func_227885_a_(0.95f, 0.95f, 0.95f, 1.0f).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)pos.func_177958_n() + dx2, (float)pos.func_177956_o() + dy2, (float)pos.func_177952_p() + dz2).func_227885_a_(0.95f, 0.95f, 0.95f, 1.0f).func_181675_d();
    }

    private static void areaLine(IVertexBuilder builder, Matrix4f positionMatrix, BlockPos pos, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2) {
        builder.func_227888_a_(positionMatrix, (float)pos.func_177958_n() + dx1, (float)pos.func_177956_o() + dy1, (float)pos.func_177952_p() + dz1).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)pos.func_177958_n() + dx2, (float)pos.func_177956_o() + dy2, (float)pos.func_177952_p() + dz2).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
    }

    private static void workAreaLine(IVertexBuilder builder, Matrix4f positionMatrix, BlockPos pos, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2) {
        builder.func_227888_a_(positionMatrix, (float)pos.func_177958_n() + dx1, (float)pos.func_177956_o() + dy1, (float)pos.func_177952_p() + dz1).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)pos.func_177958_n() + dx2, (float)pos.func_177956_o() + dy2, (float)pos.func_177952_p() + dz2).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
    }

    private static void locateTileEntities(ClientPlayerEntity player, MatrixStack matrixStack, BlockPos storedPos, List<BlockPos> storedRecievers) {
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(RenderPedestalType.OVERLAY_LINES);
        World world = player.func_130014_f_();
        matrixStack.func_227860_a_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        int locationsNum = storedRecievers.size();
        for (int i = 0; i < locationsNum; ++i) {
            BlockPos pos = storedRecievers.get(i);
            if (world.func_175625_s(pos) == null) continue;
            RenderPedestalOutline.blueLine(builder, matrix, pos, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f);
            RenderPedestalOutline.blueLine(builder, matrix, pos, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (world.func_175625_s(storedPos) != null && world.func_175625_s(storedPos) instanceof PedestalTileEntity) {
            int range;
            PedestalTileEntity pedestal = (PedestalTileEntity)world.func_175625_s(storedPos);
            int zmax = range = pedestal.getLinkingRange();
            int xmax = range;
            int ymax = range;
            int lineLength = zmax + xmax + 1;
            int lineLength2 = zmax + xmax + 1;
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), 0.0f, 0.0f, 0.0f, -lineLength, 0.0f, 0.0f);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), 0.0f, -lineLength, 0.0f, -lineLength, -lineLength, 0.0f);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), 0.0f, 0.0f, -lineLength, -lineLength, 0.0f, -lineLength);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), 0.0f, -lineLength, -lineLength, -lineLength, -lineLength, -lineLength);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -lineLength);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), -lineLength, 0.0f, 0.0f, -lineLength, 0.0f, -lineLength);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), 0.0f, -lineLength, 0.0f, 0.0f, -lineLength, -lineLength);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), -lineLength, -lineLength, 0.0f, -lineLength, -lineLength, -lineLength);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), 0.0f, 0.0f, 0.0f, 0.0f, -lineLength, 0.0f);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), -lineLength, 0.0f, 0.0f, -lineLength, -lineLength, 0.0f);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), 0.0f, 0.0f, -lineLength, 0.0f, -lineLength, -lineLength);
            RenderPedestalOutline.areaLine(builder, matrix, storedPos.func_177982_a(xmax + 1, ymax + 1, zmax + 1), -lineLength, 0.0f, -lineLength, -lineLength, -lineLength, -lineLength);
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(RenderPedestalType.OVERLAY_LINES);
    }

    private static void showWorkArea(ClientPlayerEntity player, MatrixStack matrixStack, BlockPos storedPos, int[] workArea) {
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(RenderPedestalType.OVERLAY_LINES);
        World world = player.func_130014_f_();
        matrixStack.func_227860_a_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        if (world.func_175625_s(storedPos) != null && world.func_175625_s(storedPos) instanceof PedestalTileEntity) {
            int z = workArea[2];
            int x = workArea[0];
            int y = workArea[1];
            BlockState state = world.func_180495_p(storedPos);
            Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            BlockPos negBlock = RenderPedestalOutline.getNegRangePosEntity(world, storedPos, z, y);
            BlockPos posBlock = RenderPedestalOutline.getPosRangePosEntity(world, storedPos, z, y);
            int xdiff = posBlock.func_177958_n() - negBlock.func_177958_n();
            int ydiff = posBlock.func_177956_o() - negBlock.func_177956_o();
            int zdiff = posBlock.func_177952_p() - negBlock.func_177952_p();
            System.out.print(xdiff);
            System.out.print(" x ");
            System.out.print(ydiff);
            System.out.print(" x ");
            System.out.print(zdiff);
            int lineLength = zdiff + xdiff + 1;
            int lineLength2 = zdiff + xdiff + 1;
            RenderPedestalOutline.workAreaLine(builder, matrix, negBlock.func_177982_a(xdiff + 1, ydiff, zdiff + 1), 0.0f, 0.0f, 0.0f, -lineLength, 0.0f, 0.0f);
            RenderPedestalOutline.workAreaLine(builder, matrix, negBlock.func_177982_a(xdiff + 1, ydiff, zdiff + 1), 0.0f, lineLength, 0.0f, -lineLength, lineLength, 0.0f);
            RenderPedestalOutline.workAreaLine(builder, matrix, negBlock.func_177982_a(xdiff + 1, ydiff, zdiff + 1), 0.0f, 0.0f, -lineLength, -lineLength, 0.0f, -lineLength);
            RenderPedestalOutline.workAreaLine(builder, matrix, negBlock.func_177982_a(xdiff + 1, ydiff, zdiff + 1), 0.0f, lineLength, -lineLength, -lineLength, lineLength, -lineLength);
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(RenderPedestalType.OVERLAY_LINES);
    }
}

